package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T13:11:49.870Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListenerRule")
public class CfnListenerRule extends software.amazon.awscdk.core.CfnResource {
    protected CfnListenerRule(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::ListenerRule`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnListenerRule(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object getActions() {
        return this.jsiiGet("actions", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object getConditions() {
        return this.jsiiGet("conditions", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConditions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("conditions", java.util.Objects.requireNonNull(value, "conditions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConditions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("conditions", java.util.Objects.requireNonNull(value, "conditions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getListenerArn() {
        return this.jsiiGet("listenerArn", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setListenerArn(final java.lang.String value) {
        this.jsiiSet("listenerArn", java.util.Objects.requireNonNull(value, "listenerArn is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number getPriority() {
        return this.jsiiGet("priority", java.lang.Number.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPriority(final java.lang.Number value) {
        this.jsiiSet("priority", java.util.Objects.requireNonNull(value, "priority is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.ActionProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getType();
        /**
         * `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticatecognitoconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getAuthenticateCognitoConfig();
        /**
         * `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticateoidcconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getAuthenticateOidcConfig();
        /**
         * `CfnListenerRule.ActionProperty.FixedResponseConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-fixedresponseconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getFixedResponseConfig();
        /**
         * `CfnListenerRule.ActionProperty.Order`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-order
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getOrder();
        /**
         * `CfnListenerRule.ActionProperty.RedirectConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-redirectconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRedirectConfig();
        /**
         * `CfnListenerRule.ActionProperty.TargetGroupArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getTargetGroupArn();

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.Object _authenticateCognitoConfig;
            @javax.annotation.Nullable
            private java.lang.Object _authenticateOidcConfig;
            @javax.annotation.Nullable
            private java.lang.Object _fixedResponseConfig;
            @javax.annotation.Nullable
            private java.lang.Number _order;
            @javax.annotation.Nullable
            private java.lang.Object _redirectConfig;
            @javax.annotation.Nullable
            private java.lang.String _targetGroupArn;

            /**
             * Sets the value of Type
             * @param value `CfnListenerRule.ActionProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of AuthenticateCognitoConfig
             * @param value `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._authenticateCognitoConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateCognitoConfig
             * @param value `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateCognitoConfigProperty value) {
                this._authenticateCognitoConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateOidcConfig
             * @param value `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._authenticateOidcConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateOidcConfig
             * @param value `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateOidcConfigProperty value) {
                this._authenticateOidcConfig = value;
                return this;
            }
            /**
             * Sets the value of FixedResponseConfig
             * @param value `CfnListenerRule.ActionProperty.FixedResponseConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._fixedResponseConfig = value;
                return this;
            }
            /**
             * Sets the value of FixedResponseConfig
             * @param value `CfnListenerRule.ActionProperty.FixedResponseConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.FixedResponseConfigProperty value) {
                this._fixedResponseConfig = value;
                return this;
            }
            /**
             * Sets the value of Order
             * @param value `CfnListenerRule.ActionProperty.Order`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOrder(@javax.annotation.Nullable final java.lang.Number value) {
                this._order = value;
                return this;
            }
            /**
             * Sets the value of RedirectConfig
             * @param value `CfnListenerRule.ActionProperty.RedirectConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._redirectConfig = value;
                return this;
            }
            /**
             * Sets the value of RedirectConfig
             * @param value `CfnListenerRule.ActionProperty.RedirectConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.RedirectConfigProperty value) {
                this._redirectConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupArn
             * @param value `CfnListenerRule.ActionProperty.TargetGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTargetGroupArn(@javax.annotation.Nullable final java.lang.String value) {
                this._targetGroupArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ActionProperty build() {
                return new ActionProperty() {
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $authenticateCognitoConfig = _authenticateCognitoConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $authenticateOidcConfig = _authenticateOidcConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $fixedResponseConfig = _fixedResponseConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Number $order = _order;
                    @javax.annotation.Nullable
                    private final java.lang.Object $redirectConfig = _redirectConfig;
                    @javax.annotation.Nullable
                    private final java.lang.String $targetGroupArn = _targetGroupArn;

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.lang.Object getAuthenticateCognitoConfig() {
                        return this.$authenticateCognitoConfig;
                    }

                    @Override
                    public java.lang.Object getAuthenticateOidcConfig() {
                        return this.$authenticateOidcConfig;
                    }

                    @Override
                    public java.lang.Object getFixedResponseConfig() {
                        return this.$fixedResponseConfig;
                    }

                    @Override
                    public java.lang.Number getOrder() {
                        return this.$order;
                    }

                    @Override
                    public java.lang.Object getRedirectConfig() {
                        return this.$redirectConfig;
                    }

                    @Override
                    public java.lang.String getTargetGroupArn() {
                        return this.$targetGroupArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree(this.getType()));
                        if (this.getAuthenticateCognitoConfig() != null) {
                            obj.set("authenticateCognitoConfig", om.valueToTree(this.getAuthenticateCognitoConfig()));
                        }
                        if (this.getAuthenticateOidcConfig() != null) {
                            obj.set("authenticateOidcConfig", om.valueToTree(this.getAuthenticateOidcConfig()));
                        }
                        if (this.getFixedResponseConfig() != null) {
                            obj.set("fixedResponseConfig", om.valueToTree(this.getFixedResponseConfig()));
                        }
                        if (this.getOrder() != null) {
                            obj.set("order", om.valueToTree(this.getOrder()));
                        }
                        if (this.getRedirectConfig() != null) {
                            obj.set("redirectConfig", om.valueToTree(this.getRedirectConfig()));
                        }
                        if (this.getTargetGroupArn() != null) {
                            obj.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.ActionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.ActionProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticatecognitoconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticateCognitoConfig() {
                return this.jsiiGet("authenticateCognitoConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticateoidcconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticateOidcConfig() {
                return this.jsiiGet("authenticateOidcConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.ActionProperty.FixedResponseConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-fixedresponseconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getFixedResponseConfig() {
                return this.jsiiGet("fixedResponseConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.ActionProperty.Order`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-order
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getOrder() {
                return this.jsiiGet("order", java.lang.Number.class);
            }

            /**
             * `CfnListenerRule.ActionProperty.RedirectConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-redirectconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getRedirectConfig() {
                return this.jsiiGet("redirectConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.ActionProperty.TargetGroupArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getTargetGroupArn() {
                return this.jsiiGet("targetGroupArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticateCognitoConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getUserPoolArn();
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolClientId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolclientid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getUserPoolClientId();
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolDomain`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpooldomain
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getUserPoolDomain();
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-authenticationrequestextraparams
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getAuthenticationRequestExtraParams();
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-onunauthenticatedrequest
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getOnUnauthenticatedRequest();
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.Scope`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-scope
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getScope();
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionCookieName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessioncookiename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSessionCookieName();
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionTimeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessiontimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getSessionTimeout();

        /**
         * @return a {@link Builder} of {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _userPoolArn;
            private java.lang.String _userPoolClientId;
            private java.lang.String _userPoolDomain;
            @javax.annotation.Nullable
            private java.lang.Object _authenticationRequestExtraParams;
            @javax.annotation.Nullable
            private java.lang.String _onUnauthenticatedRequest;
            @javax.annotation.Nullable
            private java.lang.String _scope;
            @javax.annotation.Nullable
            private java.lang.String _sessionCookieName;
            @javax.annotation.Nullable
            private java.lang.Number _sessionTimeout;

            /**
             * Sets the value of UserPoolArn
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withUserPoolArn(final java.lang.String value) {
                this._userPoolArn = java.util.Objects.requireNonNull(value, "userPoolArn is required");
                return this;
            }
            /**
             * Sets the value of UserPoolClientId
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolClientId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withUserPoolClientId(final java.lang.String value) {
                this._userPoolClientId = java.util.Objects.requireNonNull(value, "userPoolClientId is required");
                return this;
            }
            /**
             * Sets the value of UserPoolDomain
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolDomain`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withUserPoolDomain(final java.lang.String value) {
                this._userPoolDomain = java.util.Objects.requireNonNull(value, "userPoolDomain is required");
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                this._onUnauthenticatedRequest = value;
                return this;
            }
            /**
             * Sets the value of Scope
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.Scope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withScope(@javax.annotation.Nullable final java.lang.String value) {
                this._scope = value;
                return this;
            }
            /**
             * Sets the value of SessionCookieName
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionCookieName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                this._sessionCookieName = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                this._sessionTimeout = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateCognitoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public AuthenticateCognitoConfigProperty build() {
                return new AuthenticateCognitoConfigProperty() {
                    private final java.lang.String $userPoolArn = java.util.Objects.requireNonNull(_userPoolArn, "userPoolArn is required");
                    private final java.lang.String $userPoolClientId = java.util.Objects.requireNonNull(_userPoolClientId, "userPoolClientId is required");
                    private final java.lang.String $userPoolDomain = java.util.Objects.requireNonNull(_userPoolDomain, "userPoolDomain is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $authenticationRequestExtraParams = _authenticationRequestExtraParams;
                    @javax.annotation.Nullable
                    private final java.lang.String $onUnauthenticatedRequest = _onUnauthenticatedRequest;
                    @javax.annotation.Nullable
                    private final java.lang.String $scope = _scope;
                    @javax.annotation.Nullable
                    private final java.lang.String $sessionCookieName = _sessionCookieName;
                    @javax.annotation.Nullable
                    private final java.lang.Number $sessionTimeout = _sessionTimeout;

                    @Override
                    public java.lang.String getUserPoolArn() {
                        return this.$userPoolArn;
                    }

                    @Override
                    public java.lang.String getUserPoolClientId() {
                        return this.$userPoolClientId;
                    }

                    @Override
                    public java.lang.String getUserPoolDomain() {
                        return this.$userPoolDomain;
                    }

                    @Override
                    public java.lang.Object getAuthenticationRequestExtraParams() {
                        return this.$authenticationRequestExtraParams;
                    }

                    @Override
                    public java.lang.String getOnUnauthenticatedRequest() {
                        return this.$onUnauthenticatedRequest;
                    }

                    @Override
                    public java.lang.String getScope() {
                        return this.$scope;
                    }

                    @Override
                    public java.lang.String getSessionCookieName() {
                        return this.$sessionCookieName;
                    }

                    @Override
                    public java.lang.Number getSessionTimeout() {
                        return this.$sessionTimeout;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                        obj.set("userPoolClientId", om.valueToTree(this.getUserPoolClientId()));
                        obj.set("userPoolDomain", om.valueToTree(this.getUserPoolDomain()));
                        if (this.getAuthenticationRequestExtraParams() != null) {
                            obj.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                        }
                        if (this.getOnUnauthenticatedRequest() != null) {
                            obj.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                        }
                        if (this.getScope() != null) {
                            obj.set("scope", om.valueToTree(this.getScope()));
                        }
                        if (this.getSessionCookieName() != null) {
                            obj.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                        }
                        if (this.getSessionTimeout() != null) {
                            obj.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateCognitoConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolarn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getUserPoolArn() {
                return this.jsiiGet("userPoolArn", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolClientId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolclientid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getUserPoolClientId() {
                return this.jsiiGet("userPoolClientId", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolDomain`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpooldomain
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getUserPoolDomain() {
                return this.jsiiGet("userPoolDomain", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-authenticationrequestextraparams
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-onunauthenticatedrequest
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getOnUnauthenticatedRequest() {
                return this.jsiiGet("onUnauthenticatedRequest", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateCognitoConfigProperty.Scope`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-scope
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getScope() {
                return this.jsiiGet("scope", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionCookieName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessioncookiename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSessionCookieName() {
                return this.jsiiGet("sessionCookieName", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionTimeout`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessiontimeout
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getSessionTimeout() {
                return this.jsiiGet("sessionTimeout", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticateOidcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authorizationendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getAuthorizationEndpoint();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getClientId();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientSecret`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientsecret
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getClientSecret();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.Issuer`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-issuer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getIssuer();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.TokenEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-tokenendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getTokenEndpoint();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-userinfoendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getUserInfoEndpoint();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authenticationrequestextraparams
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getAuthenticationRequestExtraParams();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-onunauthenticatedrequest
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getOnUnauthenticatedRequest();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.Scope`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-scope
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getScope();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionCookieName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessioncookiename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSessionCookieName();
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionTimeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessiontimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getSessionTimeout();

        /**
         * @return a {@link Builder} of {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _authorizationEndpoint;
            private java.lang.String _clientId;
            private java.lang.String _clientSecret;
            private java.lang.String _issuer;
            private java.lang.String _tokenEndpoint;
            private java.lang.String _userInfoEndpoint;
            @javax.annotation.Nullable
            private java.lang.Object _authenticationRequestExtraParams;
            @javax.annotation.Nullable
            private java.lang.String _onUnauthenticatedRequest;
            @javax.annotation.Nullable
            private java.lang.String _scope;
            @javax.annotation.Nullable
            private java.lang.String _sessionCookieName;
            @javax.annotation.Nullable
            private java.lang.Number _sessionTimeout;

            /**
             * Sets the value of AuthorizationEndpoint
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthorizationEndpoint(final java.lang.String value) {
                this._authorizationEndpoint = java.util.Objects.requireNonNull(value, "authorizationEndpoint is required");
                return this;
            }
            /**
             * Sets the value of ClientId
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.ClientId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withClientId(final java.lang.String value) {
                this._clientId = java.util.Objects.requireNonNull(value, "clientId is required");
                return this;
            }
            /**
             * Sets the value of ClientSecret
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.ClientSecret`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withClientSecret(final java.lang.String value) {
                this._clientSecret = java.util.Objects.requireNonNull(value, "clientSecret is required");
                return this;
            }
            /**
             * Sets the value of Issuer
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.Issuer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIssuer(final java.lang.String value) {
                this._issuer = java.util.Objects.requireNonNull(value, "issuer is required");
                return this;
            }
            /**
             * Sets the value of TokenEndpoint
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.TokenEndpoint`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTokenEndpoint(final java.lang.String value) {
                this._tokenEndpoint = java.util.Objects.requireNonNull(value, "tokenEndpoint is required");
                return this;
            }
            /**
             * Sets the value of UserInfoEndpoint
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withUserInfoEndpoint(final java.lang.String value) {
                this._userInfoEndpoint = java.util.Objects.requireNonNull(value, "userInfoEndpoint is required");
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                this._onUnauthenticatedRequest = value;
                return this;
            }
            /**
             * Sets the value of Scope
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.Scope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withScope(@javax.annotation.Nullable final java.lang.String value) {
                this._scope = value;
                return this;
            }
            /**
             * Sets the value of SessionCookieName
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.SessionCookieName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                this._sessionCookieName = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value `CfnListenerRule.AuthenticateOidcConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                this._sessionTimeout = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateOidcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public AuthenticateOidcConfigProperty build() {
                return new AuthenticateOidcConfigProperty() {
                    private final java.lang.String $authorizationEndpoint = java.util.Objects.requireNonNull(_authorizationEndpoint, "authorizationEndpoint is required");
                    private final java.lang.String $clientId = java.util.Objects.requireNonNull(_clientId, "clientId is required");
                    private final java.lang.String $clientSecret = java.util.Objects.requireNonNull(_clientSecret, "clientSecret is required");
                    private final java.lang.String $issuer = java.util.Objects.requireNonNull(_issuer, "issuer is required");
                    private final java.lang.String $tokenEndpoint = java.util.Objects.requireNonNull(_tokenEndpoint, "tokenEndpoint is required");
                    private final java.lang.String $userInfoEndpoint = java.util.Objects.requireNonNull(_userInfoEndpoint, "userInfoEndpoint is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $authenticationRequestExtraParams = _authenticationRequestExtraParams;
                    @javax.annotation.Nullable
                    private final java.lang.String $onUnauthenticatedRequest = _onUnauthenticatedRequest;
                    @javax.annotation.Nullable
                    private final java.lang.String $scope = _scope;
                    @javax.annotation.Nullable
                    private final java.lang.String $sessionCookieName = _sessionCookieName;
                    @javax.annotation.Nullable
                    private final java.lang.Number $sessionTimeout = _sessionTimeout;

                    @Override
                    public java.lang.String getAuthorizationEndpoint() {
                        return this.$authorizationEndpoint;
                    }

                    @Override
                    public java.lang.String getClientId() {
                        return this.$clientId;
                    }

                    @Override
                    public java.lang.String getClientSecret() {
                        return this.$clientSecret;
                    }

                    @Override
                    public java.lang.String getIssuer() {
                        return this.$issuer;
                    }

                    @Override
                    public java.lang.String getTokenEndpoint() {
                        return this.$tokenEndpoint;
                    }

                    @Override
                    public java.lang.String getUserInfoEndpoint() {
                        return this.$userInfoEndpoint;
                    }

                    @Override
                    public java.lang.Object getAuthenticationRequestExtraParams() {
                        return this.$authenticationRequestExtraParams;
                    }

                    @Override
                    public java.lang.String getOnUnauthenticatedRequest() {
                        return this.$onUnauthenticatedRequest;
                    }

                    @Override
                    public java.lang.String getScope() {
                        return this.$scope;
                    }

                    @Override
                    public java.lang.String getSessionCookieName() {
                        return this.$sessionCookieName;
                    }

                    @Override
                    public java.lang.Number getSessionTimeout() {
                        return this.$sessionTimeout;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
                        obj.set("clientId", om.valueToTree(this.getClientId()));
                        obj.set("clientSecret", om.valueToTree(this.getClientSecret()));
                        obj.set("issuer", om.valueToTree(this.getIssuer()));
                        obj.set("tokenEndpoint", om.valueToTree(this.getTokenEndpoint()));
                        obj.set("userInfoEndpoint", om.valueToTree(this.getUserInfoEndpoint()));
                        if (this.getAuthenticationRequestExtraParams() != null) {
                            obj.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                        }
                        if (this.getOnUnauthenticatedRequest() != null) {
                            obj.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                        }
                        if (this.getScope() != null) {
                            obj.set("scope", om.valueToTree(this.getScope()));
                        }
                        if (this.getSessionCookieName() != null) {
                            obj.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                        }
                        if (this.getSessionTimeout() != null) {
                            obj.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateOidcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authorizationendpoint
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getAuthorizationEndpoint() {
                return this.jsiiGet("authorizationEndpoint", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getClientId() {
                return this.jsiiGet("clientId", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientSecret`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientsecret
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getClientSecret() {
                return this.jsiiGet("clientSecret", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.Issuer`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-issuer
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getIssuer() {
                return this.jsiiGet("issuer", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.TokenEndpoint`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-tokenendpoint
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getTokenEndpoint() {
                return this.jsiiGet("tokenEndpoint", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-userinfoendpoint
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getUserInfoEndpoint() {
                return this.jsiiGet("userInfoEndpoint", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authenticationrequestextraparams
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-onunauthenticatedrequest
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getOnUnauthenticatedRequest() {
                return this.jsiiGet("onUnauthenticatedRequest", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.Scope`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-scope
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getScope() {
                return this.jsiiGet("scope", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionCookieName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessioncookiename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSessionCookieName() {
                return this.jsiiGet("sessionCookieName", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionTimeout`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessiontimeout
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getSessionTimeout() {
                return this.jsiiGet("sessionTimeout", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FixedResponseConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStatusCode();
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.ContentType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-contenttype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getContentType();
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.MessageBody`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-messagebody
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getMessageBody();

        /**
         * @return a {@link Builder} of {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _statusCode;
            @javax.annotation.Nullable
            private java.lang.String _contentType;
            @javax.annotation.Nullable
            private java.lang.String _messageBody;

            /**
             * Sets the value of StatusCode
             * @param value `CfnListenerRule.FixedResponseConfigProperty.StatusCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of ContentType
             * @param value `CfnListenerRule.FixedResponseConfigProperty.ContentType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withContentType(@javax.annotation.Nullable final java.lang.String value) {
                this._contentType = value;
                return this;
            }
            /**
             * Sets the value of MessageBody
             * @param value `CfnListenerRule.FixedResponseConfigProperty.MessageBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMessageBody(@javax.annotation.Nullable final java.lang.String value) {
                this._messageBody = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedResponseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public FixedResponseConfigProperty build() {
                return new FixedResponseConfigProperty() {
                    private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $contentType = _contentType;
                    @javax.annotation.Nullable
                    private final java.lang.String $messageBody = _messageBody;

                    @Override
                    public java.lang.String getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public java.lang.String getContentType() {
                        return this.$contentType;
                    }

                    @Override
                    public java.lang.String getMessageBody() {
                        return this.$messageBody;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                        if (this.getContentType() != null) {
                            obj.set("contentType", om.valueToTree(this.getContentType()));
                        }
                        if (this.getMessageBody() != null) {
                            obj.set("messageBody", om.valueToTree(this.getMessageBody()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.FixedResponseConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.FixedResponseConfigProperty.StatusCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-statuscode
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.FixedResponseConfigProperty.ContentType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-contenttype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getContentType() {
                return this.jsiiGet("contentType", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.FixedResponseConfigProperty.MessageBody`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-messagebody
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getMessageBody() {
                return this.jsiiGet("messageBody", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostHeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.HostHeaderConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-hostheaderconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link HostHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link HostHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _values;

            /**
             * Sets the value of Values
             * @param value `CfnListenerRule.HostHeaderConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValues(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._values = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostHeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public HostHeaderConfigProperty build() {
                return new HostHeaderConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $values = _values;

                    @Override
                    public java.util.List<java.lang.String> getValues() {
                        return this.$values;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getValues() != null) {
                            obj.set("values", om.valueToTree(this.getValues()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HostHeaderConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.HostHeaderConfigProperty.Values`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-hostheaderconfig-values
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getValues() {
                return this.jsiiGet("values", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpHeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.HttpHeaderConfigProperty.HttpHeaderName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-httpheadername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getHttpHeaderName();
        /**
         * `CfnListenerRule.HttpHeaderConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link HttpHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link HttpHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _httpHeaderName;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _values;

            /**
             * Sets the value of HttpHeaderName
             * @param value `CfnListenerRule.HttpHeaderConfigProperty.HttpHeaderName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHttpHeaderName(@javax.annotation.Nullable final java.lang.String value) {
                this._httpHeaderName = value;
                return this;
            }
            /**
             * Sets the value of Values
             * @param value `CfnListenerRule.HttpHeaderConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValues(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._values = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpHeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public HttpHeaderConfigProperty build() {
                return new HttpHeaderConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $httpHeaderName = _httpHeaderName;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $values = _values;

                    @Override
                    public java.lang.String getHttpHeaderName() {
                        return this.$httpHeaderName;
                    }

                    @Override
                    public java.util.List<java.lang.String> getValues() {
                        return this.$values;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getHttpHeaderName() != null) {
                            obj.set("httpHeaderName", om.valueToTree(this.getHttpHeaderName()));
                        }
                        if (this.getValues() != null) {
                            obj.set("values", om.valueToTree(this.getValues()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HttpHeaderConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.HttpHeaderConfigProperty.HttpHeaderName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-httpheadername
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getHttpHeaderName() {
                return this.jsiiGet("httpHeaderName", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.HttpHeaderConfigProperty.Values`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-values
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getValues() {
                return this.jsiiGet("values", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpRequestMethodConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.HttpRequestMethodConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html#cfn-elasticloadbalancingv2-listenerrule-httprequestmethodconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link HttpRequestMethodConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link HttpRequestMethodConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _values;

            /**
             * Sets the value of Values
             * @param value `CfnListenerRule.HttpRequestMethodConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValues(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._values = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpRequestMethodConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public HttpRequestMethodConfigProperty build() {
                return new HttpRequestMethodConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $values = _values;

                    @Override
                    public java.util.List<java.lang.String> getValues() {
                        return this.$values;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getValues() != null) {
                            obj.set("values", om.valueToTree(this.getValues()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HttpRequestMethodConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.HttpRequestMethodConfigProperty.Values`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html#cfn-elasticloadbalancingv2-listenerrule-httprequestmethodconfig-values
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getValues() {
                return this.jsiiGet("values", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PathPatternConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.PathPatternConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html#cfn-elasticloadbalancingv2-listenerrule-pathpatternconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link PathPatternConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PathPatternConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _values;

            /**
             * Sets the value of Values
             * @param value `CfnListenerRule.PathPatternConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValues(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._values = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PathPatternConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public PathPatternConfigProperty build() {
                return new PathPatternConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $values = _values;

                    @Override
                    public java.util.List<java.lang.String> getValues() {
                        return this.$values;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getValues() != null) {
                            obj.set("values", om.valueToTree(this.getValues()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.PathPatternConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.PathPatternConfigProperty.Values`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html#cfn-elasticloadbalancingv2-listenerrule-pathpatternconfig-values
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getValues() {
                return this.jsiiGet("values", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryStringConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.QueryStringConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html#cfn-elasticloadbalancingv2-listenerrule-querystringconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getValues();

        /**
         * @return a {@link Builder} of {@link QueryStringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link QueryStringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _values;

            /**
             * Sets the value of Values
             * @param value `CfnListenerRule.QueryStringConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValues(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._values = value;
                return this;
            }
            /**
             * Sets the value of Values
             * @param value `CfnListenerRule.QueryStringConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValues(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._values = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public QueryStringConfigProperty build() {
                return new QueryStringConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $values = _values;

                    @Override
                    public java.lang.Object getValues() {
                        return this.$values;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getValues() != null) {
                            obj.set("values", om.valueToTree(this.getValues()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.QueryStringConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.QueryStringConfigProperty.Values`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html#cfn-elasticloadbalancingv2-listenerrule-querystringconfig-values
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getValues() {
                return this.jsiiGet("values", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryStringKeyValueProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.QueryStringKeyValueProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getKey();
        /**
         * `CfnListenerRule.QueryStringKeyValueProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link QueryStringKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link QueryStringKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value `CfnListenerRule.QueryStringKeyValueProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnListenerRule.QueryStringKeyValueProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringKeyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public QueryStringKeyValueProperty build() {
                return new QueryStringKeyValueProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $key = _key;
                    @javax.annotation.Nullable
                    private final java.lang.String $value = _value;

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getKey() != null) {
                            obj.set("key", om.valueToTree(this.getKey()));
                        }
                        if (this.getValue() != null) {
                            obj.set("value", om.valueToTree(this.getValue()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.QueryStringKeyValueProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.QueryStringKeyValueProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-key
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.QueryStringKeyValueProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-value
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.RedirectConfigProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getStatusCode();
        /**
         * `CfnListenerRule.RedirectConfigProperty.Host`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-host
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getHost();
        /**
         * `CfnListenerRule.RedirectConfigProperty.Path`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-path
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPath();
        /**
         * `CfnListenerRule.RedirectConfigProperty.Port`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-port
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPort();
        /**
         * `CfnListenerRule.RedirectConfigProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getProtocol();
        /**
         * `CfnListenerRule.RedirectConfigProperty.Query`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-query
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getQuery();

        /**
         * @return a {@link Builder} of {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _statusCode;
            @javax.annotation.Nullable
            private java.lang.String _host;
            @javax.annotation.Nullable
            private java.lang.String _path;
            @javax.annotation.Nullable
            private java.lang.String _port;
            @javax.annotation.Nullable
            private java.lang.String _protocol;
            @javax.annotation.Nullable
            private java.lang.String _query;

            /**
             * Sets the value of StatusCode
             * @param value `CfnListenerRule.RedirectConfigProperty.StatusCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of Host
             * @param value `CfnListenerRule.RedirectConfigProperty.Host`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHost(@javax.annotation.Nullable final java.lang.String value) {
                this._host = value;
                return this;
            }
            /**
             * Sets the value of Path
             * @param value `CfnListenerRule.RedirectConfigProperty.Path`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
                this._path = value;
                return this;
            }
            /**
             * Sets the value of Port
             * @param value `CfnListenerRule.RedirectConfigProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPort(@javax.annotation.Nullable final java.lang.String value) {
                this._port = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value `CfnListenerRule.RedirectConfigProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of Query
             * @param value `CfnListenerRule.RedirectConfigProperty.Query`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withQuery(@javax.annotation.Nullable final java.lang.String value) {
                this._query = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RedirectConfigProperty build() {
                return new RedirectConfigProperty() {
                    private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $host = _host;
                    @javax.annotation.Nullable
                    private final java.lang.String $path = _path;
                    @javax.annotation.Nullable
                    private final java.lang.String $port = _port;
                    @javax.annotation.Nullable
                    private final java.lang.String $protocol = _protocol;
                    @javax.annotation.Nullable
                    private final java.lang.String $query = _query;

                    @Override
                    public java.lang.String getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public java.lang.String getHost() {
                        return this.$host;
                    }

                    @Override
                    public java.lang.String getPath() {
                        return this.$path;
                    }

                    @Override
                    public java.lang.String getPort() {
                        return this.$port;
                    }

                    @Override
                    public java.lang.String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public java.lang.String getQuery() {
                        return this.$query;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                        if (this.getHost() != null) {
                            obj.set("host", om.valueToTree(this.getHost()));
                        }
                        if (this.getPath() != null) {
                            obj.set("path", om.valueToTree(this.getPath()));
                        }
                        if (this.getPort() != null) {
                            obj.set("port", om.valueToTree(this.getPort()));
                        }
                        if (this.getProtocol() != null) {
                            obj.set("protocol", om.valueToTree(this.getProtocol()));
                        }
                        if (this.getQuery() != null) {
                            obj.set("query", om.valueToTree(this.getQuery()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.RedirectConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.RedirectConfigProperty.StatusCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-statuscode
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.RedirectConfigProperty.Host`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-host
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getHost() {
                return this.jsiiGet("host", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.RedirectConfigProperty.Path`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-path
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getPath() {
                return this.jsiiGet("path", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.RedirectConfigProperty.Port`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-port
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getPort() {
                return this.jsiiGet("port", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.RedirectConfigProperty.Protocol`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-protocol
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getProtocol() {
                return this.jsiiGet("protocol", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.RedirectConfigProperty.Query`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-query
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getQuery() {
                return this.jsiiGet("query", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleConditionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.RuleConditionProperty.Field`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getField();
        /**
         * `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-hostheaderconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getHostHeaderConfig();
        /**
         * `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httpheaderconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getHttpHeaderConfig();
        /**
         * `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httprequestmethodconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getHttpRequestMethodConfig();
        /**
         * `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-pathpatternconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getPathPatternConfig();
        /**
         * `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-querystringconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getQueryStringConfig();
        /**
         * `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-sourceipconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getSourceIpConfig();
        /**
         * `CfnListenerRule.RuleConditionProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _field;
            @javax.annotation.Nullable
            private java.lang.Object _hostHeaderConfig;
            @javax.annotation.Nullable
            private java.lang.Object _httpHeaderConfig;
            @javax.annotation.Nullable
            private java.lang.Object _httpRequestMethodConfig;
            @javax.annotation.Nullable
            private java.lang.Object _pathPatternConfig;
            @javax.annotation.Nullable
            private java.lang.Object _queryStringConfig;
            @javax.annotation.Nullable
            private java.lang.Object _sourceIpConfig;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _values;

            /**
             * Sets the value of Field
             * @param value `CfnListenerRule.RuleConditionProperty.Field`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withField(@javax.annotation.Nullable final java.lang.String value) {
                this._field = value;
                return this;
            }
            /**
             * Sets the value of HostHeaderConfig
             * @param value `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHostHeaderConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._hostHeaderConfig = value;
                return this;
            }
            /**
             * Sets the value of HostHeaderConfig
             * @param value `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHostHeaderConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HostHeaderConfigProperty value) {
                this._hostHeaderConfig = value;
                return this;
            }
            /**
             * Sets the value of HttpHeaderConfig
             * @param value `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHttpHeaderConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._httpHeaderConfig = value;
                return this;
            }
            /**
             * Sets the value of HttpHeaderConfig
             * @param value `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHttpHeaderConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HttpHeaderConfigProperty value) {
                this._httpHeaderConfig = value;
                return this;
            }
            /**
             * Sets the value of HttpRequestMethodConfig
             * @param value `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHttpRequestMethodConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._httpRequestMethodConfig = value;
                return this;
            }
            /**
             * Sets the value of HttpRequestMethodConfig
             * @param value `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withHttpRequestMethodConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HttpRequestMethodConfigProperty value) {
                this._httpRequestMethodConfig = value;
                return this;
            }
            /**
             * Sets the value of PathPatternConfig
             * @param value `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPathPatternConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._pathPatternConfig = value;
                return this;
            }
            /**
             * Sets the value of PathPatternConfig
             * @param value `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPathPatternConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.PathPatternConfigProperty value) {
                this._pathPatternConfig = value;
                return this;
            }
            /**
             * Sets the value of QueryStringConfig
             * @param value `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withQueryStringConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._queryStringConfig = value;
                return this;
            }
            /**
             * Sets the value of QueryStringConfig
             * @param value `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withQueryStringConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.QueryStringConfigProperty value) {
                this._queryStringConfig = value;
                return this;
            }
            /**
             * Sets the value of SourceIpConfig
             * @param value `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSourceIpConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sourceIpConfig = value;
                return this;
            }
            /**
             * Sets the value of SourceIpConfig
             * @param value `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSourceIpConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.SourceIpConfigProperty value) {
                this._sourceIpConfig = value;
                return this;
            }
            /**
             * Sets the value of Values
             * @param value `CfnListenerRule.RuleConditionProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValues(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._values = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RuleConditionProperty build() {
                return new RuleConditionProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $field = _field;
                    @javax.annotation.Nullable
                    private final java.lang.Object $hostHeaderConfig = _hostHeaderConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $httpHeaderConfig = _httpHeaderConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $httpRequestMethodConfig = _httpRequestMethodConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $pathPatternConfig = _pathPatternConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $queryStringConfig = _queryStringConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sourceIpConfig = _sourceIpConfig;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $values = _values;

                    @Override
                    public java.lang.String getField() {
                        return this.$field;
                    }

                    @Override
                    public java.lang.Object getHostHeaderConfig() {
                        return this.$hostHeaderConfig;
                    }

                    @Override
                    public java.lang.Object getHttpHeaderConfig() {
                        return this.$httpHeaderConfig;
                    }

                    @Override
                    public java.lang.Object getHttpRequestMethodConfig() {
                        return this.$httpRequestMethodConfig;
                    }

                    @Override
                    public java.lang.Object getPathPatternConfig() {
                        return this.$pathPatternConfig;
                    }

                    @Override
                    public java.lang.Object getQueryStringConfig() {
                        return this.$queryStringConfig;
                    }

                    @Override
                    public java.lang.Object getSourceIpConfig() {
                        return this.$sourceIpConfig;
                    }

                    @Override
                    public java.util.List<java.lang.String> getValues() {
                        return this.$values;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getField() != null) {
                            obj.set("field", om.valueToTree(this.getField()));
                        }
                        if (this.getHostHeaderConfig() != null) {
                            obj.set("hostHeaderConfig", om.valueToTree(this.getHostHeaderConfig()));
                        }
                        if (this.getHttpHeaderConfig() != null) {
                            obj.set("httpHeaderConfig", om.valueToTree(this.getHttpHeaderConfig()));
                        }
                        if (this.getHttpRequestMethodConfig() != null) {
                            obj.set("httpRequestMethodConfig", om.valueToTree(this.getHttpRequestMethodConfig()));
                        }
                        if (this.getPathPatternConfig() != null) {
                            obj.set("pathPatternConfig", om.valueToTree(this.getPathPatternConfig()));
                        }
                        if (this.getQueryStringConfig() != null) {
                            obj.set("queryStringConfig", om.valueToTree(this.getQueryStringConfig()));
                        }
                        if (this.getSourceIpConfig() != null) {
                            obj.set("sourceIpConfig", om.valueToTree(this.getSourceIpConfig()));
                        }
                        if (this.getValues() != null) {
                            obj.set("values", om.valueToTree(this.getValues()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.RuleConditionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.RuleConditionProperty.Field`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getField() {
                return this.jsiiGet("field", java.lang.String.class);
            }

            /**
             * `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-hostheaderconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getHostHeaderConfig() {
                return this.jsiiGet("hostHeaderConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httpheaderconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getHttpHeaderConfig() {
                return this.jsiiGet("httpHeaderConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httprequestmethodconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getHttpRequestMethodConfig() {
                return this.jsiiGet("httpRequestMethodConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-pathpatternconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getPathPatternConfig() {
                return this.jsiiGet("pathPatternConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-querystringconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getQueryStringConfig() {
                return this.jsiiGet("queryStringConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-sourceipconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getSourceIpConfig() {
                return this.jsiiGet("sourceIpConfig", java.lang.Object.class);
            }

            /**
             * `CfnListenerRule.RuleConditionProperty.Values`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getValues() {
                return this.jsiiGet("values", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceIpConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListenerRule.SourceIpConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html#cfn-elasticloadbalancingv2-listenerrule-sourceipconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link SourceIpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceIpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _values;

            /**
             * Sets the value of Values
             * @param value `CfnListenerRule.SourceIpConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValues(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._values = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceIpConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SourceIpConfigProperty build() {
                return new SourceIpConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $values = _values;

                    @Override
                    public java.util.List<java.lang.String> getValues() {
                        return this.$values;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getValues() != null) {
                            obj.set("values", om.valueToTree(this.getValues()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.SourceIpConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListenerRule.SourceIpConfigProperty.Values`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html#cfn-elasticloadbalancingv2-listenerrule-sourceipconfig-values
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getValues() {
                return this.jsiiGet("values", java.util.List.class);
            }
        }
    }
}
