package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining an Application Load Balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:40:21.301Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps {
    /**
     * Indicates whether HTTP/2 is enabled.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getHttp2Enabled();
    /**
     * The load balancer idle timeout, in seconds.
     * 
     * Default: 60
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getIdleTimeout();
    /**
     * The type of IP addresses to use.
     * 
     * Only applies to application load balancers.
     * 
     * Default: IpAddressType.Ipv4
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType();
    /**
     * Security group to associate with this load balancer.
     * 
     * Default: A security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup();

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _http2Enabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _idleTimeout;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType _ipAddressType;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.ISecurityGroup _securityGroup;
        private software.amazon.awscdk.services.ec2.IVpc _vpc;
        @javax.annotation.Nullable
        private java.lang.Boolean _deletionProtection;
        @javax.annotation.Nullable
        private java.lang.Boolean _internetFacing;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetSelection _vpcSubnets;

        /**
         * Sets the value of Http2Enabled
         * @param value Indicates whether HTTP/2 is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHttp2Enabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._http2Enabled = value;
            return this;
        }
        /**
         * Sets the value of IdleTimeout
         * @param value The load balancer idle timeout, in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIdleTimeout(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._idleTimeout = value;
            return this;
        }
        /**
         * Sets the value of IpAddressType
         * @param value The type of IP addresses to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIpAddressType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType value) {
            this._ipAddressType = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroup
         * @param value Security group to associate with this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSecurityGroup(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ISecurityGroup value) {
            this._securityGroup = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value The VPC network to place the load balancer in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpc value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeletionProtection
         * @param value Indicates whether deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deletionProtection = value;
            return this;
        }
        /**
         * Sets the value of InternetFacing
         * @param value Whether the load balancer has an internet-routable address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._internetFacing = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancerName
         * @param value Name of the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerName = value;
            return this;
        }
        /**
         * Sets the value of VpcSubnets
         * @param value Where in the VPC to place the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpcSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection value) {
            this._vpcSubnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationLoadBalancerProps build() {
            return new ApplicationLoadBalancerProps() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $http2Enabled = _http2Enabled;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $idleTimeout = _idleTimeout;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType $ipAddressType = _ipAddressType;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.ISecurityGroup $securityGroup = _securityGroup;
                private final software.amazon.awscdk.services.ec2.IVpc $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $deletionProtection = _deletionProtection;
                @javax.annotation.Nullable
                private final java.lang.Boolean $internetFacing = _internetFacing;
                @javax.annotation.Nullable
                private final java.lang.String $loadBalancerName = _loadBalancerName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetSelection $vpcSubnets = _vpcSubnets;

                @Override
                public java.lang.Boolean getHttp2Enabled() {
                    return this.$http2Enabled;
                }

                @Override
                public software.amazon.awscdk.core.Duration getIdleTimeout() {
                    return this.$idleTimeout;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
                    return this.$ipAddressType;
                }

                @Override
                public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
                    return this.$securityGroup;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public java.lang.Boolean getDeletionProtection() {
                    return this.$deletionProtection;
                }

                @Override
                public java.lang.Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public java.lang.String getLoadBalancerName() {
                    return this.$loadBalancerName;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
                    return this.$vpcSubnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getHttp2Enabled() != null) {
                        obj.set("http2Enabled", om.valueToTree(this.getHttp2Enabled()));
                    }
                    if (this.getIdleTimeout() != null) {
                        obj.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));
                    }
                    if (this.getIpAddressType() != null) {
                        obj.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
                    }
                    if (this.getSecurityGroup() != null) {
                        obj.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
                    }
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    if (this.getDeletionProtection() != null) {
                        obj.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
                    }
                    if (this.getInternetFacing() != null) {
                        obj.set("internetFacing", om.valueToTree(this.getInternetFacing()));
                    }
                    if (this.getLoadBalancerName() != null) {
                        obj.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
                    }
                    if (this.getVpcSubnets() != null) {
                        obj.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Indicates whether HTTP/2 is enabled.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getHttp2Enabled() {
            return this.jsiiGet("http2Enabled", java.lang.Boolean.class);
        }

        /**
         * The load balancer idle timeout, in seconds.
         * 
         * Default: 60
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getIdleTimeout() {
            return this.jsiiGet("idleTimeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * The type of IP addresses to use.
         * 
         * Only applies to application load balancers.
         * 
         * Default: IpAddressType.Ipv4
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
            return this.jsiiGet("ipAddressType", software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class);
        }

        /**
         * Security group to associate with this load balancer.
         * 
         * Default: A security group is created
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
        }

        /**
         * The VPC network to place the load balancer in.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Indicates whether deletion protection is enabled.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getDeletionProtection() {
            return this.jsiiGet("deletionProtection", java.lang.Boolean.class);
        }

        /**
         * Whether the load balancer has an internet-routable address.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getInternetFacing() {
            return this.jsiiGet("internetFacing", java.lang.Boolean.class);
        }

        /**
         * Name of the load balancer.
         * 
         * Default: - Automatically generated name.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerName() {
            return this.jsiiGet("loadBalancerName", java.lang.String.class);
        }

        /**
         * Where in the VPC to place the load balancer.
         * 
         * Default: - Public subnets if internetFacing, otherwise private subnets.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }
    }
}
