package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for configuring a health check.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:40:21.341Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HealthCheck extends software.amazon.jsii.JsiiSerializable {
    /**
     * HTTP code to use when checking for a successful response from a target.
     * 
     * For Application Load Balancers, you can specify values between 200 and
     * 499, and the default value is 200. You can specify multiple values (for
     * example, "200,202") or a range of values (for example, "200-299").
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHealthyHttpCodes();
    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * 
     * For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
     * 
     * Default: 5 for ALBs, 3 for NLBs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getHealthyThresholdCount();
    /**
     * The approximate number of seconds between health checks for an individual target.
     * 
     * Default: Duration.seconds(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getInterval();
    /**
     * The ping path destination where Elastic Load Balancing sends health check requests.
     * 
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPath();
    /**
     * The port that the load balancer uses when performing health checks on the targets.
     * 
     * Default: 'traffic-port'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPort();
    /**
     * The protocol the load balancer uses when performing health checks on targets.
     * 
     * The TCP protocol is supported only if the protocol of the target group
     * is TCP.
     * 
     * Default: HTTP for ALBs, TCP for NLBs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol();
    /**
     * The amount of time, in seconds, during which no response from a target means a failed health check.
     * 
     * For Application Load Balancers, the range is 2-60 seconds and the
     * default is 5 seconds. For Network Load Balancers, this is 10 seconds for
     * TCP and HTTPS health checks and 6 seconds for HTTP health checks.
     * 
     * Default: Duration.seconds(5) for ALBs, Duration.seconds(10) or Duration.seconds(6) for NLBs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getTimeout();
    /**
     * The number of consecutive health check failures required before considering a target unhealthy.
     * 
     * For Application Load Balancers, the default is 2. For Network Load
     * Balancers, this value must be the same as the healthy threshold count.
     * 
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getUnhealthyThresholdCount();

    /**
     * @return a {@link Builder} of {@link HealthCheck}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link HealthCheck}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _healthyHttpCodes;
        @javax.annotation.Nullable
        private java.lang.Number _healthyThresholdCount;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _interval;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.lang.String _port;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.Protocol _protocol;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _timeout;
        @javax.annotation.Nullable
        private java.lang.Number _unhealthyThresholdCount;

        /**
         * Sets the value of HealthyHttpCodes
         * @param value HTTP code to use when checking for a successful response from a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHealthyHttpCodes(@javax.annotation.Nullable final java.lang.String value) {
            this._healthyHttpCodes = value;
            return this;
        }
        /**
         * Sets the value of HealthyThresholdCount
         * @param value The number of consecutive health checks successes required before considering an unhealthy target healthy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHealthyThresholdCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._healthyThresholdCount = value;
            return this;
        }
        /**
         * Sets the value of Interval
         * @param value The approximate number of seconds between health checks for an individual target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withInterval(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._interval = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The ping path destination where Elastic Load Balancing sends health check requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of Port
         * @param value The port that the load balancer uses when performing health checks on the targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPort(@javax.annotation.Nullable final java.lang.String value) {
            this._port = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value The protocol the load balancer uses when performing health checks on targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of Timeout
         * @param value The amount of time, in seconds, during which no response from a target means a failed health check.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTimeout(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._timeout = value;
            return this;
        }
        /**
         * Sets the value of UnhealthyThresholdCount
         * @param value The number of consecutive health check failures required before considering a target unhealthy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withUnhealthyThresholdCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._unhealthyThresholdCount = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthCheck}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public HealthCheck build() {
            return new HealthCheck() {
                @javax.annotation.Nullable
                private final java.lang.String $healthyHttpCodes = _healthyHttpCodes;
                @javax.annotation.Nullable
                private final java.lang.Number $healthyThresholdCount = _healthyThresholdCount;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $interval = _interval;
                @javax.annotation.Nullable
                private final java.lang.String $path = _path;
                @javax.annotation.Nullable
                private final java.lang.String $port = _port;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol $protocol = _protocol;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $timeout = _timeout;
                @javax.annotation.Nullable
                private final java.lang.Number $unhealthyThresholdCount = _unhealthyThresholdCount;

                @Override
                public java.lang.String getHealthyHttpCodes() {
                    return this.$healthyHttpCodes;
                }

                @Override
                public java.lang.Number getHealthyThresholdCount() {
                    return this.$healthyThresholdCount;
                }

                @Override
                public software.amazon.awscdk.core.Duration getInterval() {
                    return this.$interval;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public java.lang.String getPort() {
                    return this.$port;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public software.amazon.awscdk.core.Duration getTimeout() {
                    return this.$timeout;
                }

                @Override
                public java.lang.Number getUnhealthyThresholdCount() {
                    return this.$unhealthyThresholdCount;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getHealthyHttpCodes() != null) {
                        obj.set("healthyHttpCodes", om.valueToTree(this.getHealthyHttpCodes()));
                    }
                    if (this.getHealthyThresholdCount() != null) {
                        obj.set("healthyThresholdCount", om.valueToTree(this.getHealthyThresholdCount()));
                    }
                    if (this.getInterval() != null) {
                        obj.set("interval", om.valueToTree(this.getInterval()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree(this.getPath()));
                    }
                    if (this.getPort() != null) {
                        obj.set("port", om.valueToTree(this.getPort()));
                    }
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                    }
                    if (this.getTimeout() != null) {
                        obj.set("timeout", om.valueToTree(this.getTimeout()));
                    }
                    if (this.getUnhealthyThresholdCount() != null) {
                        obj.set("unhealthyThresholdCount", om.valueToTree(this.getUnhealthyThresholdCount()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * HTTP code to use when checking for a successful response from a target.
         * 
         * For Application Load Balancers, you can specify values between 200 and
         * 499, and the default value is 200. You can specify multiple values (for
         * example, "200,202") or a range of values (for example, "200-299").
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getHealthyHttpCodes() {
            return this.jsiiGet("healthyHttpCodes", java.lang.String.class);
        }

        /**
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         * 
         * For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
         * 
         * Default: 5 for ALBs, 3 for NLBs
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getHealthyThresholdCount() {
            return this.jsiiGet("healthyThresholdCount", java.lang.Number.class);
        }

        /**
         * The approximate number of seconds between health checks for an individual target.
         * 
         * Default: Duration.seconds(30)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getInterval() {
            return this.jsiiGet("interval", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * The ping path destination where Elastic Load Balancing sends health check requests.
         * 
         * Default: /
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * The port that the load balancer uses when performing health checks on the targets.
         * 
         * Default: 'traffic-port'
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPort() {
            return this.jsiiGet("port", java.lang.String.class);
        }

        /**
         * The protocol the load balancer uses when performing health checks on targets.
         * 
         * The TCP protocol is supported only if the protocol of the target group
         * is TCP.
         * 
         * Default: HTTP for ALBs, TCP for NLBs
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.Protocol.class);
        }

        /**
         * The amount of time, in seconds, during which no response from a target means a failed health check.
         * 
         * For Application Load Balancers, the range is 2-60 seconds and the
         * default is 5 seconds. For Network Load Balancers, this is 10 seconds for
         * TCP and HTTPS health checks and 6 seconds for HTTP health checks.
         * 
         * Default: Duration.seconds(5) for ALBs, Duration.seconds(10) or Duration.seconds(6) for NLBs
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * The number of consecutive health check failures required before considering a target unhealthy.
         * 
         * For Application Load Balancers, the default is 2. For Network Load
         * Balancers, this value must be the same as the healthy threshold count.
         * 
         * Default: 2
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getUnhealthyThresholdCount() {
            return this.jsiiGet("unhealthyThresholdCount", java.lang.Number.class);
        }
    }
}
