package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for a new Network Target Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:40:21.356Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkTargetGroupProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps {
    /**
     * The port on which the listener listens for requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();
    /**
     * Indicates whether Proxy Protocol version 2 is enabled.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getProxyProtocolV2();
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     * 
     * Default: - No targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets();

    /**
     * @return a {@link Builder} of {@link NetworkTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link NetworkTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private java.lang.Boolean _proxyProtocolV2;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> _targets;
        private software.amazon.awscdk.services.ec2.IVpc _vpc;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _deregistrationDelay;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck _healthCheck;
        @javax.annotation.Nullable
        private java.lang.String _targetGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType _targetType;

        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPort(final java.lang.Number value) {
            this._port = java.util.Objects.requireNonNull(value, "port is required");
            return this;
        }
        /**
         * Sets the value of ProxyProtocolV2
         * @param value Indicates whether Proxy Protocol version 2 is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProxyProtocolV2(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._proxyProtocolV2 = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value The targets to add to this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value The virtual private cloud (VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpc value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeregistrationDelay
         * @param value The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeregistrationDelay(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._deregistrationDelay = value;
            return this;
        }
        /**
         * Sets the value of HealthCheck
         * @param value Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this._healthCheck = value;
            return this;
        }
        /**
         * Sets the value of TargetGroupName
         * @param value The name of the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._targetGroupName = value;
            return this;
        }
        /**
         * Sets the value of TargetType
         * @param value The type of targets registered to this TargetGroup, either IP or Instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargetType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
            this._targetType = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public NetworkTargetGroupProps build() {
            return new NetworkTargetGroupProps() {
                private final java.lang.Number $port = java.util.Objects.requireNonNull(_port, "port is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $proxyProtocolV2 = _proxyProtocolV2;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> $targets = _targets;
                private final software.amazon.awscdk.services.ec2.IVpc $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $deregistrationDelay = _deregistrationDelay;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck $healthCheck = _healthCheck;
                @javax.annotation.Nullable
                private final java.lang.String $targetGroupName = _targetGroupName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType $targetType = _targetType;

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public java.lang.Boolean getProxyProtocolV2() {
                    return this.$proxyProtocolV2;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
                    return this.$deregistrationDelay;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public java.lang.String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
                    return this.$targetType;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("port", om.valueToTree(this.getPort()));
                    if (this.getProxyProtocolV2() != null) {
                        obj.set("proxyProtocolV2", om.valueToTree(this.getProxyProtocolV2()));
                    }
                    if (this.getTargets() != null) {
                        obj.set("targets", om.valueToTree(this.getTargets()));
                    }
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    if (this.getDeregistrationDelay() != null) {
                        obj.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
                    }
                    if (this.getHealthCheck() != null) {
                        obj.set("healthCheck", om.valueToTree(this.getHealthCheck()));
                    }
                    if (this.getTargetGroupName() != null) {
                        obj.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
                    }
                    if (this.getTargetType() != null) {
                        obj.set("targetType", om.valueToTree(this.getTargetType()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The port on which the listener listens for requests.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * Indicates whether Proxy Protocol version 2 is enabled.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getProxyProtocolV2() {
            return this.jsiiGet("proxyProtocolV2", java.lang.Boolean.class);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         * 
         * Default: - No targets.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * The virtual private cloud (VPC).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0-3600 seconds.
         * 
         * Default: 300
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.jsiiGet("deregistrationDelay", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Health check configuration.
         * 
         * Default: - None.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * 
         * Default: - Automatically generated.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getTargetGroupName() {
            return this.jsiiGet("targetGroupName", java.lang.String.class);
        }

        /**
         * The type of targets registered to this TargetGroup, either IP or Instance.
         * 
         * All targets registered into the group must be of this type. If you
         * register targets to the TargetGroup in the CDK app, the TargetType is
         * determined automatically.
         * 
         * Default: - Determined automatically.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.jsiiGet("targetType", software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class);
        }
    }
}
