package software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.cloudformation.LoadBalancerResource")
public class LoadBalancerResource extends software.amazon.awscdk.Resource {
    protected LoadBalancerResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.LoadBalancerResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticLoadBalancingV2::LoadBalancer``.
     * @param parent the ``cdk.Construct`` this ``LoadBalancerResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``LoadBalancerResource``
     */
    public LoadBalancerResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.LoadBalancerResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ElasticLoadBalancingV2::LoadBalancer``.
     * @param parent the ``cdk.Construct`` this ``LoadBalancerResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public LoadBalancerResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute CanonicalHostedZoneID
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerCanonicalHostedZoneId getLoadBalancerCanonicalHostedZoneId() {
        return this.jsiiGet("loadBalancerCanonicalHostedZoneId", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerCanonicalHostedZoneId.class);
    }
    /**
     * @cloudformation_attribute DNSName
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerDnsName getLoadBalancerDnsName() {
        return this.jsiiGet("loadBalancerDnsName", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerDnsName.class);
    }
    /**
     * @cloudformation_attribute LoadBalancerFullName
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerFullName getLoadBalancerFullName() {
        return this.jsiiGet("loadBalancerFullName", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerFullName.class);
    }
    /**
     * @cloudformation_attribute LoadBalancerName
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerName getLoadBalancerName() {
        return this.jsiiGet("loadBalancerName", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerName.class);
    }
    /**
     * @cloudformation_attribute SecurityGroups
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerSecurityGroups getLoadBalancerSecurityGroups() {
        return this.jsiiGet("loadBalancerSecurityGroups", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerSecurityGroups.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html
     */
    public static interface LoadBalancerAttributeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LoadBalancerResource.LoadBalancerAttributeProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
         */
        java.lang.Object getKey();
        /**
         * ``LoadBalancerResource.LoadBalancerAttributeProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``LoadBalancerResource.LoadBalancerAttributeProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``LoadBalancerResource.LoadBalancerAttributeProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
         */
        java.lang.Object getValue();
        /**
         * ``LoadBalancerResource.LoadBalancerAttributeProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``LoadBalancerResource.LoadBalancerAttributeProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link LoadBalancerAttributeProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
             */
            public Builder withKey(final java.lang.String value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
             */
            public Builder withKey(final software.amazon.awscdk.Token value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
             */
            public Builder withValue(final java.lang.String value) {
                this.instance._value = value;
                return this;
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this.instance._value = value;
                return this;
            }
            public LoadBalancerAttributeProperty build() {
                LoadBalancerAttributeProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LoadBalancerAttributeProperty}.
         */
        final class Jsii$Pojo implements LoadBalancerAttributeProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.LoadBalancerResource.LoadBalancerAttributeProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
             */
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
             */
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
             */
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
             */
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
             */
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
            /**
             * ``LoadBalancerResource.LoadBalancerAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
             */
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html
     */
    public static interface SubnetMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
         */
        java.lang.Object getAllocationId();
        /**
         * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
         */
        void setAllocationId(final java.lang.String value);
        /**
         * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
         */
        void setAllocationId(final software.amazon.awscdk.Token value);
        /**
         * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
         */
        java.lang.Object getSubnetId();
        /**
         * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
         */
        void setSubnetId(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SubnetMappingProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
             */
            public SubnetIdStep withAllocationId(final java.lang.String value) {
                return new FullBuilder().withAllocationId(value);
            }
            /**
             * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
             */
            public SubnetIdStep withAllocationId(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withAllocationId(value);
            }

            public interface SubnetIdStep {
                /**
                 * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
                 */
                Build withSubnetId(final java.lang.String value);
                /**
                 * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
                 */
                Build withSubnetId(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link SubnetMappingProperty} object, initialized with the values set on this builder.
                 */
                SubnetMappingProperty build();
            }

            final class FullBuilder implements SubnetIdStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
                 */
                public SubnetIdStep withAllocationId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SubnetMappingProperty#allocationId is required");
                    this.instance._allocationId = value;
                    return this;
                }
                /**
                 * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
                 */
                public SubnetIdStep withAllocationId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SubnetMappingProperty#allocationId is required");
                    this.instance._allocationId = value;
                    return this;
                }
                /**
                 * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
                 */
                public Build withSubnetId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SubnetMappingProperty#subnetId is required");
                    this.instance._subnetId = value;
                    return this;
                }
                /**
                 * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
                 */
                public Build withSubnetId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SubnetMappingProperty#subnetId is required");
                    this.instance._subnetId = value;
                    return this;
                }
                public SubnetMappingProperty build() {
                    SubnetMappingProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SubnetMappingProperty}.
         */
        final class Jsii$Pojo implements SubnetMappingProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _allocationId;

            public java.lang.Object getAllocationId() {
                return this._allocationId;
            }
            public void setAllocationId(final java.lang.String value) {
                this._allocationId = value;
            }
            public void setAllocationId(final software.amazon.awscdk.Token value) {
                this._allocationId = value;
            }

            protected java.lang.Object _subnetId;

            public java.lang.Object getSubnetId() {
                return this._subnetId;
            }
            public void setSubnetId(final java.lang.String value) {
                this._subnetId = value;
            }
            public void setSubnetId(final software.amazon.awscdk.Token value) {
                this._subnetId = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.LoadBalancerResource.SubnetMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
             */
            public java.lang.Object getAllocationId() {
                return this.jsiiGet("allocationId", java.lang.Object.class);
            }
            /**
             * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
             */
            public void setAllocationId(final java.lang.String value) {
                this.jsiiSet("allocationId", java.util.Objects.requireNonNull(value, "allocationId is required"));
            }
            /**
             * ``LoadBalancerResource.SubnetMappingProperty.AllocationId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
             */
            public void setAllocationId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("allocationId", java.util.Objects.requireNonNull(value, "allocationId is required"));
            }
            /**
             * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
             */
            public java.lang.Object getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.Object.class);
            }
            /**
             * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
             */
            public void setSubnetId(final java.lang.String value) {
                this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
            }
            /**
             * ``LoadBalancerResource.SubnetMappingProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
             */
            public void setSubnetId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
            }
        }
    }
}
