package software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.cloudformation.ListenerResource")
public class ListenerResource extends software.amazon.awscdk.Resource {
    protected ListenerResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticLoadBalancingV2::Listener``.
     * @param parent the ``cdk.Construct`` this ``ListenerResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ListenerResource``
     */
    public ListenerResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html
     */
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         */
        java.lang.Object getTargetGroupArn();
        /**
         * ``ListenerResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         */
        void setTargetGroupArn(final java.lang.String value);
        /**
         * ``ListenerResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         */
        void setTargetGroupArn(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         */
        java.lang.Object getType();
        /**
         * ``ListenerResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ListenerResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         */
        void setType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ActionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``ListenerResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            public TypeStep withTargetGroupArn(final java.lang.String value) {
                return new FullBuilder().withTargetGroupArn(value);
            }
            /**
             * ``ListenerResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            public TypeStep withTargetGroupArn(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withTargetGroupArn(value);
            }

            public interface TypeStep {
                /**
                 * ``ListenerResource.ActionProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
                 */
                Build withType(final java.lang.String value);
                /**
                 * ``ListenerResource.ActionProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
                 */
                Build withType(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link ActionProperty} object, initialized with the values set on this builder.
                 */
                ActionProperty build();
            }

            final class FullBuilder implements TypeStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``ListenerResource.ActionProperty.TargetGroupArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
                 */
                public TypeStep withTargetGroupArn(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ActionProperty#targetGroupArn is required");
                    this.instance._targetGroupArn = value;
                    return this;
                }
                /**
                 * ``ListenerResource.ActionProperty.TargetGroupArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
                 */
                public TypeStep withTargetGroupArn(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ActionProperty#targetGroupArn is required");
                    this.instance._targetGroupArn = value;
                    return this;
                }
                /**
                 * ``ListenerResource.ActionProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
                 */
                public Build withType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ActionProperty#type is required");
                    this.instance._type = value;
                    return this;
                }
                /**
                 * ``ListenerResource.ActionProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
                 */
                public Build withType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ActionProperty#type is required");
                    this.instance._type = value;
                    return this;
                }
                public ActionProperty build() {
                    ActionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ActionProperty}.
         */
        final class Jsii$Pojo implements ActionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _targetGroupArn;

            public java.lang.Object getTargetGroupArn() {
                return this._targetGroupArn;
            }
            public void setTargetGroupArn(final java.lang.String value) {
                this._targetGroupArn = value;
            }
            public void setTargetGroupArn(final software.amazon.awscdk.Token value) {
                this._targetGroupArn = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.ActionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ListenerResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            public java.lang.Object getTargetGroupArn() {
                return this.jsiiGet("targetGroupArn", java.lang.Object.class);
            }
            /**
             * ``ListenerResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            public void setTargetGroupArn(final java.lang.String value) {
                this.jsiiSet("targetGroupArn", java.util.Objects.requireNonNull(value, "targetGroupArn is required"));
            }
            /**
             * ``ListenerResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            public void setTargetGroupArn(final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetGroupArn", java.util.Objects.requireNonNull(value, "targetGroupArn is required"));
            }
            /**
             * ``ListenerResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
             */
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``ListenerResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
             */
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
            /**
             * ``ListenerResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
             */
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html
     */
    public static interface CertificateProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerResource.CertificateProperty.CertificateArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        java.lang.Object getCertificateArn();
        /**
         * ``ListenerResource.CertificateProperty.CertificateArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        void setCertificateArn(final java.lang.String value);
        /**
         * ``ListenerResource.CertificateProperty.CertificateArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        void setCertificateArn(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link CertificateProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``ListenerResource.CertificateProperty.CertificateArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            public Builder withCertificateArn(final java.lang.String value) {
                this.instance._certificateArn = value;
                return this;
            }
            /**
             * ``ListenerResource.CertificateProperty.CertificateArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            public Builder withCertificateArn(final software.amazon.awscdk.Token value) {
                this.instance._certificateArn = value;
                return this;
            }
            public CertificateProperty build() {
                CertificateProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link CertificateProperty}.
         */
        final class Jsii$Pojo implements CertificateProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _certificateArn;

            public java.lang.Object getCertificateArn() {
                return this._certificateArn;
            }
            public void setCertificateArn(final java.lang.String value) {
                this._certificateArn = value;
            }
            public void setCertificateArn(final software.amazon.awscdk.Token value) {
                this._certificateArn = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.CertificateProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ListenerResource.CertificateProperty.CertificateArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            @javax.annotation.Nullable
            public java.lang.Object getCertificateArn() {
                return this.jsiiGet("certificateArn", java.lang.Object.class);
            }
            /**
             * ``ListenerResource.CertificateProperty.CertificateArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            public void setCertificateArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("certificateArn", value);
            }
            /**
             * ``ListenerResource.CertificateProperty.CertificateArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            public void setCertificateArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("certificateArn", value);
            }
        }
    }
}
