package software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.cloudformation.ListenerRuleResource")
public class ListenerRuleResource extends software.amazon.awscdk.Resource {
    protected ListenerRuleResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerRuleResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticLoadBalancingV2::ListenerRule``.
     * @param parent the ``cdk.Construct`` this ``ListenerRuleResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ListenerRuleResource``
     */
    public ListenerRuleResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerRuleResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html
     */
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
         */
        java.lang.Object getTargetGroupArn();
        /**
         * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
         */
        void setTargetGroupArn(final java.lang.String value);
        /**
         * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
         */
        void setTargetGroupArn(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerRuleResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
         */
        java.lang.Object getType();
        /**
         * ``ListenerRuleResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ListenerRuleResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
         */
        void setType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ActionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
             */
            public TypeStep withTargetGroupArn(final java.lang.String value) {
                return new FullBuilder().withTargetGroupArn(value);
            }
            /**
             * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
             */
            public TypeStep withTargetGroupArn(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withTargetGroupArn(value);
            }

            public interface TypeStep {
                /**
                 * ``ListenerRuleResource.ActionProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
                 */
                Build withType(final java.lang.String value);
                /**
                 * ``ListenerRuleResource.ActionProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
                 */
                Build withType(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link ActionProperty} object, initialized with the values set on this builder.
                 */
                ActionProperty build();
            }

            final class FullBuilder implements TypeStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
                 */
                public TypeStep withTargetGroupArn(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ActionProperty#targetGroupArn is required");
                    this.instance._targetGroupArn = value;
                    return this;
                }
                /**
                 * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
                 */
                public TypeStep withTargetGroupArn(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ActionProperty#targetGroupArn is required");
                    this.instance._targetGroupArn = value;
                    return this;
                }
                /**
                 * ``ListenerRuleResource.ActionProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
                 */
                public Build withType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ActionProperty#type is required");
                    this.instance._type = value;
                    return this;
                }
                /**
                 * ``ListenerRuleResource.ActionProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
                 */
                public Build withType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ActionProperty#type is required");
                    this.instance._type = value;
                    return this;
                }
                public ActionProperty build() {
                    ActionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ActionProperty}.
         */
        final class Jsii$Pojo implements ActionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _targetGroupArn;

            public java.lang.Object getTargetGroupArn() {
                return this._targetGroupArn;
            }
            public void setTargetGroupArn(final java.lang.String value) {
                this._targetGroupArn = value;
            }
            public void setTargetGroupArn(final software.amazon.awscdk.Token value) {
                this._targetGroupArn = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerRuleResource.ActionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
             */
            public java.lang.Object getTargetGroupArn() {
                return this.jsiiGet("targetGroupArn", java.lang.Object.class);
            }
            /**
             * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
             */
            public void setTargetGroupArn(final java.lang.String value) {
                this.jsiiSet("targetGroupArn", java.util.Objects.requireNonNull(value, "targetGroupArn is required"));
            }
            /**
             * ``ListenerRuleResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
             */
            public void setTargetGroupArn(final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetGroupArn", java.util.Objects.requireNonNull(value, "targetGroupArn is required"));
            }
            /**
             * ``ListenerRuleResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
             */
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``ListenerRuleResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
             */
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
            /**
             * ``ListenerRuleResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
             */
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html
     */
    public static interface RuleConditionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerRuleResource.RuleConditionProperty.Field``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
         */
        java.lang.Object getField();
        /**
         * ``ListenerRuleResource.RuleConditionProperty.Field``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
         */
        void setField(final java.lang.String value);
        /**
         * ``ListenerRuleResource.RuleConditionProperty.Field``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
         */
        void setField(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerRuleResource.RuleConditionProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
         */
        java.lang.Object getValues();
        /**
         * ``ListenerRuleResource.RuleConditionProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
         */
        void setValues(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerRuleResource.RuleConditionProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
         */
        void setValues(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link RuleConditionProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``ListenerRuleResource.RuleConditionProperty.Field``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
             */
            public Builder withField(final java.lang.String value) {
                this.instance._field = value;
                return this;
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Field``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
             */
            public Builder withField(final software.amazon.awscdk.Token value) {
                this.instance._field = value;
                return this;
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
             */
            public Builder withValues(final software.amazon.awscdk.Token value) {
                this.instance._values = value;
                return this;
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
             */
            public Builder withValues(final java.util.List<java.lang.Object> value) {
                this.instance._values = value;
                return this;
            }
            public RuleConditionProperty build() {
                RuleConditionProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RuleConditionProperty}.
         */
        final class Jsii$Pojo implements RuleConditionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _field;

            public java.lang.Object getField() {
                return this._field;
            }
            public void setField(final java.lang.String value) {
                this._field = value;
            }
            public void setField(final software.amazon.awscdk.Token value) {
                this._field = value;
            }

            protected java.lang.Object _values;

            public java.lang.Object getValues() {
                return this._values;
            }
            public void setValues(final software.amazon.awscdk.Token value) {
                this._values = value;
            }
            public void setValues(final java.util.List<java.lang.Object> value) {
                this._values = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerRuleResource.RuleConditionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Field``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
             */
            @javax.annotation.Nullable
            public java.lang.Object getField() {
                return this.jsiiGet("field", java.lang.Object.class);
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Field``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
             */
            public void setField(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("field", value);
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Field``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
             */
            public void setField(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("field", value);
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
             */
            @javax.annotation.Nullable
            public java.lang.Object getValues() {
                return this.jsiiGet("values", java.lang.Object.class);
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
             */
            public void setValues(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("values", value);
            }
            /**
             * ``ListenerRuleResource.RuleConditionProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
             */
            public void setValues(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("values", value);
            }
        }
    }
}
