package software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 */
public interface ListenerCertificateResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     */
    java.lang.Object getCertificates();
    /**
     * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     */
    void setCertificates(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     */
    void setCertificates(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     */
    java.lang.Object getListenerArn();
    /**
     * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     */
    void setListenerArn(final java.lang.String value);
    /**
     * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     */
    void setListenerArn(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link ListenerCertificateResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
         */
        public ListenerArnStep withCertificates(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withCertificates(value);
        }
        /**
         * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
         */
        public ListenerArnStep withCertificates(final java.util.List<java.lang.Object> value) {
            return new FullBuilder().withCertificates(value);
        }

        public interface ListenerArnStep {
            /**
             * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
             */
            Build withListenerArn(final java.lang.String value);
            /**
             * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
             */
            Build withListenerArn(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link ListenerCertificateResourceProps} object, initialized with the values set on this builder.
             */
            ListenerCertificateResourceProps build();
        }

        final class FullBuilder implements ListenerArnStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
             */
            public ListenerArnStep withCertificates(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "ListenerCertificateResourceProps#certificates is required");
                this.instance._certificates = value;
                return this;
            }
            /**
             * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
             */
            public ListenerArnStep withCertificates(final java.util.List<java.lang.Object> value) {
                java.util.Objects.requireNonNull(value, "ListenerCertificateResourceProps#certificates is required");
                this.instance._certificates = value;
                return this;
            }
            /**
             * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
             */
            public Build withListenerArn(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "ListenerCertificateResourceProps#listenerArn is required");
                this.instance._listenerArn = value;
                return this;
            }
            /**
             * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
             */
            public Build withListenerArn(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "ListenerCertificateResourceProps#listenerArn is required");
                this.instance._listenerArn = value;
                return this;
            }
            public ListenerCertificateResourceProps build() {
                ListenerCertificateResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link ListenerCertificateResourceProps}.
     */
    final class Jsii$Pojo implements ListenerCertificateResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _certificates;

        public java.lang.Object getCertificates() {
            return this._certificates;
        }
        public void setCertificates(final software.amazon.awscdk.Token value) {
            this._certificates = value;
        }
        public void setCertificates(final java.util.List<java.lang.Object> value) {
            this._certificates = value;
        }

        protected java.lang.Object _listenerArn;

        public java.lang.Object getListenerArn() {
            return this._listenerArn;
        }
        public void setListenerArn(final java.lang.String value) {
            this._listenerArn = value;
        }
        public void setListenerArn(final software.amazon.awscdk.Token value) {
            this._listenerArn = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerCertificateResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
         */
        public java.lang.Object getCertificates() {
            return this.jsiiGet("certificates", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
         */
        public void setCertificates(final software.amazon.awscdk.Token value) {
            this.jsiiSet("certificates", java.util.Objects.requireNonNull(value, "certificates is required"));
        }
        /**
         * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
         */
        public void setCertificates(final java.util.List<java.lang.Object> value) {
            this.jsiiSet("certificates", java.util.Objects.requireNonNull(value, "certificates is required"));
        }
        /**
         * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
         */
        public java.lang.Object getListenerArn() {
            return this.jsiiGet("listenerArn", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
         */
        public void setListenerArn(final java.lang.String value) {
            this.jsiiSet("listenerArn", java.util.Objects.requireNonNull(value, "listenerArn is required"));
        }
        /**
         * ``AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
         */
        public void setListenerArn(final software.amazon.awscdk.Token value) {
            this.jsiiSet("listenerArn", java.util.Objects.requireNonNull(value, "listenerArn is required"));
        }
    }
}
