package software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.cloudformation.TargetGroupResource")
public class TargetGroupResource extends software.amazon.awscdk.Resource {
    protected TargetGroupResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.TargetGroupResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticLoadBalancingV2::TargetGroup``.
     * @param parent the ``cdk.Construct`` this ``TargetGroupResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``TargetGroupResource``
     */
    public TargetGroupResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.TargetGroupResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute LoadBalancerArns
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupLoadBalancerArns getTargetGroupLoadBalancerArns() {
        return this.jsiiGet("targetGroupLoadBalancerArns", software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupLoadBalancerArns.class);
    }
    /**
     * @cloudformation_attribute TargetGroupFullName
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupFullName getTargetGroupFullName() {
        return this.jsiiGet("targetGroupFullName", software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupFullName.class);
    }
    /**
     * @cloudformation_attribute TargetGroupName
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupName getTargetGroupName() {
        return this.jsiiGet("targetGroupName", software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupName.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html
     */
    public static interface MatcherProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TargetGroupResource.MatcherProperty.HttpCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
         */
        java.lang.Object getHttpCode();
        /**
         * ``TargetGroupResource.MatcherProperty.HttpCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
         */
        void setHttpCode(final java.lang.String value);
        /**
         * ``TargetGroupResource.MatcherProperty.HttpCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
         */
        void setHttpCode(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link MatcherProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TargetGroupResource.MatcherProperty.HttpCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
             */
            public Build withHttpCode(final java.lang.String value) {
                return new FullBuilder().withHttpCode(value);
            }
            /**
             * ``TargetGroupResource.MatcherProperty.HttpCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
             */
            public Build withHttpCode(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withHttpCode(value);
            }

            public interface Build {
                /**
                 * @return a new {@link MatcherProperty} object, initialized with the values set on this builder.
                 */
                MatcherProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TargetGroupResource.MatcherProperty.HttpCode``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
                 */
                public Build withHttpCode(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "MatcherProperty#httpCode is required");
                    this.instance._httpCode = value;
                    return this;
                }
                /**
                 * ``TargetGroupResource.MatcherProperty.HttpCode``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
                 */
                public Build withHttpCode(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "MatcherProperty#httpCode is required");
                    this.instance._httpCode = value;
                    return this;
                }
                public MatcherProperty build() {
                    MatcherProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MatcherProperty}.
         */
        final class Jsii$Pojo implements MatcherProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _httpCode;

            public java.lang.Object getHttpCode() {
                return this._httpCode;
            }
            public void setHttpCode(final java.lang.String value) {
                this._httpCode = value;
            }
            public void setHttpCode(final software.amazon.awscdk.Token value) {
                this._httpCode = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.TargetGroupResource.MatcherProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TargetGroupResource.MatcherProperty.HttpCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
             */
            public java.lang.Object getHttpCode() {
                return this.jsiiGet("httpCode", java.lang.Object.class);
            }
            /**
             * ``TargetGroupResource.MatcherProperty.HttpCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
             */
            public void setHttpCode(final java.lang.String value) {
                this.jsiiSet("httpCode", java.util.Objects.requireNonNull(value, "httpCode is required"));
            }
            /**
             * ``TargetGroupResource.MatcherProperty.HttpCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
             */
            public void setHttpCode(final software.amazon.awscdk.Token value) {
                this.jsiiSet("httpCode", java.util.Objects.requireNonNull(value, "httpCode is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html
     */
    public static interface TargetDescriptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
         */
        java.lang.Object getAvailabilityZone();
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
         */
        void setAvailabilityZone(final java.lang.String value);
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
         */
        void setAvailabilityZone(final software.amazon.awscdk.Token value);
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
         */
        java.lang.Object getId();
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
         */
        void setId(final java.lang.String value);
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.Port``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
         */
        java.lang.Object getPort();
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.Port``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
         */
        void setPort(final java.lang.Number value);
        /**
         * ``TargetGroupResource.TargetDescriptionProperty.Port``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
         */
        void setPort(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link TargetDescriptionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
             */
            public Build withId(final java.lang.String value) {
                return new FullBuilder().withId(value);
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
             */
            public Build withId(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withId(value);
            }

            public interface Build {
                /**
                 * @return a new {@link TargetDescriptionProperty} object, initialized with the values set on this builder.
                 */
                TargetDescriptionProperty build();
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
                 */
                Build withAvailabilityZone(final java.lang.String value);
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
                 */
                Build withAvailabilityZone(final software.amazon.awscdk.Token value);
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.Port``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
                 */
                Build withPort(final java.lang.Number value);
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.Port``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
                 */
                Build withPort(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
                 */
                public Build withAvailabilityZone(final java.lang.String value) {
                    this.instance._availabilityZone = value;
                    return this;
                }
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
                 */
                public Build withAvailabilityZone(final software.amazon.awscdk.Token value) {
                    this.instance._availabilityZone = value;
                    return this;
                }
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
                 */
                public Build withId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TargetDescriptionProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
                 */
                public Build withId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TargetDescriptionProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.Port``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
                 */
                public Build withPort(final java.lang.Number value) {
                    this.instance._port = value;
                    return this;
                }
                /**
                 * ``TargetGroupResource.TargetDescriptionProperty.Port``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
                 */
                public Build withPort(final software.amazon.awscdk.Token value) {
                    this.instance._port = value;
                    return this;
                }
                public TargetDescriptionProperty build() {
                    TargetDescriptionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TargetDescriptionProperty}.
         */
        final class Jsii$Pojo implements TargetDescriptionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _availabilityZone;

            public java.lang.Object getAvailabilityZone() {
                return this._availabilityZone;
            }
            public void setAvailabilityZone(final java.lang.String value) {
                this._availabilityZone = value;
            }
            public void setAvailabilityZone(final software.amazon.awscdk.Token value) {
                this._availabilityZone = value;
            }

            protected java.lang.Object _id;

            public java.lang.Object getId() {
                return this._id;
            }
            public void setId(final java.lang.String value) {
                this._id = value;
            }
            public void setId(final software.amazon.awscdk.Token value) {
                this._id = value;
            }

            protected java.lang.Object _port;

            public java.lang.Object getPort() {
                return this._port;
            }
            public void setPort(final java.lang.Number value) {
                this._port = value;
            }
            public void setPort(final software.amazon.awscdk.Token value) {
                this._port = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.TargetGroupResource.TargetDescriptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
             */
            @javax.annotation.Nullable
            public java.lang.Object getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.Object.class);
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
             */
            public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("availabilityZone", value);
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
             */
            public void setAvailabilityZone(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("availabilityZone", value);
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
             */
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
             */
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
             */
            public void setId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.Port``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
             */
            @javax.annotation.Nullable
            public java.lang.Object getPort() {
                return this.jsiiGet("port", java.lang.Object.class);
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.Port``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
             */
            public void setPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("port", value);
            }
            /**
             * ``TargetGroupResource.TargetDescriptionProperty.Port``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
             */
            public void setPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("port", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html
     */
    public static interface TargetGroupAttributeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TargetGroupResource.TargetGroupAttributeProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
         */
        java.lang.Object getKey();
        /**
         * ``TargetGroupResource.TargetGroupAttributeProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``TargetGroupResource.TargetGroupAttributeProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``TargetGroupResource.TargetGroupAttributeProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
         */
        java.lang.Object getValue();
        /**
         * ``TargetGroupResource.TargetGroupAttributeProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``TargetGroupResource.TargetGroupAttributeProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link TargetGroupAttributeProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
             */
            public Builder withKey(final java.lang.String value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
             */
            public Builder withKey(final software.amazon.awscdk.Token value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
             */
            public Builder withValue(final java.lang.String value) {
                this.instance._value = value;
                return this;
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this.instance._value = value;
                return this;
            }
            public TargetGroupAttributeProperty build() {
                TargetGroupAttributeProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TargetGroupAttributeProperty}.
         */
        final class Jsii$Pojo implements TargetGroupAttributeProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.TargetGroupResource.TargetGroupAttributeProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
             */
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
             */
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
             */
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
             */
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
             */
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
            /**
             * ``TargetGroupResource.TargetGroupAttributeProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
             */
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", value);
            }
        }
    }
}
