package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define an Application Target Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:18:55.188Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationTargetGroup")
public class ApplicationTargetGroup extends software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup {
    protected ApplicationTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationTargetGroup(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup import_(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class, "import", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a load balancing target to this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget... targets) {
        this.jsiiCall("addTarget", Void.class, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
    }

    /**
     * Enable sticky routing via a cookie to members of this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void enableCookieStickiness(final software.amazon.awscdk.core.Duration duration) {
        this.jsiiCall("enableCookieStickiness", Void.class, new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Return the given named metric for this Application Load Balancer Target Group.
     * 
     * Returns the metric for this target group from the point of view of the first
     * load balancer load balancing to it. If you have multiple load balancers load
     * sending traffic to the same target group, you will have to override the dimensions
     * on this metric.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Application Load Balancer Target Group.
     * 
     * Returns the metric for this target group from the point of view of the first
     * load balancer load balancing to it. If you have multiple load balancers load
     * sending traffic to the same target group, you will have to override the dimensions
     * on this metric.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * The number of healthy hosts in the target group.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of healthy hosts in the target group.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount() {
        return this.jsiiCall("metricHealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in this target group.
     * 
     * This does not include any response codes generated by the load balancer.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHttpCodeTarget", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
    }

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in this target group.
     * 
     * This does not include any response codes generated by the load balancer.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code) {
        return this.jsiiCall("metricHttpCodeTarget", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * The number of IPv6 requests received by the target group.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricIpv6RequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of IPv6 requests received by the target group.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount() {
        return this.jsiiCall("metricIpv6RequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of requests processed over IPv4 and IPv6.
     * 
     * This count includes only the requests with a response generated by a target of the load balancer.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricRequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of requests processed over IPv4 and IPv6.
     * 
     * This count includes only the requests with a response generated by a target of the load balancer.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount() {
        return this.jsiiCall("metricRequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The average number of requests received by each target in a target group.
     * 
     * The only valid statistic is Sum. Note that this represents the average not the sum.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCountPerTarget(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricRequestCountPerTarget", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The average number of requests received by each target in a target group.
     * 
     * The only valid statistic is Sum. Note that this represents the average not the sum.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCountPerTarget() {
        return this.jsiiCall("metricRequestCountPerTarget", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTargetConnectionErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount() {
        return this.jsiiCall("metricTargetConnectionErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTargetResponseTime", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime() {
        return this.jsiiCall("metricTargetResponseTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * 
     * Possible causes include a mismatch of ciphers or protocols.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTargetTLSNegotiationErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * 
     * Possible causes include a mismatch of ciphers or protocols.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount() {
        return this.jsiiCall("metricTargetTLSNegotiationErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of unhealthy hosts in the target group.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricUnhealthyHostCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricUnhealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of unhealthy hosts in the target group.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricUnhealthyHostCount() {
        return this.jsiiCall("metricUnhealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Register a connectable as a member of this target group.
     * 
     * Don't call this directly. It will be called by load balancing targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.Port portRange) {
        this.jsiiCall("registerConnectable", Void.class, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required"), portRange });
    }

    /**
     * Register a connectable as a member of this target group.
     * 
     * Don't call this directly. It will be called by load balancing targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable) {
        this.jsiiCall("registerConnectable", Void.class, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required") });
    }

    /**
     * Register a listener that is load balancing to this target group.
     * 
     * Don't call this directly. It will be called by listeners.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, @javax.annotation.Nullable final software.amazon.awscdk.core.IConstruct associatingConstruct) {
        this.jsiiCall("registerListener", Void.class, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required"), associatingConstruct });
    }

    /**
     * Register a listener that is load balancing to this target group.
     * 
     * Don't call this directly. It will be called by listeners.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
        this.jsiiCall("registerListener", Void.class, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Full name of first load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFirstLoadBalancerFullName() {
        return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
    }
}
