package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a listener rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:12:22.475Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerRuleProps {
    /**
     * The listener to attach the rule to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener _listener;
        private java.lang.Number _priority;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse _fixedResponse;
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> _targetGroups;

        /**
         * Sets the value of Listener
         * @param value The listener to attach the rule to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener value) {
            this._listener = java.util.Objects.requireNonNull(value, "listener is required");
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPriority(final java.lang.Number value) {
            this._priority = java.util.Objects.requireNonNull(value, "priority is required");
            return this;
        }
        /**
         * Sets the value of FixedResponse
         * @param value Fixed response to return.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withFixedResponse(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse value) {
            this._fixedResponse = value;
            return this;
        }
        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of TargetGroups
         * @param value Target groups to forward requests to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this._targetGroups = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationListenerRuleProps build() {
            return new ApplicationListenerRuleProps() {
                private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener $listener = java.util.Objects.requireNonNull(_listener, "listener is required");
                private final java.lang.Number $priority = java.util.Objects.requireNonNull(_priority, "priority is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse $fixedResponse = _fixedResponse;
                @javax.annotation.Nullable
                private final java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private final java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> $targetGroups = _targetGroups;

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
                    return this.$listener;
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
                    return this.$fixedResponse;
                }

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
                    return this.$targetGroups;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("listener", om.valueToTree(this.getListener()));
                    obj.set("priority", om.valueToTree(this.getPriority()));
                    if (this.getFixedResponse() != null) {
                        obj.set("fixedResponse", om.valueToTree(this.getFixedResponse()));
                    }
                    if (this.getHostHeader() != null) {
                        obj.set("hostHeader", om.valueToTree(this.getHostHeader()));
                    }
                    if (this.getPathPattern() != null) {
                        obj.set("pathPattern", om.valueToTree(this.getPathPattern()));
                    }
                    if (this.getTargetGroups() != null) {
                        obj.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The listener to attach the rule to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.jsiiGet("listener", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class);
        }

        /**
         * Priority of the rule.
         * 
         * The rule with the lowest priority will be used for every request.
         * 
         * Priorities must be unique.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Fixed response to return.
         * 
         * Only one of `fixedResponse` or
         * `targetGroups` can be specified.
         * 
         * Default: - No fixed response.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
            return this.jsiiGet("fixedResponse", software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse.class);
        }

        /**
         * Rule applies if the requested host matches the indicated host.
         * 
         * May contain up to three '*' wildcards.
         * 
         * Default: - No host condition.
         * 
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern.
         * 
         * May contain up to three '*' wildcards.
         * 
         * Default: - No path condition.
         * 
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Target groups to forward requests to.
         * 
         * Only one of `targetGroups` or
         * `fixedResponse` can be specified.
         * 
         * Default: - No target groups.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.jsiiGet("targetGroups", java.util.List.class);
        }
    }
}
