package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:12:22.477Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARN of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLoadBalancerArn();
    /**
     * ID of the load balancer's security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSecurityGroupId();
    /**
     * The canonical hosted zone ID of this load balancer.
     * 
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLoadBalancerCanonicalHostedZoneId();
    /**
     * The DNS name of this load balancer.
     * 
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLoadBalancerDnsName();

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _loadBalancerArn;
        private java.lang.String _securityGroupId;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerCanonicalHostedZoneId;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerDnsName;

        /**
         * Sets the value of LoadBalancerArn
         * @param value ARN of the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLoadBalancerArn(final java.lang.String value) {
            this._loadBalancerArn = java.util.Objects.requireNonNull(value, "loadBalancerArn is required");
            return this;
        }
        /**
         * Sets the value of SecurityGroupId
         * @param value ID of the load balancer's security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSecurityGroupId(final java.lang.String value) {
            this._securityGroupId = java.util.Objects.requireNonNull(value, "securityGroupId is required");
            return this;
        }
        /**
         * Sets the value of LoadBalancerCanonicalHostedZoneId
         * @param value The canonical hosted zone ID of this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLoadBalancerCanonicalHostedZoneId(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerCanonicalHostedZoneId = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancerDnsName
         * @param value The DNS name of this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLoadBalancerDnsName(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerDnsName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationLoadBalancerAttributes build() {
            return new ApplicationLoadBalancerAttributes() {
                private final java.lang.String $loadBalancerArn = java.util.Objects.requireNonNull(_loadBalancerArn, "loadBalancerArn is required");
                private final java.lang.String $securityGroupId = java.util.Objects.requireNonNull(_securityGroupId, "securityGroupId is required");
                @javax.annotation.Nullable
                private final java.lang.String $loadBalancerCanonicalHostedZoneId = _loadBalancerCanonicalHostedZoneId;
                @javax.annotation.Nullable
                private final java.lang.String $loadBalancerDnsName = _loadBalancerDnsName;

                @Override
                public java.lang.String getLoadBalancerArn() {
                    return this.$loadBalancerArn;
                }

                @Override
                public java.lang.String getSecurityGroupId() {
                    return this.$securityGroupId;
                }

                @Override
                public java.lang.String getLoadBalancerCanonicalHostedZoneId() {
                    return this.$loadBalancerCanonicalHostedZoneId;
                }

                @Override
                public java.lang.String getLoadBalancerDnsName() {
                    return this.$loadBalancerDnsName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
                    obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
                    if (this.getLoadBalancerCanonicalHostedZoneId() != null) {
                        obj.set("loadBalancerCanonicalHostedZoneId", om.valueToTree(this.getLoadBalancerCanonicalHostedZoneId()));
                    }
                    if (this.getLoadBalancerDnsName() != null) {
                        obj.set("loadBalancerDnsName", om.valueToTree(this.getLoadBalancerDnsName()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ARN of the load balancer.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getLoadBalancerArn() {
            return this.jsiiGet("loadBalancerArn", java.lang.String.class);
        }

        /**
         * ID of the load balancer's security group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getSecurityGroupId() {
            return this.jsiiGet("securityGroupId", java.lang.String.class);
        }

        /**
         * The canonical hosted zone ID of this load balancer.
         * 
         * Default: - When not provided, LB cannot be used as Route53 Alias target.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerCanonicalHostedZoneId() {
            return this.jsiiGet("loadBalancerCanonicalHostedZoneId", java.lang.String.class);
        }

        /**
         * The DNS name of this load balancer.
         * 
         * Default: - When not provided, LB cannot be used as Route53 Alias target.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerDnsName() {
            return this.jsiiGet("loadBalancerDnsName", java.lang.String.class);
        }
    }
}
