/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ApplicationTargetGroupProps
extends JsiiSerializable,
BaseTargetGroupProps {
    public Number getPort();

    public ApplicationProtocol getProtocol();

    public Duration getSlowStart();

    public Duration getStickinessCookieDuration();

    public List<IApplicationLoadBalancerTarget> getTargets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Number _port;
        @Nullable
        private ApplicationProtocol _protocol;
        @Nullable
        private Duration _slowStart;
        @Nullable
        private Duration _stickinessCookieDuration;
        @Nullable
        private List<IApplicationLoadBalancerTarget> _targets;
        private IVpc _vpc;
        @Nullable
        private Duration _deregistrationDelay;
        @Nullable
        private HealthCheck _healthCheck;
        @Nullable
        private String _targetGroupName;
        @Nullable
        private TargetType _targetType;

        public Builder withPort(@Nullable Number value) {
            this._port = value;
            return this;
        }

        public Builder withProtocol(@Nullable ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }

        public Builder withSlowStart(@Nullable Duration value) {
            this._slowStart = value;
            return this;
        }

        public Builder withStickinessCookieDuration(@Nullable Duration value) {
            this._stickinessCookieDuration = value;
            return this;
        }

        public Builder withTargets(@Nullable List<IApplicationLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }

        public Builder withVpc(IVpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeregistrationDelay(@Nullable Duration value) {
            this._deregistrationDelay = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheck value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withTargetGroupName(@Nullable String value) {
            this._targetGroupName = value;
            return this;
        }

        public Builder withTargetType(@Nullable TargetType value) {
            this._targetType = value;
            return this;
        }

        public ApplicationTargetGroupProps build() {
            return new ApplicationTargetGroupProps(){
                @Nullable
                private final Number $port;
                @Nullable
                private final ApplicationProtocol $protocol;
                @Nullable
                private final Duration $slowStart;
                @Nullable
                private final Duration $stickinessCookieDuration;
                @Nullable
                private final List<IApplicationLoadBalancerTarget> $targets;
                private final IVpc $vpc;
                @Nullable
                private final Duration $deregistrationDelay;
                @Nullable
                private final HealthCheck $healthCheck;
                @Nullable
                private final String $targetGroupName;
                @Nullable
                private final TargetType $targetType;
                {
                    this.$port = _port;
                    this.$protocol = _protocol;
                    this.$slowStart = _slowStart;
                    this.$stickinessCookieDuration = _stickinessCookieDuration;
                    this.$targets = _targets;
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deregistrationDelay = _deregistrationDelay;
                    this.$healthCheck = _healthCheck;
                    this.$targetGroupName = _targetGroupName;
                    this.$targetType = _targetType;
                }

                @Override
                public Number getPort() {
                    return this.$port;
                }

                @Override
                public ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public Duration getSlowStart() {
                    return this.$slowStart;
                }

                @Override
                public Duration getStickinessCookieDuration() {
                    return this.$stickinessCookieDuration;
                }

                @Override
                public List<IApplicationLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public Duration getDeregistrationDelay() {
                    return this.$deregistrationDelay;
                }

                @Override
                public HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public TargetType getTargetType() {
                    return this.$targetType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getPort() != null) {
                        obj.set("port", om.valueToTree((Object)this.getPort()));
                    }
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    }
                    if (this.getSlowStart() != null) {
                        obj.set("slowStart", om.valueToTree((Object)this.getSlowStart()));
                    }
                    if (this.getStickinessCookieDuration() != null) {
                        obj.set("stickinessCookieDuration", om.valueToTree((Object)this.getStickinessCookieDuration()));
                    }
                    if (this.getTargets() != null) {
                        obj.set("targets", om.valueToTree(this.getTargets()));
                    }
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    if (this.getDeregistrationDelay() != null) {
                        obj.set("deregistrationDelay", om.valueToTree((Object)this.getDeregistrationDelay()));
                    }
                    if (this.getHealthCheck() != null) {
                        obj.set("healthCheck", om.valueToTree((Object)this.getHealthCheck()));
                    }
                    if (this.getTargetGroupName() != null) {
                        obj.set("targetGroupName", om.valueToTree((Object)this.getTargetGroupName()));
                    }
                    if (this.getTargetType() != null) {
                        obj.set("targetType", om.valueToTree((Object)this.getTargetType()));
                    }
                    return obj;
                }
            };
        }
    }
}

