package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for configuring a health check.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:07:54.833Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.HealthCheck")
@software.amazon.jsii.Jsii.Proxy(HealthCheck.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HealthCheck extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether health checks are enabled.
     * <p>
     * If the target type is lambda,
     * health checks are disabled by default but can be enabled. If the target type
     * is instance or ip, health checks are always enabled and cannot be disabled.
     * <p>
     * Default: - Determined automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * GRPC code to use when checking for a successful response from a target.
     * <p>
     * You can specify values between 0 and 99. You can specify multiple values
     * (for example, "0,1") or a range of values (for example, "0-5").
     * <p>
     * Default: - 12
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthyGrpcCodes() {
        return null;
    }

    /**
     * HTTP code to use when checking for a successful response from a target.
     * <p>
     * For Application Load Balancers, you can specify values between 200 and
     * 499, and the default value is 200. You can specify multiple values (for
     * example, "200,202") or a range of values (for example, "200-299").
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthyHttpCodes() {
        return null;
    }

    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * <p>
     * For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
     * <p>
     * Default: 5 for ALBs, 3 for NLBs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHealthyThresholdCount() {
        return null;
    }

    /**
     * The approximate number of seconds between health checks for an individual target.
     * <p>
     * Default: Duration.seconds(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getInterval() {
        return null;
    }

    /**
     * The ping path destination where Elastic Load Balancing sends health check requests.
     * <p>
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * The port that the load balancer uses when performing health checks on the targets.
     * <p>
     * Default: 'traffic-port'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
        return null;
    }

    /**
     * The protocol the load balancer uses when performing health checks on targets.
     * <p>
     * The TCP protocol is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP.
     * The TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     * <p>
     * Default: HTTP for ALBs, TCP for NLBs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
        return null;
    }

    /**
     * The amount of time, in seconds, during which no response from a target means a failed health check.
     * <p>
     * For Application Load Balancers, the range is 2-60 seconds and the
     * default is 5 seconds. For Network Load Balancers, this is 10 seconds for
     * TCP and HTTPS health checks and 6 seconds for HTTP health checks.
     * <p>
     * Default: Duration.seconds(5) for ALBs, Duration.seconds(10) or Duration.seconds(6) for NLBs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * The number of consecutive health check failures required before considering a target unhealthy.
     * <p>
     * For Application Load Balancers, the default is 2. For Network Load
     * Balancers, this value must be the same as the healthy threshold count.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUnhealthyThresholdCount() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HealthCheck}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HealthCheck}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HealthCheck> {
        private java.lang.Boolean enabled;
        private java.lang.String healthyGrpcCodes;
        private java.lang.String healthyHttpCodes;
        private java.lang.Number healthyThresholdCount;
        private software.amazon.awscdk.core.Duration interval;
        private java.lang.String path;
        private java.lang.String port;
        private software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol;
        private software.amazon.awscdk.core.Duration timeout;
        private java.lang.Number unhealthyThresholdCount;

        /**
         * Sets the value of {@link HealthCheck#getEnabled}
         * @param enabled Indicates whether health checks are enabled.
         *                If the target type is lambda,
         *                health checks are disabled by default but can be enabled. If the target type
         *                is instance or ip, health checks are always enabled and cannot be disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getHealthyGrpcCodes}
         * @param healthyGrpcCodes GRPC code to use when checking for a successful response from a target.
         *                         You can specify values between 0 and 99. You can specify multiple values
         *                         (for example, "0,1") or a range of values (for example, "0-5").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthyGrpcCodes(java.lang.String healthyGrpcCodes) {
            this.healthyGrpcCodes = healthyGrpcCodes;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getHealthyHttpCodes}
         * @param healthyHttpCodes HTTP code to use when checking for a successful response from a target.
         *                         For Application Load Balancers, you can specify values between 200 and
         *                         499, and the default value is 200. You can specify multiple values (for
         *                         example, "200,202") or a range of values (for example, "200-299").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthyHttpCodes(java.lang.String healthyHttpCodes) {
            this.healthyHttpCodes = healthyHttpCodes;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getHealthyThresholdCount}
         * @param healthyThresholdCount The number of consecutive health checks successes required before considering an unhealthy target healthy.
         *                              For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthyThresholdCount(java.lang.Number healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getInterval}
         * @param interval The approximate number of seconds between health checks for an individual target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(software.amazon.awscdk.core.Duration interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getPath}
         * @param path The ping path destination where Elastic Load Balancing sends health check requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getPort}
         * @param port The port that the load balancer uses when performing health checks on the targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.String port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getProtocol}
         * @param protocol The protocol the load balancer uses when performing health checks on targets.
         *                 The TCP protocol is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP.
         *                 The TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getTimeout}
         * @param timeout The amount of time, in seconds, during which no response from a target means a failed health check.
         *                For Application Load Balancers, the range is 2-60 seconds and the
         *                default is 5 seconds. For Network Load Balancers, this is 10 seconds for
         *                TCP and HTTPS health checks and 6 seconds for HTTP health checks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getUnhealthyThresholdCount}
         * @param unhealthyThresholdCount The number of consecutive health check failures required before considering a target unhealthy.
         *                                For Application Load Balancers, the default is 2. For Network Load
         *                                Balancers, this value must be the same as the healthy threshold count.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unhealthyThresholdCount(java.lang.Number unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthCheck}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HealthCheck build() {
            return new Jsii$Proxy(enabled, healthyGrpcCodes, healthyHttpCodes, healthyThresholdCount, interval, path, port, protocol, timeout, unhealthyThresholdCount);
        }
    }

    /**
     * An implementation for {@link HealthCheck}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheck {
        private final java.lang.Boolean enabled;
        private final java.lang.String healthyGrpcCodes;
        private final java.lang.String healthyHttpCodes;
        private final java.lang.Number healthyThresholdCount;
        private final software.amazon.awscdk.core.Duration interval;
        private final java.lang.String path;
        private final java.lang.String port;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol;
        private final software.amazon.awscdk.core.Duration timeout;
        private final java.lang.Number unhealthyThresholdCount;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.healthyGrpcCodes = software.amazon.jsii.Kernel.get(this, "healthyGrpcCodes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthyHttpCodes = software.amazon.jsii.Kernel.get(this, "healthyHttpCodes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthyThresholdCount = software.amazon.jsii.Kernel.get(this, "healthyThresholdCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.unhealthyThresholdCount = software.amazon.jsii.Kernel.get(this, "unhealthyThresholdCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean enabled, final java.lang.String healthyGrpcCodes, final java.lang.String healthyHttpCodes, final java.lang.Number healthyThresholdCount, final software.amazon.awscdk.core.Duration interval, final java.lang.String path, final java.lang.String port, final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol, final software.amazon.awscdk.core.Duration timeout, final java.lang.Number unhealthyThresholdCount) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enabled = enabled;
            this.healthyGrpcCodes = healthyGrpcCodes;
            this.healthyHttpCodes = healthyHttpCodes;
            this.healthyThresholdCount = healthyThresholdCount;
            this.interval = interval;
            this.path = path;
            this.port = port;
            this.protocol = protocol;
            this.timeout = timeout;
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getHealthyGrpcCodes() {
            return this.healthyGrpcCodes;
        }

        @Override
        public final java.lang.String getHealthyHttpCodes() {
            return this.healthyHttpCodes;
        }

        @Override
        public final java.lang.Number getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getInterval() {
            return this.interval;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.lang.String getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Number getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getHealthyGrpcCodes() != null) {
                data.set("healthyGrpcCodes", om.valueToTree(this.getHealthyGrpcCodes()));
            }
            if (this.getHealthyHttpCodes() != null) {
                data.set("healthyHttpCodes", om.valueToTree(this.getHealthyHttpCodes()));
            }
            if (this.getHealthyThresholdCount() != null) {
                data.set("healthyThresholdCount", om.valueToTree(this.getHealthyThresholdCount()));
            }
            if (this.getInterval() != null) {
                data.set("interval", om.valueToTree(this.getInterval()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getUnhealthyThresholdCount() != null) {
                data.set("unhealthyThresholdCount", om.valueToTree(this.getUnhealthyThresholdCount()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.HealthCheck"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HealthCheck.Jsii$Proxy that = (HealthCheck.Jsii$Proxy) o;

            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.healthyGrpcCodes != null ? !this.healthyGrpcCodes.equals(that.healthyGrpcCodes) : that.healthyGrpcCodes != null) return false;
            if (this.healthyHttpCodes != null ? !this.healthyHttpCodes.equals(that.healthyHttpCodes) : that.healthyHttpCodes != null) return false;
            if (this.healthyThresholdCount != null ? !this.healthyThresholdCount.equals(that.healthyThresholdCount) : that.healthyThresholdCount != null) return false;
            if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.unhealthyThresholdCount != null ? this.unhealthyThresholdCount.equals(that.unhealthyThresholdCount) : that.unhealthyThresholdCount == null;
        }

        @Override
        public final int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.healthyGrpcCodes != null ? this.healthyGrpcCodes.hashCode() : 0);
            result = 31 * result + (this.healthyHttpCodes != null ? this.healthyHttpCodes.hashCode() : 0);
            result = 31 * result + (this.healthyThresholdCount != null ? this.healthyThresholdCount.hashCode() : 0);
            result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.unhealthyThresholdCount != null ? this.unhealthyThresholdCount.hashCode() : 0);
            return result;
        }
    }
}
