package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for defining a rule on a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:28:09.025Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Priority of the rule.
     * 
     * The rule with the lowest priority will be used for every request.
     * 
     * Priorities must be unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPriority();

    /**
     * Fixed response to return.
     * 
     * Only one of `fixedResponse` or
     * `targetGroups` can be specified.
     * 
     * Default: - No fixed response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse();

    /**
     * Rule applies if the requested host matches the indicated host.
     * 
     * May contain up to three '*' wildcards.
     * 
     * Default: - No host condition.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHostHeader();

    /**
     * Rule applies if the requested path matches the given path pattern.
     * 
     * May contain up to three '*' wildcards.
     * 
     * Default: - No path condition.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPathPattern();

    /**
     * Target groups to forward requests to.
     * 
     * Only one of `targetGroups` or
     * `fixedResponse` can be specified.
     * 
     * Default: - No target groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups();

    /**
     * @return a {@link Builder} of {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number priority;
        private software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private java.lang.String hostHeader;
        private java.lang.String pathPattern;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Sets the value of Priority
         * @param priority Priority of the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of FixedResponse
         * @param fixedResponse Fixed response to return.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fixedResponse(software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse) {
            this.fixedResponse = fixedResponse;
            return this;
        }

        /**
         * Sets the value of HostHeader
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of PathPattern
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of TargetGroups
         * @param targetGroups Target groups to forward requests to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            this.targetGroups = targetGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BaseApplicationListenerRuleProps build() {
            return new Jsii$Proxy(priority, fixedResponse, hostHeader, pathPattern, targetGroups);
        }
    }

    /**
     * An implementation for {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseApplicationListenerRuleProps {
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
            this.fixedResponse = this.jsiiGet("fixedResponse", software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse.class);
            this.hostHeader = this.jsiiGet("hostHeader", java.lang.String.class);
            this.pathPattern = this.jsiiGet("pathPattern", java.lang.String.class);
            this.targetGroups = this.jsiiGet("targetGroups", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number priority, software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse, java.lang.String hostHeader, java.lang.String pathPattern, java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
            this.fixedResponse = fixedResponse;
            this.hostHeader = hostHeader;
            this.pathPattern = pathPattern;
            this.targetGroups = targetGroups;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
            return this.fixedResponse;
        }

        @Override
        public java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("priority", om.valueToTree(this.getPriority()));
            if (this.getFixedResponse() != null) {
                obj.set("fixedResponse", om.valueToTree(this.getFixedResponse()));
            }
            if (this.getHostHeader() != null) {
                obj.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                obj.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getTargetGroups() != null) {
                obj.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseApplicationListenerRuleProps.Jsii$Proxy that = (BaseApplicationListenerRuleProps.Jsii$Proxy) o;

            if (!priority.equals(that.priority)) return false;
            if (this.fixedResponse != null ? !this.fixedResponse.equals(that.fixedResponse) : that.fixedResponse != null) return false;
            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            return this.targetGroups != null ? this.targetGroups.equals(that.targetGroups) : that.targetGroups == null;
        }

        @Override
        public int hashCode() {
            int result = this.priority.hashCode();
            result = 31 * result + (this.fixedResponse != null ? this.fixedResponse.hashCode() : 0);
            result = 31 * result + (this.hostHeader != null ? this.hostHeader.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            return result;
        }
    }
}
