package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a listener rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-07-09T19:18:09.329Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerRuleProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationListenerRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerRuleProps {

    /**
     * The listener to attach the rule to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationListenerRuleProps> {
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;
        private java.lang.Number priority;
        private software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        private software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private java.lang.String hostHeader;
        private java.lang.String pathPattern;
        private java.util.List<java.lang.String> pathPatterns;
        private software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getListener}
         * @param listener The listener to attach the rule to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getPriority}
         * @param priority Priority of the rule. This parameter is required.
         *                 The rule with the lowest priority will be used for every request.
         *                 <p>
         *                 Priorities must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getAction}
         * @param action Action to perform when requests are received.
         *               Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getConditions}
         * @param conditions Rule applies if matches the conditions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions) {
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)conditions;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getFixedResponse}
         * @param fixedResponse Fixed response to return.
         *                      Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * @return {@code this}
         * @deprecated Use `action` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder fixedResponse(software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse) {
            this.fixedResponse = fixedResponse;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getHostHeader}
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         *                   May contain up to three '*' wildcards.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getPathPattern}
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getPathPatterns}
         * @param pathPatterns Rule applies if the requested path matches any of the given patterns.
         *                     Paths may contain up to three '*' wildcards.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPatterns(java.util.List<java.lang.String> pathPatterns) {
            this.pathPatterns = pathPatterns;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getRedirectResponse}
         * @param redirectResponse Redirect response to return.
         *                         Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * @return {@code this}
         * @deprecated Use `action` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder redirectResponse(software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse) {
            this.redirectResponse = redirectResponse;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getTargetGroups}
         * @param targetGroups Target groups to forward requests to.
         *                     Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         *                     <p>
         *                     Implies a <code>forward</code> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targetGroups(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup>)targetGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationListenerRuleProps build() {
            return new Jsii$Proxy(listener, priority, action, conditions, fixedResponse, hostHeader, pathPattern, pathPatterns, redirectResponse, targetGroups);
        }
    }

    /**
     * An implementation for {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerRuleProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.util.List<java.lang.String> pathPatterns;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listener = software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition.class)));
            this.fixedResponse = software.amazon.jsii.Kernel.get(this, "fixedResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse.class));
            this.hostHeader = software.amazon.jsii.Kernel.get(this, "hostHeader", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathPattern = software.amazon.jsii.Kernel.get(this, "pathPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathPatterns = software.amazon.jsii.Kernel.get(this, "pathPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.redirectResponse = software.amazon.jsii.Kernel.get(this, "redirectResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse.class));
            this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final java.lang.Number priority, final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action, final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions, final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse, final java.lang.String hostHeader, final java.lang.String pathPattern, final java.util.List<java.lang.String> pathPatterns, final software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse, final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listener = java.util.Objects.requireNonNull(listener, "listener is required");
            this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
            this.action = action;
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)conditions;
            this.fixedResponse = fixedResponse;
            this.hostHeader = hostHeader;
            this.pathPattern = pathPattern;
            this.pathPatterns = pathPatterns;
            this.redirectResponse = redirectResponse;
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup>)targetGroups;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.listener;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getAction() {
            return this.action;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> getConditions() {
            return this.conditions;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
            return this.fixedResponse;
        }

        @Override
        public final java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public final java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public final java.util.List<java.lang.String> getPathPatterns() {
            return this.pathPatterns;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse getRedirectResponse() {
            return this.redirectResponse;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listener", om.valueToTree(this.getListener()));
            data.set("priority", om.valueToTree(this.getPriority()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getFixedResponse() != null) {
                data.set("fixedResponse", om.valueToTree(this.getFixedResponse()));
            }
            if (this.getHostHeader() != null) {
                data.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getPathPatterns() != null) {
                data.set("pathPatterns", om.valueToTree(this.getPathPatterns()));
            }
            if (this.getRedirectResponse() != null) {
                data.set("redirectResponse", om.valueToTree(this.getRedirectResponse()));
            }
            if (this.getTargetGroups() != null) {
                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerRuleProps.Jsii$Proxy that = (ApplicationListenerRuleProps.Jsii$Proxy) o;

            if (!listener.equals(that.listener)) return false;
            if (!priority.equals(that.priority)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            if (this.fixedResponse != null ? !this.fixedResponse.equals(that.fixedResponse) : that.fixedResponse != null) return false;
            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            if (this.pathPatterns != null ? !this.pathPatterns.equals(that.pathPatterns) : that.pathPatterns != null) return false;
            if (this.redirectResponse != null ? !this.redirectResponse.equals(that.redirectResponse) : that.redirectResponse != null) return false;
            return this.targetGroups != null ? this.targetGroups.equals(that.targetGroups) : that.targetGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + (this.priority.hashCode());
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            result = 31 * result + (this.fixedResponse != null ? this.fixedResponse.hashCode() : 0);
            result = 31 * result + (this.hostHeader != null ? this.hostHeader.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.pathPatterns != null ? this.pathPatterns.hashCode() : 0);
            result = 31 * result + (this.redirectResponse != null ? this.redirectResponse.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            return result;
        }
    }
}
