package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a standalone ApplicationListener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-17T20:04:33.375Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationListenerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps {

    /**
     * The load balancer to attach this listener to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer getLoadBalancer();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationListenerProps> {
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer;
        private java.util.List<java.lang.String> certificateArns;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates;
        private software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction defaultAction;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups;
        private java.lang.Boolean open;
        private java.lang.Number port;
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Sets the value of {@link ApplicationListenerProps#getLoadBalancer}
         * @param loadBalancer The load balancer to attach this listener to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getCertificateArns}
         * @param certificateArns The certificates to use on this listener.
         * @return {@code this}
         * @deprecated Use the `certificates` property instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder certificateArns(java.util.List<java.lang.String> certificateArns) {
            this.certificateArns = certificateArns;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getCertificates}
         * @param certificates Certificate list of ACM cert ARNs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder certificates(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
            this.certificates = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate>)certificates;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getDefaultAction}
         * @param defaultAction Default action to take for requests to this listener.
         *                      This allows full control of the default action of the load balancer,
         *                      including Action chaining, fixed responses and redirect responses.
         *                      <p>
         *                      See the <code>ListenerAction</code> class for all options.
         *                      <p>
         *                      Cannot be specified together with <code>defaultTargetGroups</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getDefaultTargetGroups}
         * @param defaultTargetGroups Default target groups to load balance to.
         *                            All target groups will be load balanced to with equal weight and without
         *                            stickiness. For a more complex configuration than that, use
         *                            either <code>defaultAction</code> or <code>addAction()</code>.
         *                            <p>
         *                            Cannot be specified together with <code>defaultAction</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder defaultTargetGroups(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups) {
            this.defaultTargetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup>)defaultTargetGroups;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getOpen}
         * @param open Allow anyone to connect to this listener.
         *             If this is specified, the listener will be opened up to anyone who can reach it.
         *             For internal load balancers this is anyone in the same VPC. For public load
         *             balancers, this is anyone on the internet.
         *             <p>
         *             If you want to be more selective about who can access this load
         *             balancer, set this to <code>false</code> and use the listener's <code>connections</code>
         *             object to selectively grant access to the listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(java.lang.Boolean open) {
            this.open = open;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getPort}
         * @param port The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getProtocol}
         * @param protocol The protocol to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerProps#getSslPolicy}
         * @param sslPolicy The security policy that defines which ciphers and protocols are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationListenerProps build() {
            return new Jsii$Proxy(loadBalancer, certificateArns, certificates, defaultAction, defaultTargetGroups, open, port, protocol, sslPolicy);
        }
    }

    /**
     * An implementation for {@link ApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer;
        private final java.util.List<java.lang.String> certificateArns;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction defaultAction;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups;
        private final java.lang.Boolean open;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loadBalancer = software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class));
            this.certificateArns = software.amazon.jsii.Kernel.get(this, "certificateArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.certificates = software.amazon.jsii.Kernel.get(this, "certificates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate.class)));
            this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class));
            this.defaultTargetGroups = software.amazon.jsii.Kernel.get(this, "defaultTargetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.class)));
            this.open = software.amazon.jsii.Kernel.get(this, "open", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class));
            this.sslPolicy = software.amazon.jsii.Kernel.get(this, "sslPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer, final java.util.List<java.lang.String> certificateArns, final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates, final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction defaultAction, final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups, final java.lang.Boolean open, final java.lang.Number port, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol, final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loadBalancer = java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required");
            this.certificateArns = certificateArns;
            this.certificates = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate>)certificates;
            this.defaultAction = defaultAction;
            this.defaultTargetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup>)defaultTargetGroups;
            this.open = open;
            this.port = port;
            this.protocol = protocol;
            this.sslPolicy = sslPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public final java.util.List<java.lang.String> getCertificateArns() {
            return this.certificateArns;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> getCertificates() {
            return this.certificates;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getDefaultAction() {
            return this.defaultAction;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups() {
            return this.defaultTargetGroups;
        }

        @Override
        public final java.lang.Boolean getOpen() {
            return this.open;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            if (this.getCertificateArns() != null) {
                data.set("certificateArns", om.valueToTree(this.getCertificateArns()));
            }
            if (this.getCertificates() != null) {
                data.set("certificates", om.valueToTree(this.getCertificates()));
            }
            if (this.getDefaultAction() != null) {
                data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
            }
            if (this.getDefaultTargetGroups() != null) {
                data.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
            }
            if (this.getOpen() != null) {
                data.set("open", om.valueToTree(this.getOpen()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSslPolicy() != null) {
                data.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerProps.Jsii$Proxy that = (ApplicationListenerProps.Jsii$Proxy) o;

            if (!loadBalancer.equals(that.loadBalancer)) return false;
            if (this.certificateArns != null ? !this.certificateArns.equals(that.certificateArns) : that.certificateArns != null) return false;
            if (this.certificates != null ? !this.certificates.equals(that.certificates) : that.certificates != null) return false;
            if (this.defaultAction != null ? !this.defaultAction.equals(that.defaultAction) : that.defaultAction != null) return false;
            if (this.defaultTargetGroups != null ? !this.defaultTargetGroups.equals(that.defaultTargetGroups) : that.defaultTargetGroups != null) return false;
            if (this.open != null ? !this.open.equals(that.open) : that.open != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.sslPolicy != null ? this.sslPolicy.equals(that.sslPolicy) : that.sslPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.loadBalancer.hashCode();
            result = 31 * result + (this.certificateArns != null ? this.certificateArns.hashCode() : 0);
            result = 31 * result + (this.certificates != null ? this.certificates.hashCode() : 0);
            result = 31 * result + (this.defaultAction != null ? this.defaultAction.hashCode() : 0);
            result = 31 * result + (this.defaultTargetGroups != null ? this.defaultTargetGroups.hashCode() : 0);
            result = 31 * result + (this.open != null ? this.open.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.sslPolicy != null ? this.sslPolicy.hashCode() : 0);
            return result;
        }
    }
}
