package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Base class for both Application and Network Load Balancers.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:43:40.779Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.BaseLoadBalancer")
public abstract class BaseLoadBalancer extends software.amazon.awscdk.core.Resource {

    protected BaseLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param baseProps This parameter is required.
     * @param additionalProps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BaseLoadBalancer(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps baseProps, final java.lang.Object additionalProps) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(baseProps, "baseProps is required"), additionalProps }));
    }

    /**
     * Remove an attribute from the load balancer.
     * 
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void removeAttribute(final java.lang.String key) {
        this.jsiiCall("removeAttribute", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Set a non-standard attribute on the load balancer.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes
     * @param key This parameter is required.
     * @param value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttribute(final java.lang.String key, final java.lang.String value) {
        this.jsiiCall("setAttribute", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Set a non-standard attribute on the load balancer.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttribute(final java.lang.String key) {
        this.jsiiCall("setAttribute", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * The ARN of this load balancer.
     * 
     * Example:
     * 
     * arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-internal-load-balancer/50dc6c495c0c9188
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getLoadBalancerArn() {
        return this.jsiiGet("loadBalancerArn", java.lang.String.class);
    }

    /**
     * The canonical hosted zone ID of this load balancer.
     * 
     * Example:
     * 
     * Z2P70J7EXAMPLE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getLoadBalancerCanonicalHostedZoneId() {
        return this.jsiiGet("loadBalancerCanonicalHostedZoneId", java.lang.String.class);
    }

    /**
     * The DNS name of this load balancer.
     * 
     * Example:
     * 
     * my-load-balancer-424835706.us-west-2.elb.amazonaws.com
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getLoadBalancerDnsName() {
        return this.jsiiGet("loadBalancerDnsName", java.lang.String.class);
    }

    /**
     * The full name of this load balancer.
     * 
     * Example:
     * 
     * app/my-load-balancer/50dc6c495c0c9188
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getLoadBalancerFullName() {
        return this.jsiiGet("loadBalancerFullName", java.lang.String.class);
    }

    /**
     * The name of this load balancer.
     * 
     * Example:
     * 
     * my-load-balancer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getLoadBalancerName() {
        return this.jsiiGet("loadBalancerName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getLoadBalancerSecurityGroups() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("loadBalancerSecurityGroups", java.util.List.class));
    }

    /**
     * The VPC this load balancer has been created in, if available.
     * 
     * If the Load Balancer was imported, the VPC is not available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }
    }
}
