package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for a network load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:43:40.814Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkLoadBalancerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps {

    /**
     * Indicates whether cross-zone load balancing is enabled.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getCrossZoneEnabled();

    /**
     * @return a {@link Builder} of {@link NetworkLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Boolean crossZoneEnabled;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.Boolean deletionProtection;
        private java.lang.Boolean internetFacing;
        private java.lang.String loadBalancerName;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of CrossZoneEnabled
         * @param crossZoneEnabled Indicates whether cross-zone load balancing is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZoneEnabled(java.lang.Boolean crossZoneEnabled) {
            this.crossZoneEnabled = crossZoneEnabled;
            return this;
        }

        /**
         * Sets the value of Vpc
         * @param vpc The VPC network to place the load balancer in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of DeletionProtection
         * @param deletionProtection Indicates whether deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of InternetFacing
         * @param internetFacing Whether the load balancer has an internet-routable address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(java.lang.Boolean internetFacing) {
            this.internetFacing = internetFacing;
            return this;
        }

        /**
         * Sets the value of LoadBalancerName
         * @param loadBalancerName Name of the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(java.lang.String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * Sets the value of VpcSubnets
         * @param vpcSubnets Where in the VPC to place the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public NetworkLoadBalancerProps build() {
            return new Jsii$Proxy(crossZoneEnabled, vpc, deletionProtection, internetFacing, loadBalancerName, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link NetworkLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkLoadBalancerProps {
        private final java.lang.Boolean crossZoneEnabled;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean deletionProtection;
        private final java.lang.Boolean internetFacing;
        private final java.lang.String loadBalancerName;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.crossZoneEnabled = this.jsiiGet("crossZoneEnabled", java.lang.Boolean.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.deletionProtection = this.jsiiGet("deletionProtection", java.lang.Boolean.class);
            this.internetFacing = this.jsiiGet("internetFacing", java.lang.Boolean.class);
            this.loadBalancerName = this.jsiiGet("loadBalancerName", java.lang.String.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Boolean crossZoneEnabled, software.amazon.awscdk.services.ec2.IVpc vpc, java.lang.Boolean deletionProtection, java.lang.Boolean internetFacing, java.lang.String loadBalancerName, software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.crossZoneEnabled = crossZoneEnabled;
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.deletionProtection = deletionProtection;
            this.internetFacing = internetFacing;
            this.loadBalancerName = loadBalancerName;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public java.lang.Boolean getCrossZoneEnabled() {
            return this.crossZoneEnabled;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public java.lang.Boolean getInternetFacing() {
            return this.internetFacing;
        }

        @Override
        public java.lang.String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getCrossZoneEnabled() != null) {
                obj.set("crossZoneEnabled", om.valueToTree(this.getCrossZoneEnabled()));
            }
            obj.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getDeletionProtection() != null) {
                obj.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getInternetFacing() != null) {
                obj.set("internetFacing", om.valueToTree(this.getInternetFacing()));
            }
            if (this.getLoadBalancerName() != null) {
                obj.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
            }
            if (this.getVpcSubnets() != null) {
                obj.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkLoadBalancerProps.Jsii$Proxy that = (NetworkLoadBalancerProps.Jsii$Proxy) o;

            if (this.crossZoneEnabled != null ? !this.crossZoneEnabled.equals(that.crossZoneEnabled) : that.crossZoneEnabled != null) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.internetFacing != null ? !this.internetFacing.equals(that.internetFacing) : that.internetFacing != null) return false;
            if (this.loadBalancerName != null ? !this.loadBalancerName.equals(that.loadBalancerName) : that.loadBalancerName != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.crossZoneEnabled != null ? this.crossZoneEnabled.hashCode() : 0;
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.internetFacing != null ? this.internetFacing.hashCode() : 0);
            result = 31 * result + (this.loadBalancerName != null ? this.loadBalancerName.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
