/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.Protocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.jsii.JsiiSerializable;

public interface BaseNetworkListenerProps
extends JsiiSerializable {
    public Number getPort();

    public List<INetworkListenerCertificateProps> getCertificates();

    public List<INetworkTargetGroup> getDefaultTargetGroups();

    public Protocol getProtocol();

    public SslPolicy getSslPolicy();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number port;
        private List<INetworkListenerCertificateProps> certificates;
        private List<INetworkTargetGroup> defaultTargetGroups;
        private Protocol protocol;
        private SslPolicy sslPolicy;

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder certificates(List<INetworkListenerCertificateProps> certificates) {
            this.certificates = certificates;
            return this;
        }

        public Builder defaultTargetGroups(List<INetworkTargetGroup> defaultTargetGroups) {
            this.defaultTargetGroups = defaultTargetGroups;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder sslPolicy(SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public BaseNetworkListenerProps build() {
            return new Jsii.Proxy(this.port, this.certificates, this.defaultTargetGroups, this.protocol, this.sslPolicy, null);
        }
    }
}

