package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define a Network Target Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-21T20:06:03.886Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkTargetGroup")
public class NetworkTargetGroup extends software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase implements software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup {

    protected NetworkTargetGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing target group.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup fromTargetGroupAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup.class, "fromTargetGroupAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (deprecated) Import an existing listener.
     * <p>
     * @deprecated Use `fromTargetGroupAttributes` instead
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup doImport(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup.class, "import", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a load balancing target to this target group.
     * <p>
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget... targets) {
        software.amazon.jsii.Kernel.call(this, "addTarget", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
    }

    /**
     * The number of targets that are considered healthy.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHealthyHostCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of targets that are considered healthy.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount() {
        return software.amazon.jsii.Kernel.call(this, "metricHealthyHostCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of targets that are considered unhealthy.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUnHealthyHostCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricUnHealthyHostCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of targets that are considered unhealthy.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUnHealthyHostCount() {
        return software.amazon.jsii.Kernel.call(this, "metricUnHealthyHostCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Register a listener that is load balancing to this target group.
     * <p>
     * Don't call this directly. It will be called by listeners.
     * <p>
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener) {
        software.amazon.jsii.Kernel.call(this, "registerListener", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Full name of first load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFirstLoadBalancerFullName() {
        return software.amazon.jsii.Kernel.get(this, "firstLoadBalancerFullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps.Builder();
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * <p>
         * The range is 0-3600 seconds.
         * <p>
         * Default: 300
         * <p>
         * @return {@code this}
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(final software.amazon.awscdk.core.Duration deregistrationDelay) {
            this.props.deregistrationDelay(deregistrationDelay);
            return this;
        }

        /**
         * Health check configuration.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param healthCheck Health check configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * The name of the target group.
         * <p>
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * <p>
         * Default: - Automatically generated.
         * <p>
         * @return {@code this}
         * @param targetGroupName The name of the target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(final java.lang.String targetGroupName) {
            this.props.targetGroupName(targetGroupName);
            return this;
        }

        /**
         * The type of targets registered to this TargetGroup, either IP or Instance.
         * <p>
         * All targets registered into the group must be of this type. If you
         * register targets to the TargetGroup in the CDK app, the TargetType is
         * determined automatically.
         * <p>
         * Default: - Determined automatically.
         * <p>
         * @return {@code this}
         * @param targetType The type of targets registered to this TargetGroup, either IP or Instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.props.targetType(targetType);
            return this;
        }

        /**
         * The virtual private cloud (VPC).
         * <p>
         * only if <code>TargetType</code> is <code>Ip</code> or <code>InstanceId</code>
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param vpc The virtual private cloud (VPC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The port on which the listener listens for requests.
         * <p>
         * @return {@code this}
         * @param port The port on which the listener listens for requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * Indicates whether client IP preservation is enabled.
         * <p>
         * Default: false if the target group type is IP address and the
         * target group protocol is TCP or TLS. Otherwise, true.
         * <p>
         * @return {@code this}
         * @param preserveClientIp Indicates whether client IP preservation is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveClientIp(final java.lang.Boolean preserveClientIp) {
            this.props.preserveClientIp(preserveClientIp);
            return this;
        }

        /**
         * Protocol for target group, expects TCP, TLS, UDP, or TCP_UDP.
         * <p>
         * Default: - TCP
         * <p>
         * @return {@code this}
         * @param protocol Protocol for target group, expects TCP, TLS, UDP, or TCP_UDP. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * Indicates whether Proxy Protocol version 2 is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param proxyProtocolV2 Indicates whether Proxy Protocol version 2 is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyProtocolV2(final java.lang.Boolean proxyProtocolV2) {
            this.props.proxyProtocolV2(proxyProtocolV2);
            return this;
        }

        /**
         * The targets to add to this target group.
         * <p>
         * Can be <code>Instance</code>, <code>IPAddress</code>, or any self-registering load balancing
         * target. If you use either <code>Instance</code> or <code>IPAddress</code> as targets, all
         * target must be of the same type.
         * <p>
         * Default: - No targets.
         * <p>
         * @return {@code this}
         * @param targets The targets to add to this target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
