package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining an Application Load Balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:34:48.682Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps {

    /**
     * Indicates whether HTTP/2 is enabled.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getHttp2Enabled();

    /**
     * The load balancer idle timeout, in seconds.
     * 
     * Default: 60
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getIdleTimeout();

    /**
     * The type of IP addresses to use.
     * 
     * Only applies to application load balancers.
     * 
     * Default: IpAddressType.Ipv4
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType();

    /**
     * Security group to associate with this load balancer.
     * 
     * Default: A security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup();

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Boolean http2Enabled;
        private software.amazon.awscdk.core.Duration idleTimeout;
        private software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.Boolean deletionProtection;
        private java.lang.Boolean internetFacing;
        private java.lang.String loadBalancerName;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of Http2Enabled
         * @param http2Enabled Indicates whether HTTP/2 is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder http2Enabled(java.lang.Boolean http2Enabled) {
            this.http2Enabled = http2Enabled;
            return this;
        }

        /**
         * Sets the value of IdleTimeout
         * @param idleTimeout The load balancer idle timeout, in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleTimeout(software.amazon.awscdk.core.Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        /**
         * Sets the value of IpAddressType
         * @param ipAddressType The type of IP addresses to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of SecurityGroup
         * @param securityGroup Security group to associate with this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of Vpc
         * @param vpc The VPC network to place the load balancer in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of DeletionProtection
         * @param deletionProtection Indicates whether deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of InternetFacing
         * @param internetFacing Whether the load balancer has an internet-routable address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(java.lang.Boolean internetFacing) {
            this.internetFacing = internetFacing;
            return this;
        }

        /**
         * Sets the value of LoadBalancerName
         * @param loadBalancerName Name of the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(java.lang.String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * Sets the value of VpcSubnets
         * @param vpcSubnets Where in the VPC to place the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationLoadBalancerProps build() {
            return new Jsii$Proxy(http2Enabled, idleTimeout, ipAddressType, securityGroup, vpc, deletionProtection, internetFacing, loadBalancerName, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancerProps {
        private final java.lang.Boolean http2Enabled;
        private final software.amazon.awscdk.core.Duration idleTimeout;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean deletionProtection;
        private final java.lang.Boolean internetFacing;
        private final java.lang.String loadBalancerName;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.http2Enabled = this.jsiiGet("http2Enabled", java.lang.Boolean.class);
            this.idleTimeout = this.jsiiGet("idleTimeout", software.amazon.awscdk.core.Duration.class);
            this.ipAddressType = this.jsiiGet("ipAddressType", software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.deletionProtection = this.jsiiGet("deletionProtection", java.lang.Boolean.class);
            this.internetFacing = this.jsiiGet("internetFacing", java.lang.Boolean.class);
            this.loadBalancerName = this.jsiiGet("loadBalancerName", java.lang.String.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Boolean http2Enabled, software.amazon.awscdk.core.Duration idleTimeout, software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType, software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, software.amazon.awscdk.services.ec2.IVpc vpc, java.lang.Boolean deletionProtection, java.lang.Boolean internetFacing, java.lang.String loadBalancerName, software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.http2Enabled = http2Enabled;
            this.idleTimeout = idleTimeout;
            this.ipAddressType = ipAddressType;
            this.securityGroup = securityGroup;
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.deletionProtection = deletionProtection;
            this.internetFacing = internetFacing;
            this.loadBalancerName = loadBalancerName;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public java.lang.Boolean getHttp2Enabled() {
            return this.http2Enabled;
        }

        @Override
        public software.amazon.awscdk.core.Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public java.lang.Boolean getInternetFacing() {
            return this.internetFacing;
        }

        @Override
        public java.lang.String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getHttp2Enabled() != null) {
                obj.set("http2Enabled", om.valueToTree(this.getHttp2Enabled()));
            }
            if (this.getIdleTimeout() != null) {
                obj.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));
            }
            if (this.getIpAddressType() != null) {
                obj.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getSecurityGroup() != null) {
                obj.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            obj.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getDeletionProtection() != null) {
                obj.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getInternetFacing() != null) {
                obj.set("internetFacing", om.valueToTree(this.getInternetFacing()));
            }
            if (this.getLoadBalancerName() != null) {
                obj.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
            }
            if (this.getVpcSubnets() != null) {
                obj.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancerProps.Jsii$Proxy that = (ApplicationLoadBalancerProps.Jsii$Proxy) o;

            if (this.http2Enabled != null ? !this.http2Enabled.equals(that.http2Enabled) : that.http2Enabled != null) return false;
            if (this.idleTimeout != null ? !this.idleTimeout.equals(that.idleTimeout) : that.idleTimeout != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.internetFacing != null ? !this.internetFacing.equals(that.internetFacing) : that.internetFacing != null) return false;
            if (this.loadBalancerName != null ? !this.loadBalancerName.equals(that.loadBalancerName) : that.loadBalancerName != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.http2Enabled != null ? this.http2Enabled.hashCode() : 0;
            result = 31 * result + (this.idleTimeout != null ? this.idleTimeout.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.internetFacing != null ? this.internetFacing.hashCode() : 0);
            result = 31 * result + (this.loadBalancerName != null ? this.loadBalancerName.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
