package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:34:48.693Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListenerRule")
public class CfnListenerRule extends software.amazon.awscdk.core.CfnResource {

    protected CfnListenerRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnListenerRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ElasticLoadBalancingV2::ListenerRule`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnListenerRule(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getActions() {
        return this.jsiiGet("actions", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setActions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setActions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getConditions() {
        return this.jsiiGet("conditions", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConditions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("conditions", java.util.Objects.requireNonNull(value, "conditions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConditions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("conditions", java.util.Objects.requireNonNull(value, "conditions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getListenerArn() {
        return this.jsiiGet("listenerArn", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setListenerArn(final java.lang.String value) {
        this.jsiiSet("listenerArn", java.util.Objects.requireNonNull(value, "listenerArn is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Number getPriority() {
        return this.jsiiGet("priority", java.lang.Number.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPriority(final java.lang.Number value) {
        this.jsiiSet("priority", java.util.Objects.requireNonNull(value, "priority is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.ActionProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticatecognitoconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAuthenticateCognitoConfig();

        /**
         * `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticateoidcconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAuthenticateOidcConfig();

        /**
         * `CfnListenerRule.ActionProperty.FixedResponseConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-fixedresponseconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFixedResponseConfig();

        /**
         * `CfnListenerRule.ActionProperty.Order`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-order
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getOrder();

        /**
         * `CfnListenerRule.ActionProperty.RedirectConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-redirectconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRedirectConfig();

        /**
         * `CfnListenerRule.ActionProperty.TargetGroupArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTargetGroupArn();

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String type;
            private java.lang.Object authenticateCognitoConfig;
            private java.lang.Object authenticateOidcConfig;
            private java.lang.Object fixedResponseConfig;
            private java.lang.Number order;
            private java.lang.Object redirectConfig;
            private java.lang.String targetGroupArn;

            /**
             * Sets the value of Type
             * @param type `CfnListenerRule.ActionProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of AuthenticateCognitoConfig
             * @param authenticateCognitoConfig `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authenticateCognitoConfig(software.amazon.awscdk.core.IResolvable authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            /**
             * Sets the value of AuthenticateCognitoConfig
             * @param authenticateCognitoConfig `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authenticateCognitoConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateCognitoConfigProperty authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            /**
             * Sets the value of AuthenticateOidcConfig
             * @param authenticateOidcConfig `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authenticateOidcConfig(software.amazon.awscdk.core.IResolvable authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            /**
             * Sets the value of AuthenticateOidcConfig
             * @param authenticateOidcConfig `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authenticateOidcConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateOidcConfigProperty authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            /**
             * Sets the value of FixedResponseConfig
             * @param fixedResponseConfig `CfnListenerRule.ActionProperty.FixedResponseConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder fixedResponseConfig(software.amazon.awscdk.core.IResolvable fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            /**
             * Sets the value of FixedResponseConfig
             * @param fixedResponseConfig `CfnListenerRule.ActionProperty.FixedResponseConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder fixedResponseConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.FixedResponseConfigProperty fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            /**
             * Sets the value of Order
             * @param order `CfnListenerRule.ActionProperty.Order`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder order(java.lang.Number order) {
                this.order = order;
                return this;
            }

            /**
             * Sets the value of RedirectConfig
             * @param redirectConfig `CfnListenerRule.ActionProperty.RedirectConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder redirectConfig(software.amazon.awscdk.core.IResolvable redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            /**
             * Sets the value of RedirectConfig
             * @param redirectConfig `CfnListenerRule.ActionProperty.RedirectConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder redirectConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.RedirectConfigProperty redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            /**
             * Sets the value of TargetGroupArn
             * @param targetGroupArn `CfnListenerRule.ActionProperty.TargetGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ActionProperty build() {
                return new Jsii$Proxy(type, authenticateCognitoConfig, authenticateOidcConfig, fixedResponseConfig, order, redirectConfig, targetGroupArn);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.String type;
            private final java.lang.Object authenticateCognitoConfig;
            private final java.lang.Object authenticateOidcConfig;
            private final java.lang.Object fixedResponseConfig;
            private final java.lang.Number order;
            private final java.lang.Object redirectConfig;
            private final java.lang.String targetGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.authenticateCognitoConfig = this.jsiiGet("authenticateCognitoConfig", java.lang.Object.class);
                this.authenticateOidcConfig = this.jsiiGet("authenticateOidcConfig", java.lang.Object.class);
                this.fixedResponseConfig = this.jsiiGet("fixedResponseConfig", java.lang.Object.class);
                this.order = this.jsiiGet("order", java.lang.Number.class);
                this.redirectConfig = this.jsiiGet("redirectConfig", java.lang.Object.class);
                this.targetGroupArn = this.jsiiGet("targetGroupArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String type, java.lang.Object authenticateCognitoConfig, java.lang.Object authenticateOidcConfig, java.lang.Object fixedResponseConfig, java.lang.Number order, java.lang.Object redirectConfig, java.lang.String targetGroupArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                this.authenticateOidcConfig = authenticateOidcConfig;
                this.fixedResponseConfig = fixedResponseConfig;
                this.order = order;
                this.redirectConfig = redirectConfig;
                this.targetGroupArn = targetGroupArn;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.Object getAuthenticateCognitoConfig() {
                return this.authenticateCognitoConfig;
            }

            @Override
            public java.lang.Object getAuthenticateOidcConfig() {
                return this.authenticateOidcConfig;
            }

            @Override
            public java.lang.Object getFixedResponseConfig() {
                return this.fixedResponseConfig;
            }

            @Override
            public java.lang.Number getOrder() {
                return this.order;
            }

            @Override
            public java.lang.Object getRedirectConfig() {
                return this.redirectConfig;
            }

            @Override
            public java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("type", om.valueToTree(this.getType()));
                if (this.getAuthenticateCognitoConfig() != null) {
                    obj.set("authenticateCognitoConfig", om.valueToTree(this.getAuthenticateCognitoConfig()));
                }
                if (this.getAuthenticateOidcConfig() != null) {
                    obj.set("authenticateOidcConfig", om.valueToTree(this.getAuthenticateOidcConfig()));
                }
                if (this.getFixedResponseConfig() != null) {
                    obj.set("fixedResponseConfig", om.valueToTree(this.getFixedResponseConfig()));
                }
                if (this.getOrder() != null) {
                    obj.set("order", om.valueToTree(this.getOrder()));
                }
                if (this.getRedirectConfig() != null) {
                    obj.set("redirectConfig", om.valueToTree(this.getRedirectConfig()));
                }
                if (this.getTargetGroupArn() != null) {
                    obj.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.authenticateCognitoConfig != null ? !this.authenticateCognitoConfig.equals(that.authenticateCognitoConfig) : that.authenticateCognitoConfig != null) return false;
                if (this.authenticateOidcConfig != null ? !this.authenticateOidcConfig.equals(that.authenticateOidcConfig) : that.authenticateOidcConfig != null) return false;
                if (this.fixedResponseConfig != null ? !this.fixedResponseConfig.equals(that.fixedResponseConfig) : that.fixedResponseConfig != null) return false;
                if (this.order != null ? !this.order.equals(that.order) : that.order != null) return false;
                if (this.redirectConfig != null ? !this.redirectConfig.equals(that.redirectConfig) : that.redirectConfig != null) return false;
                return this.targetGroupArn != null ? this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.authenticateCognitoConfig != null ? this.authenticateCognitoConfig.hashCode() : 0);
                result = 31 * result + (this.authenticateOidcConfig != null ? this.authenticateOidcConfig.hashCode() : 0);
                result = 31 * result + (this.fixedResponseConfig != null ? this.fixedResponseConfig.hashCode() : 0);
                result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
                result = 31 * result + (this.redirectConfig != null ? this.redirectConfig.hashCode() : 0);
                result = 31 * result + (this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AuthenticateCognitoConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUserPoolArn();

        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolClientId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolclientid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUserPoolClientId();

        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolDomain`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpooldomain
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUserPoolDomain();

        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-authenticationrequestextraparams
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAuthenticationRequestExtraParams();

        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-onunauthenticatedrequest
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getOnUnauthenticatedRequest();

        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.Scope`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-scope
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getScope();

        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionCookieName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessioncookiename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSessionCookieName();

        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionTimeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessiontimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getSessionTimeout();

        /**
         * @return a {@link Builder} of {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String userPoolArn;
            private java.lang.String userPoolClientId;
            private java.lang.String userPoolDomain;
            private java.lang.Object authenticationRequestExtraParams;
            private java.lang.String onUnauthenticatedRequest;
            private java.lang.String scope;
            private java.lang.String sessionCookieName;
            private java.lang.Number sessionTimeout;

            /**
             * Sets the value of UserPoolArn
             * @param userPoolArn `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder userPoolArn(java.lang.String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            /**
             * Sets the value of UserPoolClientId
             * @param userPoolClientId `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolClientId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder userPoolClientId(java.lang.String userPoolClientId) {
                this.userPoolClientId = userPoolClientId;
                return this;
            }

            /**
             * Sets the value of UserPoolDomain
             * @param userPoolDomain `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolDomain`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder userPoolDomain(java.lang.String userPoolDomain) {
                this.userPoolDomain = userPoolDomain;
                return this;
            }

            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param authenticationRequestExtraParams `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authenticationRequestExtraParams(software.amazon.awscdk.core.IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param authenticationRequestExtraParams `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param onUnauthenticatedRequest `CfnListenerRule.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder onUnauthenticatedRequest(java.lang.String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            /**
             * Sets the value of Scope
             * @param scope `CfnListenerRule.AuthenticateCognitoConfigProperty.Scope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of SessionCookieName
             * @param sessionCookieName `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionCookieName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sessionCookieName(java.lang.String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            /**
             * Sets the value of SessionTimeout
             * @param sessionTimeout `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sessionTimeout(java.lang.Number sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateCognitoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AuthenticateCognitoConfigProperty build() {
                return new Jsii$Proxy(userPoolArn, userPoolClientId, userPoolDomain, authenticationRequestExtraParams, onUnauthenticatedRequest, scope, sessionCookieName, sessionTimeout);
            }
        }

        /**
         * An implementation for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateCognitoConfigProperty {
            private final java.lang.String userPoolArn;
            private final java.lang.String userPoolClientId;
            private final java.lang.String userPoolDomain;
            private final java.lang.Object authenticationRequestExtraParams;
            private final java.lang.String onUnauthenticatedRequest;
            private final java.lang.String scope;
            private final java.lang.String sessionCookieName;
            private final java.lang.Number sessionTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.userPoolArn = this.jsiiGet("userPoolArn", java.lang.String.class);
                this.userPoolClientId = this.jsiiGet("userPoolClientId", java.lang.String.class);
                this.userPoolDomain = this.jsiiGet("userPoolDomain", java.lang.String.class);
                this.authenticationRequestExtraParams = this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
                this.onUnauthenticatedRequest = this.jsiiGet("onUnauthenticatedRequest", java.lang.String.class);
                this.scope = this.jsiiGet("scope", java.lang.String.class);
                this.sessionCookieName = this.jsiiGet("sessionCookieName", java.lang.String.class);
                this.sessionTimeout = this.jsiiGet("sessionTimeout", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String userPoolArn, java.lang.String userPoolClientId, java.lang.String userPoolDomain, java.lang.Object authenticationRequestExtraParams, java.lang.String onUnauthenticatedRequest, java.lang.String scope, java.lang.String sessionCookieName, java.lang.Number sessionTimeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.userPoolArn = java.util.Objects.requireNonNull(userPoolArn, "userPoolArn is required");
                this.userPoolClientId = java.util.Objects.requireNonNull(userPoolClientId, "userPoolClientId is required");
                this.userPoolDomain = java.util.Objects.requireNonNull(userPoolDomain, "userPoolDomain is required");
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                this.scope = scope;
                this.sessionCookieName = sessionCookieName;
                this.sessionTimeout = sessionTimeout;
            }

            @Override
            public java.lang.String getUserPoolArn() {
                return this.userPoolArn;
            }

            @Override
            public java.lang.String getUserPoolClientId() {
                return this.userPoolClientId;
            }

            @Override
            public java.lang.String getUserPoolDomain() {
                return this.userPoolDomain;
            }

            @Override
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.authenticationRequestExtraParams;
            }

            @Override
            public java.lang.String getOnUnauthenticatedRequest() {
                return this.onUnauthenticatedRequest;
            }

            @Override
            public java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public java.lang.String getSessionCookieName() {
                return this.sessionCookieName;
            }

            @Override
            public java.lang.Number getSessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                obj.set("userPoolClientId", om.valueToTree(this.getUserPoolClientId()));
                obj.set("userPoolDomain", om.valueToTree(this.getUserPoolDomain()));
                if (this.getAuthenticationRequestExtraParams() != null) {
                    obj.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                }
                if (this.getOnUnauthenticatedRequest() != null) {
                    obj.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                }
                if (this.getScope() != null) {
                    obj.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSessionCookieName() != null) {
                    obj.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                }
                if (this.getSessionTimeout() != null) {
                    obj.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticateCognitoConfigProperty.Jsii$Proxy that = (AuthenticateCognitoConfigProperty.Jsii$Proxy) o;

                if (!userPoolArn.equals(that.userPoolArn)) return false;
                if (!userPoolClientId.equals(that.userPoolClientId)) return false;
                if (!userPoolDomain.equals(that.userPoolDomain)) return false;
                if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
                if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
                return this.sessionTimeout != null ? this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout == null;
            }

            @Override
            public int hashCode() {
                int result = this.userPoolArn.hashCode();
                result = 31 * result + (this.userPoolClientId.hashCode());
                result = 31 * result + (this.userPoolDomain.hashCode());
                result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
                result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
                result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AuthenticateOidcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authorizationendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAuthorizationEndpoint();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getClientId();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientSecret`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientsecret
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getClientSecret();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.Issuer`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-issuer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIssuer();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.TokenEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-tokenendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTokenEndpoint();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-userinfoendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUserInfoEndpoint();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authenticationrequestextraparams
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAuthenticationRequestExtraParams();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-onunauthenticatedrequest
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getOnUnauthenticatedRequest();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.Scope`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-scope
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getScope();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionCookieName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessioncookiename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSessionCookieName();

        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionTimeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessiontimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getSessionTimeout();

        /**
         * @return a {@link Builder} of {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String authorizationEndpoint;
            private java.lang.String clientId;
            private java.lang.String clientSecret;
            private java.lang.String issuer;
            private java.lang.String tokenEndpoint;
            private java.lang.String userInfoEndpoint;
            private java.lang.Object authenticationRequestExtraParams;
            private java.lang.String onUnauthenticatedRequest;
            private java.lang.String scope;
            private java.lang.String sessionCookieName;
            private java.lang.Number sessionTimeout;

            /**
             * Sets the value of AuthorizationEndpoint
             * @param authorizationEndpoint `CfnListenerRule.AuthenticateOidcConfigProperty.AuthorizationEndpoint`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authorizationEndpoint(java.lang.String authorizationEndpoint) {
                this.authorizationEndpoint = authorizationEndpoint;
                return this;
            }

            /**
             * Sets the value of ClientId
             * @param clientId `CfnListenerRule.AuthenticateOidcConfigProperty.ClientId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of ClientSecret
             * @param clientSecret `CfnListenerRule.AuthenticateOidcConfigProperty.ClientSecret`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of Issuer
             * @param issuer `CfnListenerRule.AuthenticateOidcConfigProperty.Issuer`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Sets the value of TokenEndpoint
             * @param tokenEndpoint `CfnListenerRule.AuthenticateOidcConfigProperty.TokenEndpoint`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tokenEndpoint(java.lang.String tokenEndpoint) {
                this.tokenEndpoint = tokenEndpoint;
                return this;
            }

            /**
             * Sets the value of UserInfoEndpoint
             * @param userInfoEndpoint `CfnListenerRule.AuthenticateOidcConfigProperty.UserInfoEndpoint`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder userInfoEndpoint(java.lang.String userInfoEndpoint) {
                this.userInfoEndpoint = userInfoEndpoint;
                return this;
            }

            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param authenticationRequestExtraParams `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authenticationRequestExtraParams(software.amazon.awscdk.core.IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param authenticationRequestExtraParams `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param onUnauthenticatedRequest `CfnListenerRule.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder onUnauthenticatedRequest(java.lang.String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            /**
             * Sets the value of Scope
             * @param scope `CfnListenerRule.AuthenticateOidcConfigProperty.Scope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of SessionCookieName
             * @param sessionCookieName `CfnListenerRule.AuthenticateOidcConfigProperty.SessionCookieName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sessionCookieName(java.lang.String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            /**
             * Sets the value of SessionTimeout
             * @param sessionTimeout `CfnListenerRule.AuthenticateOidcConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sessionTimeout(java.lang.Number sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateOidcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AuthenticateOidcConfigProperty build() {
                return new Jsii$Proxy(authorizationEndpoint, clientId, clientSecret, issuer, tokenEndpoint, userInfoEndpoint, authenticationRequestExtraParams, onUnauthenticatedRequest, scope, sessionCookieName, sessionTimeout);
            }
        }

        /**
         * An implementation for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateOidcConfigProperty {
            private final java.lang.String authorizationEndpoint;
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String issuer;
            private final java.lang.String tokenEndpoint;
            private final java.lang.String userInfoEndpoint;
            private final java.lang.Object authenticationRequestExtraParams;
            private final java.lang.String onUnauthenticatedRequest;
            private final java.lang.String scope;
            private final java.lang.String sessionCookieName;
            private final java.lang.Number sessionTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.authorizationEndpoint = this.jsiiGet("authorizationEndpoint", java.lang.String.class);
                this.clientId = this.jsiiGet("clientId", java.lang.String.class);
                this.clientSecret = this.jsiiGet("clientSecret", java.lang.String.class);
                this.issuer = this.jsiiGet("issuer", java.lang.String.class);
                this.tokenEndpoint = this.jsiiGet("tokenEndpoint", java.lang.String.class);
                this.userInfoEndpoint = this.jsiiGet("userInfoEndpoint", java.lang.String.class);
                this.authenticationRequestExtraParams = this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
                this.onUnauthenticatedRequest = this.jsiiGet("onUnauthenticatedRequest", java.lang.String.class);
                this.scope = this.jsiiGet("scope", java.lang.String.class);
                this.sessionCookieName = this.jsiiGet("sessionCookieName", java.lang.String.class);
                this.sessionTimeout = this.jsiiGet("sessionTimeout", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String authorizationEndpoint, java.lang.String clientId, java.lang.String clientSecret, java.lang.String issuer, java.lang.String tokenEndpoint, java.lang.String userInfoEndpoint, java.lang.Object authenticationRequestExtraParams, java.lang.String onUnauthenticatedRequest, java.lang.String scope, java.lang.String sessionCookieName, java.lang.Number sessionTimeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationEndpoint = java.util.Objects.requireNonNull(authorizationEndpoint, "authorizationEndpoint is required");
                this.clientId = java.util.Objects.requireNonNull(clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(clientSecret, "clientSecret is required");
                this.issuer = java.util.Objects.requireNonNull(issuer, "issuer is required");
                this.tokenEndpoint = java.util.Objects.requireNonNull(tokenEndpoint, "tokenEndpoint is required");
                this.userInfoEndpoint = java.util.Objects.requireNonNull(userInfoEndpoint, "userInfoEndpoint is required");
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                this.scope = scope;
                this.sessionCookieName = sessionCookieName;
                this.sessionTimeout = sessionTimeout;
            }

            @Override
            public java.lang.String getAuthorizationEndpoint() {
                return this.authorizationEndpoint;
            }

            @Override
            public java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public java.lang.String getTokenEndpoint() {
                return this.tokenEndpoint;
            }

            @Override
            public java.lang.String getUserInfoEndpoint() {
                return this.userInfoEndpoint;
            }

            @Override
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.authenticationRequestExtraParams;
            }

            @Override
            public java.lang.String getOnUnauthenticatedRequest() {
                return this.onUnauthenticatedRequest;
            }

            @Override
            public java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public java.lang.String getSessionCookieName() {
                return this.sessionCookieName;
            }

            @Override
            public java.lang.Number getSessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
                obj.set("clientId", om.valueToTree(this.getClientId()));
                obj.set("clientSecret", om.valueToTree(this.getClientSecret()));
                obj.set("issuer", om.valueToTree(this.getIssuer()));
                obj.set("tokenEndpoint", om.valueToTree(this.getTokenEndpoint()));
                obj.set("userInfoEndpoint", om.valueToTree(this.getUserInfoEndpoint()));
                if (this.getAuthenticationRequestExtraParams() != null) {
                    obj.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                }
                if (this.getOnUnauthenticatedRequest() != null) {
                    obj.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                }
                if (this.getScope() != null) {
                    obj.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSessionCookieName() != null) {
                    obj.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                }
                if (this.getSessionTimeout() != null) {
                    obj.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticateOidcConfigProperty.Jsii$Proxy that = (AuthenticateOidcConfigProperty.Jsii$Proxy) o;

                if (!authorizationEndpoint.equals(that.authorizationEndpoint)) return false;
                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (!issuer.equals(that.issuer)) return false;
                if (!tokenEndpoint.equals(that.tokenEndpoint)) return false;
                if (!userInfoEndpoint.equals(that.userInfoEndpoint)) return false;
                if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
                if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
                return this.sessionTimeout != null ? this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout == null;
            }

            @Override
            public int hashCode() {
                int result = this.authorizationEndpoint.hashCode();
                result = 31 * result + (this.clientId.hashCode());
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.issuer.hashCode());
                result = 31 * result + (this.tokenEndpoint.hashCode());
                result = 31 * result + (this.userInfoEndpoint.hashCode());
                result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
                result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
                result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FixedResponseConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.FixedResponseConfigProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatusCode();

        /**
         * `CfnListenerRule.FixedResponseConfigProperty.ContentType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-contenttype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getContentType();

        /**
         * `CfnListenerRule.FixedResponseConfigProperty.MessageBody`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-messagebody
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMessageBody();

        /**
         * @return a {@link Builder} of {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String statusCode;
            private java.lang.String contentType;
            private java.lang.String messageBody;

            /**
             * Sets the value of StatusCode
             * @param statusCode `CfnListenerRule.FixedResponseConfigProperty.StatusCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of ContentType
             * @param contentType `CfnListenerRule.FixedResponseConfigProperty.ContentType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Sets the value of MessageBody
             * @param messageBody `CfnListenerRule.FixedResponseConfigProperty.MessageBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder messageBody(java.lang.String messageBody) {
                this.messageBody = messageBody;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedResponseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FixedResponseConfigProperty build() {
                return new Jsii$Proxy(statusCode, contentType, messageBody);
            }
        }

        /**
         * An implementation for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FixedResponseConfigProperty {
            private final java.lang.String statusCode;
            private final java.lang.String contentType;
            private final java.lang.String messageBody;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
                this.contentType = this.jsiiGet("contentType", java.lang.String.class);
                this.messageBody = this.jsiiGet("messageBody", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String statusCode, java.lang.String contentType, java.lang.String messageBody) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
                this.contentType = contentType;
                this.messageBody = messageBody;
            }

            @Override
            public java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            public java.lang.String getMessageBody() {
                return this.messageBody;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getContentType() != null) {
                    obj.set("contentType", om.valueToTree(this.getContentType()));
                }
                if (this.getMessageBody() != null) {
                    obj.set("messageBody", om.valueToTree(this.getMessageBody()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FixedResponseConfigProperty.Jsii$Proxy that = (FixedResponseConfigProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
                return this.messageBody != null ? this.messageBody.equals(that.messageBody) : that.messageBody == null;
            }

            @Override
            public int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
                result = 31 * result + (this.messageBody != null ? this.messageBody.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface HostHeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.HostHeaderConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-hostheaderconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link HostHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> values;

            /**
             * Sets the value of Values
             * @param values `CfnListenerRule.HostHeaderConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostHeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public HostHeaderConfigProperty build() {
                return new Jsii$Proxy(values);
            }
        }

        /**
         * An implementation for {@link HostHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostHeaderConfigProperty {
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.values = this.jsiiGet("values", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> values) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = values;
            }

            @Override
            public java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getValues() != null) {
                    obj.set("values", om.valueToTree(this.getValues()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostHeaderConfigProperty.Jsii$Proxy that = (HostHeaderConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface HttpHeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.HttpHeaderConfigProperty.HttpHeaderName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-httpheadername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHttpHeaderName();

        /**
         * `CfnListenerRule.HttpHeaderConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link HttpHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String httpHeaderName;
            private java.util.List<java.lang.String> values;

            /**
             * Sets the value of HttpHeaderName
             * @param httpHeaderName `CfnListenerRule.HttpHeaderConfigProperty.HttpHeaderName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder httpHeaderName(java.lang.String httpHeaderName) {
                this.httpHeaderName = httpHeaderName;
                return this;
            }

            /**
             * Sets the value of Values
             * @param values `CfnListenerRule.HttpHeaderConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpHeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public HttpHeaderConfigProperty build() {
                return new Jsii$Proxy(httpHeaderName, values);
            }
        }

        /**
         * An implementation for {@link HttpHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpHeaderConfigProperty {
            private final java.lang.String httpHeaderName;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.httpHeaderName = this.jsiiGet("httpHeaderName", java.lang.String.class);
                this.values = this.jsiiGet("values", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String httpHeaderName, java.util.List<java.lang.String> values) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpHeaderName = httpHeaderName;
                this.values = values;
            }

            @Override
            public java.lang.String getHttpHeaderName() {
                return this.httpHeaderName;
            }

            @Override
            public java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getHttpHeaderName() != null) {
                    obj.set("httpHeaderName", om.valueToTree(this.getHttpHeaderName()));
                }
                if (this.getValues() != null) {
                    obj.set("values", om.valueToTree(this.getValues()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpHeaderConfigProperty.Jsii$Proxy that = (HttpHeaderConfigProperty.Jsii$Proxy) o;

                if (this.httpHeaderName != null ? !this.httpHeaderName.equals(that.httpHeaderName) : that.httpHeaderName != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public int hashCode() {
                int result = this.httpHeaderName != null ? this.httpHeaderName.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface HttpRequestMethodConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.HttpRequestMethodConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html#cfn-elasticloadbalancingv2-listenerrule-httprequestmethodconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link HttpRequestMethodConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpRequestMethodConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> values;

            /**
             * Sets the value of Values
             * @param values `CfnListenerRule.HttpRequestMethodConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpRequestMethodConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public HttpRequestMethodConfigProperty build() {
                return new Jsii$Proxy(values);
            }
        }

        /**
         * An implementation for {@link HttpRequestMethodConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRequestMethodConfigProperty {
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.values = this.jsiiGet("values", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> values) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = values;
            }

            @Override
            public java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getValues() != null) {
                    obj.set("values", om.valueToTree(this.getValues()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpRequestMethodConfigProperty.Jsii$Proxy that = (HttpRequestMethodConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PathPatternConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.PathPatternConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html#cfn-elasticloadbalancingv2-listenerrule-pathpatternconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link PathPatternConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PathPatternConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> values;

            /**
             * Sets the value of Values
             * @param values `CfnListenerRule.PathPatternConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PathPatternConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PathPatternConfigProperty build() {
                return new Jsii$Proxy(values);
            }
        }

        /**
         * An implementation for {@link PathPatternConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PathPatternConfigProperty {
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.values = this.jsiiGet("values", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> values) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = values;
            }

            @Override
            public java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getValues() != null) {
                    obj.set("values", om.valueToTree(this.getValues()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PathPatternConfigProperty.Jsii$Proxy that = (PathPatternConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface QueryStringConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.QueryStringConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html#cfn-elasticloadbalancingv2-listenerrule-querystringconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getValues();

        /**
         * @return a {@link Builder} of {@link QueryStringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryStringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object values;

            /**
             * Sets the value of Values
             * @param values `CfnListenerRule.QueryStringConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(software.amazon.awscdk.core.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of Values
             * @param values `CfnListenerRule.QueryStringConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(java.util.List<java.lang.Object> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public QueryStringConfigProperty build() {
                return new Jsii$Proxy(values);
            }
        }

        /**
         * An implementation for {@link QueryStringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringConfigProperty {
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.values = this.jsiiGet("values", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object values) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = values;
            }

            @Override
            public java.lang.Object getValues() {
                return this.values;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getValues() != null) {
                    obj.set("values", om.valueToTree(this.getValues()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryStringConfigProperty.Jsii$Proxy that = (QueryStringConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface QueryStringKeyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.QueryStringKeyValueProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnListenerRule.QueryStringKeyValueProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link QueryStringKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryStringKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String key;
            private java.lang.String value;

            /**
             * Sets the value of Key
             * @param key `CfnListenerRule.QueryStringKeyValueProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnListenerRule.QueryStringKeyValueProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringKeyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public QueryStringKeyValueProperty build() {
                return new Jsii$Proxy(key, value);
            }
        }

        /**
         * An implementation for {@link QueryStringKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringKeyValueProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String key, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = key;
                this.value = value;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getKey() != null) {
                    obj.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    obj.set("value", om.valueToTree(this.getValue()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryStringKeyValueProperty.Jsii$Proxy that = (QueryStringKeyValueProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RedirectConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.RedirectConfigProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatusCode();

        /**
         * `CfnListenerRule.RedirectConfigProperty.Host`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-host
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHost();

        /**
         * `CfnListenerRule.RedirectConfigProperty.Path`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-path
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPath();

        /**
         * `CfnListenerRule.RedirectConfigProperty.Port`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-port
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPort();

        /**
         * `CfnListenerRule.RedirectConfigProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getProtocol();

        /**
         * `CfnListenerRule.RedirectConfigProperty.Query`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-query
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getQuery();

        /**
         * @return a {@link Builder} of {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String statusCode;
            private java.lang.String host;
            private java.lang.String path;
            private java.lang.String port;
            private java.lang.String protocol;
            private java.lang.String query;

            /**
             * Sets the value of StatusCode
             * @param statusCode `CfnListenerRule.RedirectConfigProperty.StatusCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of Host
             * @param host `CfnListenerRule.RedirectConfigProperty.Host`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of Path
             * @param path `CfnListenerRule.RedirectConfigProperty.Path`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of Port
             * @param port `CfnListenerRule.RedirectConfigProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of Protocol
             * @param protocol `CfnListenerRule.RedirectConfigProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of Query
             * @param query `CfnListenerRule.RedirectConfigProperty.Query`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder query(java.lang.String query) {
                this.query = query;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RedirectConfigProperty build() {
                return new Jsii$Proxy(statusCode, host, path, port, protocol, query);
            }
        }

        /**
         * An implementation for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectConfigProperty {
            private final java.lang.String statusCode;
            private final java.lang.String host;
            private final java.lang.String path;
            private final java.lang.String port;
            private final java.lang.String protocol;
            private final java.lang.String query;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
                this.host = this.jsiiGet("host", java.lang.String.class);
                this.path = this.jsiiGet("path", java.lang.String.class);
                this.port = this.jsiiGet("port", java.lang.String.class);
                this.protocol = this.jsiiGet("protocol", java.lang.String.class);
                this.query = this.jsiiGet("query", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String statusCode, java.lang.String host, java.lang.String path, java.lang.String port, java.lang.String protocol, java.lang.String query) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
                this.host = host;
                this.path = path;
                this.port = port;
                this.protocol = protocol;
                this.query = query;
            }

            @Override
            public java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public java.lang.String getHost() {
                return this.host;
            }

            @Override
            public java.lang.String getPath() {
                return this.path;
            }

            @Override
            public java.lang.String getPort() {
                return this.port;
            }

            @Override
            public java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public java.lang.String getQuery() {
                return this.query;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getHost() != null) {
                    obj.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getPath() != null) {
                    obj.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPort() != null) {
                    obj.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getProtocol() != null) {
                    obj.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getQuery() != null) {
                    obj.set("query", om.valueToTree(this.getQuery()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectConfigProperty.Jsii$Proxy that = (RedirectConfigProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                return this.query != null ? this.query.equals(that.query) : that.query == null;
            }

            @Override
            public int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RuleConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.RuleConditionProperty.Field`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getField();

        /**
         * `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-hostheaderconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getHostHeaderConfig();

        /**
         * `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httpheaderconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getHttpHeaderConfig();

        /**
         * `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httprequestmethodconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getHttpRequestMethodConfig();

        /**
         * `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-pathpatternconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPathPatternConfig();

        /**
         * `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-querystringconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getQueryStringConfig();

        /**
         * `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-sourceipconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSourceIpConfig();

        /**
         * `CfnListenerRule.RuleConditionProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String field;
            private java.lang.Object hostHeaderConfig;
            private java.lang.Object httpHeaderConfig;
            private java.lang.Object httpRequestMethodConfig;
            private java.lang.Object pathPatternConfig;
            private java.lang.Object queryStringConfig;
            private java.lang.Object sourceIpConfig;
            private java.util.List<java.lang.String> values;

            /**
             * Sets the value of Field
             * @param field `CfnListenerRule.RuleConditionProperty.Field`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of HostHeaderConfig
             * @param hostHeaderConfig `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder hostHeaderConfig(software.amazon.awscdk.core.IResolvable hostHeaderConfig) {
                this.hostHeaderConfig = hostHeaderConfig;
                return this;
            }

            /**
             * Sets the value of HostHeaderConfig
             * @param hostHeaderConfig `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder hostHeaderConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HostHeaderConfigProperty hostHeaderConfig) {
                this.hostHeaderConfig = hostHeaderConfig;
                return this;
            }

            /**
             * Sets the value of HttpHeaderConfig
             * @param httpHeaderConfig `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder httpHeaderConfig(software.amazon.awscdk.core.IResolvable httpHeaderConfig) {
                this.httpHeaderConfig = httpHeaderConfig;
                return this;
            }

            /**
             * Sets the value of HttpHeaderConfig
             * @param httpHeaderConfig `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder httpHeaderConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HttpHeaderConfigProperty httpHeaderConfig) {
                this.httpHeaderConfig = httpHeaderConfig;
                return this;
            }

            /**
             * Sets the value of HttpRequestMethodConfig
             * @param httpRequestMethodConfig `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder httpRequestMethodConfig(software.amazon.awscdk.core.IResolvable httpRequestMethodConfig) {
                this.httpRequestMethodConfig = httpRequestMethodConfig;
                return this;
            }

            /**
             * Sets the value of HttpRequestMethodConfig
             * @param httpRequestMethodConfig `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder httpRequestMethodConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HttpRequestMethodConfigProperty httpRequestMethodConfig) {
                this.httpRequestMethodConfig = httpRequestMethodConfig;
                return this;
            }

            /**
             * Sets the value of PathPatternConfig
             * @param pathPatternConfig `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder pathPatternConfig(software.amazon.awscdk.core.IResolvable pathPatternConfig) {
                this.pathPatternConfig = pathPatternConfig;
                return this;
            }

            /**
             * Sets the value of PathPatternConfig
             * @param pathPatternConfig `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder pathPatternConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.PathPatternConfigProperty pathPatternConfig) {
                this.pathPatternConfig = pathPatternConfig;
                return this;
            }

            /**
             * Sets the value of QueryStringConfig
             * @param queryStringConfig `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder queryStringConfig(software.amazon.awscdk.core.IResolvable queryStringConfig) {
                this.queryStringConfig = queryStringConfig;
                return this;
            }

            /**
             * Sets the value of QueryStringConfig
             * @param queryStringConfig `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder queryStringConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.QueryStringConfigProperty queryStringConfig) {
                this.queryStringConfig = queryStringConfig;
                return this;
            }

            /**
             * Sets the value of SourceIpConfig
             * @param sourceIpConfig `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sourceIpConfig(software.amazon.awscdk.core.IResolvable sourceIpConfig) {
                this.sourceIpConfig = sourceIpConfig;
                return this;
            }

            /**
             * Sets the value of SourceIpConfig
             * @param sourceIpConfig `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sourceIpConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.SourceIpConfigProperty sourceIpConfig) {
                this.sourceIpConfig = sourceIpConfig;
                return this;
            }

            /**
             * Sets the value of Values
             * @param values `CfnListenerRule.RuleConditionProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RuleConditionProperty build() {
                return new Jsii$Proxy(field, hostHeaderConfig, httpHeaderConfig, httpRequestMethodConfig, pathPatternConfig, queryStringConfig, sourceIpConfig, values);
            }
        }

        /**
         * An implementation for {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleConditionProperty {
            private final java.lang.String field;
            private final java.lang.Object hostHeaderConfig;
            private final java.lang.Object httpHeaderConfig;
            private final java.lang.Object httpRequestMethodConfig;
            private final java.lang.Object pathPatternConfig;
            private final java.lang.Object queryStringConfig;
            private final java.lang.Object sourceIpConfig;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.field = this.jsiiGet("field", java.lang.String.class);
                this.hostHeaderConfig = this.jsiiGet("hostHeaderConfig", java.lang.Object.class);
                this.httpHeaderConfig = this.jsiiGet("httpHeaderConfig", java.lang.Object.class);
                this.httpRequestMethodConfig = this.jsiiGet("httpRequestMethodConfig", java.lang.Object.class);
                this.pathPatternConfig = this.jsiiGet("pathPatternConfig", java.lang.Object.class);
                this.queryStringConfig = this.jsiiGet("queryStringConfig", java.lang.Object.class);
                this.sourceIpConfig = this.jsiiGet("sourceIpConfig", java.lang.Object.class);
                this.values = this.jsiiGet("values", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String field, java.lang.Object hostHeaderConfig, java.lang.Object httpHeaderConfig, java.lang.Object httpRequestMethodConfig, java.lang.Object pathPatternConfig, java.lang.Object queryStringConfig, java.lang.Object sourceIpConfig, java.util.List<java.lang.String> values) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = field;
                this.hostHeaderConfig = hostHeaderConfig;
                this.httpHeaderConfig = httpHeaderConfig;
                this.httpRequestMethodConfig = httpRequestMethodConfig;
                this.pathPatternConfig = pathPatternConfig;
                this.queryStringConfig = queryStringConfig;
                this.sourceIpConfig = sourceIpConfig;
                this.values = values;
            }

            @Override
            public java.lang.String getField() {
                return this.field;
            }

            @Override
            public java.lang.Object getHostHeaderConfig() {
                return this.hostHeaderConfig;
            }

            @Override
            public java.lang.Object getHttpHeaderConfig() {
                return this.httpHeaderConfig;
            }

            @Override
            public java.lang.Object getHttpRequestMethodConfig() {
                return this.httpRequestMethodConfig;
            }

            @Override
            public java.lang.Object getPathPatternConfig() {
                return this.pathPatternConfig;
            }

            @Override
            public java.lang.Object getQueryStringConfig() {
                return this.queryStringConfig;
            }

            @Override
            public java.lang.Object getSourceIpConfig() {
                return this.sourceIpConfig;
            }

            @Override
            public java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getField() != null) {
                    obj.set("field", om.valueToTree(this.getField()));
                }
                if (this.getHostHeaderConfig() != null) {
                    obj.set("hostHeaderConfig", om.valueToTree(this.getHostHeaderConfig()));
                }
                if (this.getHttpHeaderConfig() != null) {
                    obj.set("httpHeaderConfig", om.valueToTree(this.getHttpHeaderConfig()));
                }
                if (this.getHttpRequestMethodConfig() != null) {
                    obj.set("httpRequestMethodConfig", om.valueToTree(this.getHttpRequestMethodConfig()));
                }
                if (this.getPathPatternConfig() != null) {
                    obj.set("pathPatternConfig", om.valueToTree(this.getPathPatternConfig()));
                }
                if (this.getQueryStringConfig() != null) {
                    obj.set("queryStringConfig", om.valueToTree(this.getQueryStringConfig()));
                }
                if (this.getSourceIpConfig() != null) {
                    obj.set("sourceIpConfig", om.valueToTree(this.getSourceIpConfig()));
                }
                if (this.getValues() != null) {
                    obj.set("values", om.valueToTree(this.getValues()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleConditionProperty.Jsii$Proxy that = (RuleConditionProperty.Jsii$Proxy) o;

                if (this.field != null ? !this.field.equals(that.field) : that.field != null) return false;
                if (this.hostHeaderConfig != null ? !this.hostHeaderConfig.equals(that.hostHeaderConfig) : that.hostHeaderConfig != null) return false;
                if (this.httpHeaderConfig != null ? !this.httpHeaderConfig.equals(that.httpHeaderConfig) : that.httpHeaderConfig != null) return false;
                if (this.httpRequestMethodConfig != null ? !this.httpRequestMethodConfig.equals(that.httpRequestMethodConfig) : that.httpRequestMethodConfig != null) return false;
                if (this.pathPatternConfig != null ? !this.pathPatternConfig.equals(that.pathPatternConfig) : that.pathPatternConfig != null) return false;
                if (this.queryStringConfig != null ? !this.queryStringConfig.equals(that.queryStringConfig) : that.queryStringConfig != null) return false;
                if (this.sourceIpConfig != null ? !this.sourceIpConfig.equals(that.sourceIpConfig) : that.sourceIpConfig != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public int hashCode() {
                int result = this.field != null ? this.field.hashCode() : 0;
                result = 31 * result + (this.hostHeaderConfig != null ? this.hostHeaderConfig.hashCode() : 0);
                result = 31 * result + (this.httpHeaderConfig != null ? this.httpHeaderConfig.hashCode() : 0);
                result = 31 * result + (this.httpRequestMethodConfig != null ? this.httpRequestMethodConfig.hashCode() : 0);
                result = 31 * result + (this.pathPatternConfig != null ? this.pathPatternConfig.hashCode() : 0);
                result = 31 * result + (this.queryStringConfig != null ? this.queryStringConfig.hashCode() : 0);
                result = 31 * result + (this.sourceIpConfig != null ? this.sourceIpConfig.hashCode() : 0);
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SourceIpConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListenerRule.SourceIpConfigProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html#cfn-elasticloadbalancingv2-listenerrule-sourceipconfig-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link SourceIpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceIpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> values;

            /**
             * Sets the value of Values
             * @param values `CfnListenerRule.SourceIpConfigProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceIpConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SourceIpConfigProperty build() {
                return new Jsii$Proxy(values);
            }
        }

        /**
         * An implementation for {@link SourceIpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceIpConfigProperty {
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.values = this.jsiiGet("values", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> values) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = values;
            }

            @Override
            public java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getValues() != null) {
                    obj.set("values", om.valueToTree(this.getValues()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceIpConfigProperty.Jsii$Proxy that = (SourceIpConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
}
