package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Result of attaching a target to load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:34:48.716Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * What kind of target this is.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType();

    /**
     * JSON representing the target's direct addition to the TargetGroup list.
     * 
     * May be omitted if the target is going to register itself later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Object getTargetJson();

    /**
     * @return a {@link Builder} of {@link LoadBalancerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private java.lang.Object targetJson;

        /**
         * Sets the value of TargetType
         * @param targetType What kind of target this is. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of TargetJson
         * @param targetJson JSON representing the target's direct addition to the TargetGroup list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetJson(java.lang.Object targetJson) {
            this.targetJson = targetJson;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LoadBalancerTargetProps build() {
            return new Jsii$Proxy(targetType, targetJson);
        }
    }

    /**
     * An implementation for {@link LoadBalancerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerTargetProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private final java.lang.Object targetJson;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.targetType = this.jsiiGet("targetType", software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class);
            this.targetJson = this.jsiiGet("targetJson", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType, java.lang.Object targetJson) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetType = java.util.Objects.requireNonNull(targetType, "targetType is required");
            this.targetJson = targetJson;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.targetType;
        }

        @Override
        public java.lang.Object getTargetJson() {
            return this.targetJson;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("targetType", om.valueToTree(this.getTargetType()));
            if (this.getTargetJson() != null) {
                obj.set("targetJson", om.valueToTree(this.getTargetJson()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerTargetProps.Jsii$Proxy that = (LoadBalancerTargetProps.Jsii$Proxy) o;

            if (!targetType.equals(that.targetType)) return false;
            return this.targetJson != null ? this.targetJson.equals(that.targetJson) : that.targetJson == null;
        }

        @Override
        public int hashCode() {
            int result = this.targetType.hashCode();
            result = 31 * result + (this.targetJson != null ? this.targetJson.hashCode() : 0);
            return result;
        }
    }
}
