package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define the target of a load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:34:48.721Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.TargetGroupBase")
public abstract class TargetGroupBase extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup {

    protected TargetGroupBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TargetGroupBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param baseProps This parameter is required.
     * @param additionalProps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TargetGroupBase(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps baseProps, final java.lang.Object additionalProps) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(baseProps, "baseProps is required"), additionalProps }));
    }

    /**
     * Register the given load balancing target as part of this group.
     * 
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addLoadBalancerTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps props) {
        this.jsiiCall("addLoadBalancerTarget", Void.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Set/replace the target group's health check.
     * 
     * @param healthCheck This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void configureHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
        this.jsiiCall("configureHealthCheck", Void.class, new Object[] { java.util.Objects.requireNonNull(healthCheck, "healthCheck is required") });
    }

    /**
     * Set a non-standard attribute on the target group.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     * @param key This parameter is required.
     * @param value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttribute(final java.lang.String key, final java.lang.String value) {
        this.jsiiCall("setAttribute", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Set a non-standard attribute on the target group.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttribute(final java.lang.String key) {
        this.jsiiCall("setAttribute", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * Default port configured for members of this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Number getDefaultPort() {
        return this.jsiiGet("defaultPort", java.lang.Number.class);
    }

    /**
     * Full name of first load balancer.
     * 
     * This identifier is emitted as a dimensions of the metrics of this target
     * group.
     * 
     * Example:
     * 
     * app/my-load-balancer/123456789
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFirstLoadBalancerFullName() {
        return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
    }

    /**
     * A token representing a list of ARNs of the load balancers that route traffic to this target group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getLoadBalancerArns() {
        return this.jsiiGet("loadBalancerArns", java.lang.String.class);
    }

    /**
     * List of constructs that need to be depended on to ensure the TargetGroup is associated to a load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.IDependable getLoadBalancerAttached() {
        return this.jsiiGet("loadBalancerAttached", software.amazon.awscdk.core.IDependable.class);
    }

    /**
     * Configurable dependable with all resources that lead to load balancer attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected software.amazon.awscdk.core.ConcreteDependable getLoadBalancerAttachedDependencies() {
        return this.jsiiGet("loadBalancerAttachedDependencies", software.amazon.awscdk.core.ConcreteDependable.class);
    }

    /**
     * The ARN of the target group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getTargetGroupArn() {
        return this.jsiiGet("targetGroupArn", java.lang.String.class);
    }

    /**
     * The full name of the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getTargetGroupFullName() {
        return this.jsiiGet("targetGroupFullName", java.lang.String.class);
    }

    /**
     * ARNs of load balancers load balancing to this TargetGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getTargetGroupLoadBalancerArns() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("targetGroupLoadBalancerArns", java.util.List.class));
    }

    /**
     * The name of the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getTargetGroupName() {
        return this.jsiiGet("targetGroupName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
        return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
        this.jsiiSet("healthCheck", java.util.Objects.requireNonNull(value, "healthCheck is required"));
    }

    /**
     * The types of the directly registered members of this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
        return this.jsiiGet("targetType", software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class);
    }

    /**
     * The types of the directly registered members of this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setTargetType(final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
        this.jsiiSet("targetType", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
        }

        /**
         * Full name of first load balancer.
         * 
         * This identifier is emitted as a dimensions of the metrics of this target
         * group.
         * 
         * Example:
         * 
         * app/my-load-balancer/123456789
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getFirstLoadBalancerFullName() {
            return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
        }

        /**
         * A token representing a list of ARNs of the load balancers that route traffic to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getLoadBalancerArns() {
            return this.jsiiGet("loadBalancerArns", java.lang.String.class);
        }

        /**
         * Return an object to depend on the listeners added to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.IDependable getLoadBalancerAttached() {
            return this.jsiiGet("loadBalancerAttached", software.amazon.awscdk.core.IDependable.class);
        }

        /**
         * ARN of the target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getTargetGroupArn() {
            return this.jsiiGet("targetGroupArn", java.lang.String.class);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }
    }
}
