/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.jsii.JsiiSerializable;

public interface AddApplicationTargetsProps
extends JsiiSerializable,
AddRuleProps {
    public Duration getDeregistrationDelay();

    public HealthCheck getHealthCheck();

    public Number getPort();

    public ApplicationProtocol getProtocol();

    public Duration getSlowStart();

    public Duration getStickinessCookieDuration();

    public String getTargetGroupName();

    public List<IApplicationLoadBalancerTarget> getTargets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration deregistrationDelay;
        private HealthCheck healthCheck;
        private Number port;
        private ApplicationProtocol protocol;
        private Duration slowStart;
        private Duration stickinessCookieDuration;
        private String targetGroupName;
        private List<IApplicationLoadBalancerTarget> targets;
        private String hostHeader;
        private String pathPattern;
        private Number priority;

        public Builder deregistrationDelay(Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder slowStart(Duration slowStart) {
            this.slowStart = slowStart;
            return this;
        }

        public Builder stickinessCookieDuration(Duration stickinessCookieDuration) {
            this.stickinessCookieDuration = stickinessCookieDuration;
            return this;
        }

        public Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public Builder targets(List<IApplicationLoadBalancerTarget> targets) {
            this.targets = targets;
            return this;
        }

        public Builder hostHeader(String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        public Builder pathPattern(String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        public Builder priority(Number priority) {
            this.priority = priority;
            return this;
        }

        public AddApplicationTargetsProps build() {
            return new Jsii.Proxy(this.deregistrationDelay, this.healthCheck, this.port, this.protocol, this.slowStart, this.stickinessCookieDuration, this.targetGroupName, this.targets, this.hostHeader, this.pathPattern, this.priority, null);
        }
    }
}

