/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.jsii.JsiiSerializable;

public interface ApplicationListenerProps
extends JsiiSerializable,
BaseApplicationListenerProps {
    public IApplicationLoadBalancer getLoadBalancer();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IApplicationLoadBalancer loadBalancer;
        private List<String> certificateArns;
        private List<IApplicationTargetGroup> defaultTargetGroups;
        private Boolean open;
        private Number port;
        private ApplicationProtocol protocol;
        private SslPolicy sslPolicy;

        public Builder loadBalancer(IApplicationLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public Builder certificateArns(List<String> certificateArns) {
            this.certificateArns = certificateArns;
            return this;
        }

        public Builder defaultTargetGroups(List<IApplicationTargetGroup> defaultTargetGroups) {
            this.defaultTargetGroups = defaultTargetGroups;
            return this;
        }

        public Builder open(Boolean open) {
            this.open = open;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder sslPolicy(SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public ApplicationListenerProps build() {
            return new Jsii.Proxy(this.loadBalancer, this.certificateArns, this.defaultTargetGroups, this.open, this.port, this.protocol, this.sslPolicy, null);
        }
    }
}

