package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding new targets to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T20:00:10.368Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddApplicationTargetsProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps {

    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0-3600 seconds.
     * 
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getDeregistrationDelay();

    /**
     * Health check configuration.
     * 
     * Default: No health check
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck();

    /**
     * The port on which the listener listens for requests.
     * 
     * Default: Determined from protocol if known
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();

    /**
     * The protocol to use.
     * 
     * Default: Determined from port if known
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol();

    /**
     * The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
     * 
     * The range is 30-900 seconds (15 minutes).
     * 
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getSlowStart();

    /**
     * The stickiness cookie expiration period.
     * 
     * Setting this value enables load balancer stickiness.
     * 
     * After this period, the cookie is considered stale. The minimum value is
     * 1 second and the maximum value is 7 days (604800 seconds).
     * 
     * Default: Duration.days(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getStickinessCookieDuration();

    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * 
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTargetGroupName();

    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. All target must be of the same type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets();

    /**
     * @return a {@link Builder} of {@link AddApplicationTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddApplicationTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.core.Duration deregistrationDelay;
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private java.lang.Number port;
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private software.amazon.awscdk.core.Duration slowStart;
        private software.amazon.awscdk.core.Duration stickinessCookieDuration;
        private java.lang.String targetGroupName;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets;
        private java.lang.String hostHeader;
        private java.lang.String pathPattern;
        private java.lang.Number priority;

        /**
         * Sets the value of DeregistrationDelay
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(software.amazon.awscdk.core.Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        /**
         * Sets the value of HealthCheck
         * @param healthCheck Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of Port
         * @param port The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of Protocol
         * @param protocol The protocol to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of SlowStart
         * @param slowStart The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slowStart(software.amazon.awscdk.core.Duration slowStart) {
            this.slowStart = slowStart;
            return this;
        }

        /**
         * Sets the value of StickinessCookieDuration
         * @param stickinessCookieDuration The stickiness cookie expiration period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stickinessCookieDuration(software.amazon.awscdk.core.Duration stickinessCookieDuration) {
            this.stickinessCookieDuration = stickinessCookieDuration;
            return this;
        }

        /**
         * Sets the value of TargetGroupName
         * @param targetGroupName The name of the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(java.lang.String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        /**
         * Sets the value of Targets
         * @param targets The targets to add to this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of HostHeader
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of PathPattern
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of Priority
         * @param priority Priority of this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddApplicationTargetsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AddApplicationTargetsProps build() {
            return new Jsii$Proxy(deregistrationDelay, healthCheck, port, protocol, slowStart, stickinessCookieDuration, targetGroupName, targets, hostHeader, pathPattern, priority);
        }
    }

    /**
     * An implementation for {@link AddApplicationTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddApplicationTargetsProps {
        private final software.amazon.awscdk.core.Duration deregistrationDelay;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private final software.amazon.awscdk.core.Duration slowStart;
        private final software.amazon.awscdk.core.Duration stickinessCookieDuration;
        private final java.lang.String targetGroupName;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets;
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.deregistrationDelay = this.jsiiGet("deregistrationDelay", software.amazon.awscdk.core.Duration.class);
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
            this.port = this.jsiiGet("port", java.lang.Number.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
            this.slowStart = this.jsiiGet("slowStart", software.amazon.awscdk.core.Duration.class);
            this.stickinessCookieDuration = this.jsiiGet("stickinessCookieDuration", software.amazon.awscdk.core.Duration.class);
            this.targetGroupName = this.jsiiGet("targetGroupName", java.lang.String.class);
            this.targets = this.jsiiGet("targets", java.util.List.class);
            this.hostHeader = this.jsiiGet("hostHeader", java.lang.String.class);
            this.pathPattern = this.jsiiGet("pathPattern", java.lang.String.class);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.core.Duration deregistrationDelay, software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck, java.lang.Number port, software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol, software.amazon.awscdk.core.Duration slowStart, software.amazon.awscdk.core.Duration stickinessCookieDuration, java.lang.String targetGroupName, java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets, java.lang.String hostHeader, java.lang.String pathPattern, java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deregistrationDelay = deregistrationDelay;
            this.healthCheck = healthCheck;
            this.port = port;
            this.protocol = protocol;
            this.slowStart = slowStart;
            this.stickinessCookieDuration = stickinessCookieDuration;
            this.targetGroupName = targetGroupName;
            this.targets = targets;
            this.hostHeader = hostHeader;
            this.pathPattern = pathPattern;
            this.priority = priority;
        }

        @Override
        public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.deregistrationDelay;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public software.amazon.awscdk.core.Duration getSlowStart() {
            return this.slowStart;
        }

        @Override
        public software.amazon.awscdk.core.Duration getStickinessCookieDuration() {
            return this.stickinessCookieDuration;
        }

        @Override
        public java.lang.String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
            return this.targets;
        }

        @Override
        public java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getDeregistrationDelay() != null) {
                obj.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
            }
            if (this.getHealthCheck() != null) {
                obj.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getPort() != null) {
                obj.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                obj.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSlowStart() != null) {
                obj.set("slowStart", om.valueToTree(this.getSlowStart()));
            }
            if (this.getStickinessCookieDuration() != null) {
                obj.set("stickinessCookieDuration", om.valueToTree(this.getStickinessCookieDuration()));
            }
            if (this.getTargetGroupName() != null) {
                obj.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
            }
            if (this.getTargets() != null) {
                obj.set("targets", om.valueToTree(this.getTargets()));
            }
            if (this.getHostHeader() != null) {
                obj.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                obj.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getPriority() != null) {
                obj.set("priority", om.valueToTree(this.getPriority()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddApplicationTargetsProps.Jsii$Proxy that = (AddApplicationTargetsProps.Jsii$Proxy) o;

            if (this.deregistrationDelay != null ? !this.deregistrationDelay.equals(that.deregistrationDelay) : that.deregistrationDelay != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.slowStart != null ? !this.slowStart.equals(that.slowStart) : that.slowStart != null) return false;
            if (this.stickinessCookieDuration != null ? !this.stickinessCookieDuration.equals(that.stickinessCookieDuration) : that.stickinessCookieDuration != null) return false;
            if (this.targetGroupName != null ? !this.targetGroupName.equals(that.targetGroupName) : that.targetGroupName != null) return false;
            if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) return false;
            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public int hashCode() {
            int result = this.deregistrationDelay != null ? this.deregistrationDelay.hashCode() : 0;
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.slowStart != null ? this.slowStart.hashCode() : 0);
            result = 31 * result + (this.stickinessCookieDuration != null ? this.stickinessCookieDuration.hashCode() : 0);
            result = 31 * result + (this.targetGroupName != null ? this.targetGroupName.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            result = 31 * result + (this.hostHeader != null ? this.hostHeader.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
