package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for an ApplicationListener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T20:00:10.384Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseApplicationListenerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The certificates to use on this listener.
     * 
     * Default: - No certificates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getCertificateArns();

    /**
     * Default target groups to load balance to.
     * 
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups();

    /**
     * Allow anyone to connect to this listener.
     * 
     * If this is specified, the listener will be opened up to anyone who can reach it.
     * For internal load balancers this is anyone in the same VPC. For public load
     * balancers, this is anyone on the internet.
     * 
     * If you want to be more selective about who can access this load
     * balancer, set this to `false` and use the listener's `connections`
     * object to selectively grant access to the listener.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getOpen();

    /**
     * The port on which the listener listens for requests.
     * 
     * Default: - Determined from protocol if known.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();

    /**
     * The protocol to use.
     * 
     * Default: - Determined from port if known.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol();

    /**
     * The security policy that defines which ciphers and protocols are supported.
     * 
     * Default: - The current predefined security policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy();

    /**
     * @return a {@link Builder} of {@link BaseApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<java.lang.String> certificateArns;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups;
        private java.lang.Boolean open;
        private java.lang.Number port;
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Sets the value of CertificateArns
         * @param certificateArns The certificates to use on this listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateArns(java.util.List<java.lang.String> certificateArns) {
            this.certificateArns = certificateArns;
            return this;
        }

        /**
         * Sets the value of DefaultTargetGroups
         * @param defaultTargetGroups Default target groups to load balance to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTargetGroups(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups) {
            this.defaultTargetGroups = defaultTargetGroups;
            return this;
        }

        /**
         * Sets the value of Open
         * @param open Allow anyone to connect to this listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(java.lang.Boolean open) {
            this.open = open;
            return this;
        }

        /**
         * Sets the value of Port
         * @param port The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of Protocol
         * @param protocol The protocol to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of SslPolicy
         * @param sslPolicy The security policy that defines which ciphers and protocols are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseApplicationListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BaseApplicationListenerProps build() {
            return new Jsii$Proxy(certificateArns, defaultTargetGroups, open, port, protocol, sslPolicy);
        }
    }

    /**
     * An implementation for {@link BaseApplicationListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseApplicationListenerProps {
        private final java.util.List<java.lang.String> certificateArns;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups;
        private final java.lang.Boolean open;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.certificateArns = this.jsiiGet("certificateArns", java.util.List.class);
            this.defaultTargetGroups = this.jsiiGet("defaultTargetGroups", java.util.List.class);
            this.open = this.jsiiGet("open", java.lang.Boolean.class);
            this.port = this.jsiiGet("port", java.lang.Number.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
            this.sslPolicy = this.jsiiGet("sslPolicy", software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<java.lang.String> certificateArns, java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups, java.lang.Boolean open, java.lang.Number port, software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol, software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateArns = certificateArns;
            this.defaultTargetGroups = defaultTargetGroups;
            this.open = open;
            this.port = port;
            this.protocol = protocol;
            this.sslPolicy = sslPolicy;
        }

        @Override
        public java.util.List<java.lang.String> getCertificateArns() {
            return this.certificateArns;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups() {
            return this.defaultTargetGroups;
        }

        @Override
        public java.lang.Boolean getOpen() {
            return this.open;
        }

        @Override
        public java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getCertificateArns() != null) {
                obj.set("certificateArns", om.valueToTree(this.getCertificateArns()));
            }
            if (this.getDefaultTargetGroups() != null) {
                obj.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
            }
            if (this.getOpen() != null) {
                obj.set("open", om.valueToTree(this.getOpen()));
            }
            if (this.getPort() != null) {
                obj.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                obj.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSslPolicy() != null) {
                obj.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseApplicationListenerProps.Jsii$Proxy that = (BaseApplicationListenerProps.Jsii$Proxy) o;

            if (this.certificateArns != null ? !this.certificateArns.equals(that.certificateArns) : that.certificateArns != null) return false;
            if (this.defaultTargetGroups != null ? !this.defaultTargetGroups.equals(that.defaultTargetGroups) : that.defaultTargetGroups != null) return false;
            if (this.open != null ? !this.open.equals(that.open) : that.open != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.sslPolicy != null ? this.sslPolicy.equals(that.sslPolicy) : that.sslPolicy == null;
        }

        @Override
        public int hashCode() {
            int result = this.certificateArns != null ? this.certificateArns.hashCode() : 0;
            result = 31 * result + (this.defaultTargetGroups != null ? this.defaultTargetGroups.hashCode() : 0);
            result = 31 * result + (this.open != null ? this.open.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.sslPolicy != null ? this.sslPolicy.hashCode() : 0);
            return result;
        }
    }
}
