package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for a Network Listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.42.0 (build 5f6b62c)", date = "2021-11-09T12:18:28.599Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.BaseNetworkListenerProps")
@software.amazon.jsii.Jsii.Proxy(BaseNetworkListenerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseNetworkListenerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The port on which the listener listens for requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPort();

    /**
     * Application-Layer Protocol Negotiation (ALPN) is a TLS extension that is sent on the initial TLS handshake hello messages.
     * <p>
     * ALPN enables the application layer to negotiate which protocols should be used over a secure connection, such as HTTP/1 and HTTP/2.
     * <p>
     * Can only be specified together with Protocol TLS.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy getAlpnPolicy() {
        return null;
    }

    /**
     * Certificate list of ACM cert ARNs.
     * <p>
     * You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
     * <p>
     * Default: - No certificates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> getCertificates() {
        return null;
    }

    /**
     * Default action to take for requests to this listener.
     * <p>
     * This allows full control of the default Action of the load balancer,
     * including weighted forwarding. See the <code>NetworkListenerAction</code> class for
     * all options.
     * <p>
     * Cannot be specified together with <code>defaultTargetGroups</code>.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction getDefaultAction() {
        return null;
    }

    /**
     * Default target groups to load balance to.
     * <p>
     * All target groups will be load balanced to with equal weight and without
     * stickiness. For a more complex configuration than that, use
     * either <code>defaultAction</code> or <code>addAction()</code>.
     * <p>
     * Cannot be specified together with <code>defaultAction</code>.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
        return null;
    }

    /**
     * Protocol for listener, expects TCP, TLS, UDP, or TCP_UDP.
     * <p>
     * Default: - TLS if certificates are provided. TCP otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
        return null;
    }

    /**
     * SSL Policy.
     * <p>
     * Default: - Current predefined security policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseNetworkListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseNetworkListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseNetworkListenerProps> {
        private java.lang.Number port;
        private software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy alpnPolicy;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates;
        private software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction defaultAction;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups;
        private software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol;
        private software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Sets the value of {@link BaseNetworkListenerProps#getPort}
         * @param port The port on which the listener listens for requests. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link BaseNetworkListenerProps#getAlpnPolicy}
         * @param alpnPolicy Application-Layer Protocol Negotiation (ALPN) is a TLS extension that is sent on the initial TLS handshake hello messages.
         *                   ALPN enables the application layer to negotiate which protocols should be used over a secure connection, such as HTTP/1 and HTTP/2.
         *                   <p>
         *                   Can only be specified together with Protocol TLS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alpnPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy alpnPolicy) {
            this.alpnPolicy = alpnPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BaseNetworkListenerProps#getCertificates}
         * @param certificates Certificate list of ACM cert ARNs.
         *                     You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder certificates(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
            this.certificates = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate>)certificates;
            return this;
        }

        /**
         * Sets the value of {@link BaseNetworkListenerProps#getDefaultAction}
         * @param defaultAction Default action to take for requests to this listener.
         *                      This allows full control of the default Action of the load balancer,
         *                      including weighted forwarding. See the <code>NetworkListenerAction</code> class for
         *                      all options.
         *                      <p>
         *                      Cannot be specified together with <code>defaultTargetGroups</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        /**
         * Sets the value of {@link BaseNetworkListenerProps#getDefaultTargetGroups}
         * @param defaultTargetGroups Default target groups to load balance to.
         *                            All target groups will be load balanced to with equal weight and without
         *                            stickiness. For a more complex configuration than that, use
         *                            either <code>defaultAction</code> or <code>addAction()</code>.
         *                            <p>
         *                            Cannot be specified together with <code>defaultAction</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder defaultTargetGroups(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups) {
            this.defaultTargetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup>)defaultTargetGroups;
            return this;
        }

        /**
         * Sets the value of {@link BaseNetworkListenerProps#getProtocol}
         * @param protocol Protocol for listener, expects TCP, TLS, UDP, or TCP_UDP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link BaseNetworkListenerProps#getSslPolicy}
         * @param sslPolicy SSL Policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseNetworkListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseNetworkListenerProps build() {
            return new Jsii$Proxy(port, alpnPolicy, certificates, defaultAction, defaultTargetGroups, protocol, sslPolicy);
        }
    }

    /**
     * An implementation for {@link BaseNetworkListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseNetworkListenerProps {
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy alpnPolicy;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction defaultAction;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.alpnPolicy = software.amazon.jsii.Kernel.get(this, "alpnPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy.class));
            this.certificates = software.amazon.jsii.Kernel.get(this, "certificates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate.class)));
            this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class));
            this.defaultTargetGroups = software.amazon.jsii.Kernel.get(this, "defaultTargetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup.class)));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol.class));
            this.sslPolicy = software.amazon.jsii.Kernel.get(this, "sslPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.Number port, final software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy alpnPolicy, final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates, final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction defaultAction, final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups, final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol, final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.port = java.util.Objects.requireNonNull(port, "port is required");
            this.alpnPolicy = alpnPolicy;
            this.certificates = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate>)certificates;
            this.defaultAction = defaultAction;
            this.defaultTargetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup>)defaultTargetGroups;
            this.protocol = protocol;
            this.sslPolicy = sslPolicy;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy getAlpnPolicy() {
            return this.alpnPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> getCertificates() {
            return this.certificates;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction getDefaultAction() {
            return this.defaultAction;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
            return this.defaultTargetGroups;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("port", om.valueToTree(this.getPort()));
            if (this.getAlpnPolicy() != null) {
                data.set("alpnPolicy", om.valueToTree(this.getAlpnPolicy()));
            }
            if (this.getCertificates() != null) {
                data.set("certificates", om.valueToTree(this.getCertificates()));
            }
            if (this.getDefaultAction() != null) {
                data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
            }
            if (this.getDefaultTargetGroups() != null) {
                data.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSslPolicy() != null) {
                data.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.BaseNetworkListenerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseNetworkListenerProps.Jsii$Proxy that = (BaseNetworkListenerProps.Jsii$Proxy) o;

            if (!port.equals(that.port)) return false;
            if (this.alpnPolicy != null ? !this.alpnPolicy.equals(that.alpnPolicy) : that.alpnPolicy != null) return false;
            if (this.certificates != null ? !this.certificates.equals(that.certificates) : that.certificates != null) return false;
            if (this.defaultAction != null ? !this.defaultAction.equals(that.defaultAction) : that.defaultAction != null) return false;
            if (this.defaultTargetGroups != null ? !this.defaultTargetGroups.equals(that.defaultTargetGroups) : that.defaultTargetGroups != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.sslPolicy != null ? this.sslPolicy.equals(that.sslPolicy) : that.sslPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.port.hashCode();
            result = 31 * result + (this.alpnPolicy != null ? this.alpnPolicy.hashCode() : 0);
            result = 31 * result + (this.certificates != null ? this.certificates.hashCode() : 0);
            result = 31 * result + (this.defaultAction != null ? this.defaultAction.hashCode() : 0);
            result = 31 * result + (this.defaultTargetGroups != null ? this.defaultTargetGroups.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.sslPolicy != null ? this.sslPolicy.hashCode() : 0);
            return result;
        }
    }
}
