/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.services.elasticloadbalancingv2.;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkActionProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkTargetsProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerLookupOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.Protocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticloadbalancingv2.NetworkListener")
public class NetworkListener
extends BaseListener
implements INetworkListener {
    protected NetworkListener(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkListener(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkListener(@NotNull Construct scope, @NotNull String id, @NotNull NetworkListenerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static INetworkListener fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull NetworkListenerLookupOptions options) {
        return (INetworkListener)JsiiObject.jsiiStaticCall(NetworkListener.class, (String)"fromLookup", (NativeType)NativeType.forClass(INetworkListener.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public static INetworkListener fromNetworkListenerArn(@NotNull Construct scope, @NotNull String id, @NotNull String networkListenerArn) {
        return (INetworkListener)JsiiObject.jsiiStaticCall(NetworkListener.class, (String)"fromNetworkListenerArn", (NativeType)NativeType.forClass(INetworkListener.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(networkListenerArn, "networkListenerArn is required")});
    }

    public void addAction(@NotNull String _id, @NotNull AddNetworkActionProps props) {
        Kernel.call((Object)this, (String)"addAction", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_id, "_id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addTargetGroups(@NotNull String _id, INetworkTargetGroup ... targetGroups) {
        Kernel.call((Object)this, (String)"addTargetGroups", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(_id, "_id is required")}), Arrays.stream(targetGroups)).toArray(Object[]::new));
    }

    @NotNull
    public NetworkTargetGroup addTargets(@NotNull String id, @NotNull AddNetworkTargetsProps props) {
        return (NetworkTargetGroup)Kernel.call((Object)this, (String)"addTargets", (NativeType)NativeType.forClass(NetworkTargetGroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public INetworkLoadBalancer getLoadBalancer() {
        return (INetworkLoadBalancer)Kernel.get((Object)this, (String)"loadBalancer", (NativeType)NativeType.forClass(INetworkLoadBalancer.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NetworkListener> {
        private final Construct scope;
        private final String id;
        private final NetworkListenerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new NetworkListenerProps.Builder();
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder alpnPolicy(AlpnPolicy alpnPolicy) {
            this.props.alpnPolicy(alpnPolicy);
            return this;
        }

        public Builder certificates(List<? extends IListenerCertificate> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        public Builder defaultAction(NetworkListenerAction defaultAction) {
            this.props.defaultAction(defaultAction);
            return this;
        }

        public Builder defaultTargetGroups(List<? extends INetworkTargetGroup> defaultTargetGroups) {
            this.props.defaultTargetGroups(defaultTargetGroups);
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder sslPolicy(SslPolicy sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        public Builder loadBalancer(INetworkLoadBalancer loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        public NetworkListener build() {
            return new NetworkListener(this.scope, this.id, this.props.build());
        }
    }
}

