package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Backend protocol for network load balancers and health checks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * INetworkListener listener = NetworkListener.fromLookup(this, "ALBListener", NetworkListenerLookupOptions.builder()
 *         .loadBalancerTags(Map.of(
 *                 "Cluster", "MyClusterName"))
 *         .listenerProtocol(Protocol.TCP)
 *         .listenerPort(12345)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.46.0 (build cd08c55)", date = "2021-11-23T14:40:40.799Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.Protocol")
public enum Protocol {
    /**
     * HTTP (ALB health checks and NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     * HTTPS (ALB health checks and NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
    /**
     * TCP (NLB, NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TCP,
    /**
     * Listen to both TCP and UDP on the same port (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TCP_UDP,
    /**
     * TLS (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS,
    /**
     * UDP (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UDP,
}
