package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing target group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * TargetGroupAttributes targetGroupAttributes = TargetGroupAttributes.builder()
 *         .targetGroupArn("targetGroupArn")
 *         // the properties below are optional
 *         .defaultPort("defaultPort")
 *         .loadBalancerArns("loadBalancerArns")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:02.478Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.TargetGroupAttributes")
@software.amazon.jsii.Jsii.Proxy(TargetGroupAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TargetGroupAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (deprecated) Port target group is listening on.
     * <p>
     * @deprecated - This property is unused and the wrong type. No need to use it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultPort() {
        return null;
    }

    /**
     * A Token representing the list of ARNs for the load balancer routing to this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerArns() {
        return null;
    }

    /**
     * ARN of the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupArn();

    /**
     * @return a {@link Builder} of {@link TargetGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TargetGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TargetGroupAttributes> {
        java.lang.String defaultPort;
        java.lang.String loadBalancerArns;
        java.lang.String targetGroupArn;

        /**
         * Sets the value of {@link TargetGroupAttributes#getDefaultPort}
         * @param defaultPort Port target group is listening on.
         * @return {@code this}
         * @deprecated - This property is unused and the wrong type. No need to use it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder defaultPort(java.lang.String defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Sets the value of {@link TargetGroupAttributes#getLoadBalancerArns}
         * @param loadBalancerArns A Token representing the list of ARNs for the load balancer routing to this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArns(java.lang.String loadBalancerArns) {
            this.loadBalancerArns = loadBalancerArns;
            return this;
        }

        /**
         * Sets the value of {@link TargetGroupAttributes#getTargetGroupArn}
         * @param targetGroupArn ARN of the target group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupArn(java.lang.String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetGroupAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TargetGroupAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TargetGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupAttributes {
        private final java.lang.String defaultPort;
        private final java.lang.String loadBalancerArns;
        private final java.lang.String targetGroupArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultPort = software.amazon.jsii.Kernel.get(this, "defaultPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerArns = software.amazon.jsii.Kernel.get(this, "loadBalancerArns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetGroupArn = software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultPort = builder.defaultPort;
            this.loadBalancerArns = builder.loadBalancerArns;
            this.targetGroupArn = java.util.Objects.requireNonNull(builder.targetGroupArn, "targetGroupArn is required");
        }

        @Override
        public final java.lang.String getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public final java.lang.String getLoadBalancerArns() {
            return this.loadBalancerArns;
        }

        @Override
        public final java.lang.String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefaultPort() != null) {
                data.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }
            if (this.getLoadBalancerArns() != null) {
                data.set("loadBalancerArns", om.valueToTree(this.getLoadBalancerArns()));
            }
            data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.TargetGroupAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TargetGroupAttributes.Jsii$Proxy that = (TargetGroupAttributes.Jsii$Proxy) o;

            if (this.defaultPort != null ? !this.defaultPort.equals(that.defaultPort) : that.defaultPort != null) return false;
            if (this.loadBalancerArns != null ? !this.loadBalancerArns.equals(that.loadBalancerArns) : that.loadBalancerArns != null) return false;
            return this.targetGroupArn.equals(that.targetGroupArn);
        }

        @Override
        public final int hashCode() {
            int result = this.defaultPort != null ? this.defaultPort.hashCode() : 0;
            result = 31 * result + (this.loadBalancerArns != null ? this.loadBalancerArns.hashCode() : 0);
            result = 31 * result + (this.targetGroupArn.hashCode());
            return result;
        }
    }
}
