package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnListenerRuleProps cfnListenerRuleProps = CfnListenerRuleProps.builder()
 *         .actions(List.of(ActionProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .authenticateCognitoConfig(AuthenticateCognitoConfigProperty.builder()
 *                         .userPoolArn("userPoolArn")
 *                         .userPoolClientId("userPoolClientId")
 *                         .userPoolDomain("userPoolDomain")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout(123)
 *                         .build())
 *                 .authenticateOidcConfig(AuthenticateOidcConfigProperty.builder()
 *                         .authorizationEndpoint("authorizationEndpoint")
 *                         .clientId("clientId")
 *                         .clientSecret("clientSecret")
 *                         .issuer("issuer")
 *                         .tokenEndpoint("tokenEndpoint")
 *                         .userInfoEndpoint("userInfoEndpoint")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout(123)
 *                         .useExistingClientSecret(false)
 *                         .build())
 *                 .fixedResponseConfig(FixedResponseConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentType("contentType")
 *                         .messageBody("messageBody")
 *                         .build())
 *                 .forwardConfig(ForwardConfigProperty.builder()
 *                         .targetGroups(List.of(TargetGroupTupleProperty.builder()
 *                                 .targetGroupArn("targetGroupArn")
 *                                 .weight(123)
 *                                 .build()))
 *                         .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
 *                                 .durationSeconds(123)
 *                                 .enabled(false)
 *                                 .build())
 *                         .build())
 *                 .order(123)
 *                 .redirectConfig(RedirectConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .host("host")
 *                         .path("path")
 *                         .port("port")
 *                         .protocol("protocol")
 *                         .query("query")
 *                         .build())
 *                 .targetGroupArn("targetGroupArn")
 *                 .build()))
 *         .conditions(List.of(RuleConditionProperty.builder()
 *                 .field("field")
 *                 .hostHeaderConfig(HostHeaderConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .httpHeaderConfig(HttpHeaderConfigProperty.builder()
 *                         .httpHeaderName("httpHeaderName")
 *                         .values(List.of("values"))
 *                         .build())
 *                 .httpRequestMethodConfig(HttpRequestMethodConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .pathPatternConfig(PathPatternConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .queryStringConfig(QueryStringConfigProperty.builder()
 *                         .values(List.of(QueryStringKeyValueProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .sourceIpConfig(SourceIpConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .values(List.of("values"))
 *                 .build()))
 *         .listenerArn("listenerArn")
 *         .priority(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:46.663Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListenerRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnListenerRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnListenerRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActions();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConditions();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getListenerArn();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * @return a {@link Builder} of {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnListenerRuleProps> {
        java.lang.Object actions;
        java.lang.Object conditions;
        java.lang.String listenerArn;
        java.lang.Number priority;

        /**
         * Sets the value of {@link CfnListenerRuleProps#getActions}
         * @param actions `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.core.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getActions}
         * @param actions `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<? extends java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getConditions}
         * @param conditions `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(software.amazon.awscdk.core.IResolvable conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getConditions}
         * @param conditions `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getListenerArn}
         * @param listenerArn `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getPriority}
         * @param priority `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnListenerRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnListenerRuleProps {
        private final java.lang.Object actions;
        private final java.lang.Object conditions;
        private final java.lang.String listenerArn;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.listenerArn = software.amazon.jsii.Kernel.get(this, "listenerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.conditions = java.util.Objects.requireNonNull(builder.conditions, "conditions is required");
            this.listenerArn = java.util.Objects.requireNonNull(builder.listenerArn, "listenerArn is required");
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.Object getConditions() {
            return this.conditions;
        }

        @Override
        public final java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("conditions", om.valueToTree(this.getConditions()));
            data.set("listenerArn", om.valueToTree(this.getListenerArn()));
            data.set("priority", om.valueToTree(this.getPriority()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListenerRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnListenerRuleProps.Jsii$Proxy that = (CfnListenerRuleProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!conditions.equals(that.conditions)) return false;
            if (!listenerArn.equals(that.listenerArn)) return false;
            return this.priority.equals(that.priority);
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.conditions.hashCode());
            result = 31 * result + (this.listenerArn.hashCode());
            result = 31 * result + (this.priority.hashCode());
            return result;
        }
    }
}
