package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Options for `ListenerAction.fixedResponse()`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationListener listener;
 * listener.addAction("Fixed", AddApplicationActionProps.builder()
 *         .priority(10)
 *         .conditions(List.of(ListenerCondition.pathPatterns(List.of("/ok"))))
 *         .action(ListenerAction.fixedResponse(200, FixedResponseOptions.builder()
 *                 .contentType(ContentType.TEXT_PLAIN)
 *                 .messageBody("OK")
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-07T14:33:55.835Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.FixedResponseOptions")
@software.amazon.jsii.Jsii.Proxy(FixedResponseOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FixedResponseOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Content Type of the response.
     * <p>
     * Valid Values: text/plain | text/css | text/html | application/javascript | application/json
     * <p>
     * Default: - Automatically determined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * The response body.
     * <p>
     * Default: - No body
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMessageBody() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FixedResponseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FixedResponseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FixedResponseOptions> {
        java.lang.String contentType;
        java.lang.String messageBody;

        /**
         * Sets the value of {@link FixedResponseOptions#getContentType}
         * @param contentType Content Type of the response.
         *                    Valid Values: text/plain | text/css | text/html | application/javascript | application/json
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link FixedResponseOptions#getMessageBody}
         * @param messageBody The response body.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageBody(java.lang.String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FixedResponseOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FixedResponseOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FixedResponseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FixedResponseOptions {
        private final java.lang.String contentType;
        private final java.lang.String messageBody;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.messageBody = software.amazon.jsii.Kernel.get(this, "messageBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentType = builder.contentType;
            this.messageBody = builder.messageBody;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final java.lang.String getMessageBody() {
            return this.messageBody;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getMessageBody() != null) {
                data.set("messageBody", om.valueToTree(this.getMessageBody()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.FixedResponseOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FixedResponseOptions.Jsii$Proxy that = (FixedResponseOptions.Jsii$Proxy) o;

            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            return this.messageBody != null ? this.messageBody.equals(that.messageBody) : that.messageBody == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contentType != null ? this.contentType.hashCode() : 0;
            result = 31 * result + (this.messageBody != null ? this.messageBody.hashCode() : 0);
            return result;
        }
    }
}
