package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a new action to a listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * NetworkListenerAction networkListenerAction;
 * AddNetworkActionProps addNetworkActionProps = AddNetworkActionProps.builder()
 *         .action(networkListenerAction)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-27T11:48:59.785Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.AddNetworkActionProps")
@software.amazon.jsii.Jsii.Proxy(AddNetworkActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddNetworkActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Action to perform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction getAction();

    /**
     * @return a {@link Builder} of {@link AddNetworkActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddNetworkActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddNetworkActionProps> {
        software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction action;

        /**
         * Sets the value of {@link AddNetworkActionProps#getAction}
         * @param action Action to perform. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction action) {
            this.action = action;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddNetworkActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddNetworkActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddNetworkActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddNetworkActionProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction action;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction getAction() {
            return this.action;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.AddNetworkActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddNetworkActionProps.Jsii$Proxy that = (AddNetworkActionProps.Jsii$Proxy) o;

            return this.action.equals(that.action);
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            return result;
        }
    }
}
