package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Options for looking up an NetworkLoadBalancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * NetworkLoadBalancerLookupOptions networkLoadBalancerLookupOptions = NetworkLoadBalancerLookupOptions.builder()
 *         .loadBalancerArn("loadBalancerArn")
 *         .loadBalancerTags(Map.of(
 *                 "loadBalancerTagsKey", "loadBalancerTags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-27T11:48:59.963Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkLoadBalancerLookupOptions")
@software.amazon.jsii.Jsii.Proxy(NetworkLoadBalancerLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkLoadBalancerLookupOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerLookupOptions {

    /**
     * @return a {@link Builder} of {@link NetworkLoadBalancerLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkLoadBalancerLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkLoadBalancerLookupOptions> {
        java.lang.String loadBalancerArn;
        java.util.Map<java.lang.String, java.lang.String> loadBalancerTags;

        /**
         * Sets the value of {@link NetworkLoadBalancerLookupOptions#getLoadBalancerArn}
         * @param loadBalancerArn Find by load balancer's ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancerLookupOptions#getLoadBalancerTags}
         * @param loadBalancerTags Match load balancer tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerTags(java.util.Map<java.lang.String, java.lang.String> loadBalancerTags) {
            this.loadBalancerTags = loadBalancerTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkLoadBalancerLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkLoadBalancerLookupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkLoadBalancerLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkLoadBalancerLookupOptions {
        private final java.lang.String loadBalancerArn;
        private final java.util.Map<java.lang.String, java.lang.String> loadBalancerTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerTags = software.amazon.jsii.Kernel.get(this, "loadBalancerTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loadBalancerArn = builder.loadBalancerArn;
            this.loadBalancerTags = builder.loadBalancerTags;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLoadBalancerTags() {
            return this.loadBalancerTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLoadBalancerArn() != null) {
                data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            }
            if (this.getLoadBalancerTags() != null) {
                data.set("loadBalancerTags", om.valueToTree(this.getLoadBalancerTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.NetworkLoadBalancerLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkLoadBalancerLookupOptions.Jsii$Proxy that = (NetworkLoadBalancerLookupOptions.Jsii$Proxy) o;

            if (this.loadBalancerArn != null ? !this.loadBalancerArn.equals(that.loadBalancerArn) : that.loadBalancerArn != null) return false;
            return this.loadBalancerTags != null ? this.loadBalancerTags.equals(that.loadBalancerTags) : that.loadBalancerTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.loadBalancerArn != null ? this.loadBalancerArn.hashCode() : 0;
            result = 31 * result + (this.loadBalancerTags != null ? this.loadBalancerTags.hashCode() : 0);
            return result;
        }
    }
}
