package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a `CfnListener`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnListenerProps cfnListenerProps = CfnListenerProps.builder()
 *         .defaultActions(List.of(ActionProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .authenticateCognitoConfig(AuthenticateCognitoConfigProperty.builder()
 *                         .userPoolArn("userPoolArn")
 *                         .userPoolClientId("userPoolClientId")
 *                         .userPoolDomain("userPoolDomain")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout("sessionTimeout")
 *                         .build())
 *                 .authenticateOidcConfig(AuthenticateOidcConfigProperty.builder()
 *                         .authorizationEndpoint("authorizationEndpoint")
 *                         .clientId("clientId")
 *                         .clientSecret("clientSecret")
 *                         .issuer("issuer")
 *                         .tokenEndpoint("tokenEndpoint")
 *                         .userInfoEndpoint("userInfoEndpoint")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout("sessionTimeout")
 *                         .build())
 *                 .fixedResponseConfig(FixedResponseConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentType("contentType")
 *                         .messageBody("messageBody")
 *                         .build())
 *                 .forwardConfig(ForwardConfigProperty.builder()
 *                         .targetGroups(List.of(TargetGroupTupleProperty.builder()
 *                                 .targetGroupArn("targetGroupArn")
 *                                 .weight(123)
 *                                 .build()))
 *                         .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
 *                                 .durationSeconds(123)
 *                                 .enabled(false)
 *                                 .build())
 *                         .build())
 *                 .order(123)
 *                 .redirectConfig(RedirectConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .host("host")
 *                         .path("path")
 *                         .port("port")
 *                         .protocol("protocol")
 *                         .query("query")
 *                         .build())
 *                 .targetGroupArn("targetGroupArn")
 *                 .build()))
 *         .loadBalancerArn("loadBalancerArn")
 *         // the properties below are optional
 *         .alpnPolicy(List.of("alpnPolicy"))
 *         .certificates(List.of(CertificateProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .build()))
 *         .port(123)
 *         .protocol("protocol")
 *         .sslPolicy("sslPolicy")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-02T10:52:41.067Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListenerProps")
@software.amazon.jsii.Jsii.Proxy(CfnListenerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnListenerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The actions for the default rule. You cannot define a condition for a default rule.
     * <p>
     * To create additional rules for an Application Load Balancer, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html">AWS::ElasticLoadBalancingV2::ListenerRule</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefaultActions();

    /**
     * The Amazon Resource Name (ARN) of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArn();

    /**
     * [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAlpnPolicy() {
        return null;
    }

    /**
     * The default SSL server certificate for a secure listener.
     * <p>
     * You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
     * <p>
     * To create a certificate list for a secure listener, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html">AWS::ElasticLoadBalancingV2::ListenerCertificate</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCertificates() {
        return null;
    }

    /**
     * The port on which the load balancer is listening.
     * <p>
     * You cannot specify a port for a Gateway Load Balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The protocol for connections from clients to the load balancer.
     * <p>
     * For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return null;
    }

    /**
     * [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <em>Application Load Balancers Guide</em> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <em>Network Load Balancers Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSslPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnListenerProps> {
        java.lang.Object defaultActions;
        java.lang.String loadBalancerArn;
        java.util.List<java.lang.String> alpnPolicy;
        java.lang.Object certificates;
        java.lang.Number port;
        java.lang.String protocol;
        java.lang.String sslPolicy;

        /**
         * Sets the value of {@link CfnListenerProps#getDefaultActions}
         * @param defaultActions The actions for the default rule. You cannot define a condition for a default rule. This parameter is required.
         *                       To create additional rules for an Application Load Balancer, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html">AWS::ElasticLoadBalancingV2::ListenerRule</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultActions(software.amazon.awscdk.core.IResolvable defaultActions) {
            this.defaultActions = defaultActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerProps#getDefaultActions}
         * @param defaultActions The actions for the default rule. You cannot define a condition for a default rule. This parameter is required.
         *                       To create additional rules for an Application Load Balancer, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html">AWS::ElasticLoadBalancingV2::ListenerRule</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultActions(java.util.List<? extends java.lang.Object> defaultActions) {
            this.defaultActions = defaultActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerProps#getLoadBalancerArn}
         * @param loadBalancerArn The Amazon Resource Name (ARN) of the load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerProps#getAlpnPolicy}
         * @param alpnPolicy [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alpnPolicy(java.util.List<java.lang.String> alpnPolicy) {
            this.alpnPolicy = alpnPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerProps#getCertificates}
         * @param certificates The default SSL server certificate for a secure listener.
         *                     You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         *                     <p>
         *                     To create a certificate list for a secure listener, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html">AWS::ElasticLoadBalancingV2::ListenerCertificate</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(software.amazon.awscdk.core.IResolvable certificates) {
            this.certificates = certificates;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerProps#getCertificates}
         * @param certificates The default SSL server certificate for a secure listener.
         *                     You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         *                     <p>
         *                     To create a certificate list for a secure listener, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html">AWS::ElasticLoadBalancingV2::ListenerCertificate</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(java.util.List<? extends java.lang.Object> certificates) {
            this.certificates = certificates;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerProps#getPort}
         * @param port The port on which the load balancer is listening.
         *             You cannot specify a port for a Gateway Load Balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerProps#getProtocol}
         * @param protocol The protocol for connections from clients to the load balancer.
         *                 For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerProps#getSslPolicy}
         * @param sslPolicy [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
         *                  For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <em>Application Load Balancers Guide</em> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <em>Network Load Balancers Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(java.lang.String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnListenerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnListenerProps {
        private final java.lang.Object defaultActions;
        private final java.lang.String loadBalancerArn;
        private final java.util.List<java.lang.String> alpnPolicy;
        private final java.lang.Object certificates;
        private final java.lang.Number port;
        private final java.lang.String protocol;
        private final java.lang.String sslPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultActions = software.amazon.jsii.Kernel.get(this, "defaultActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alpnPolicy = software.amazon.jsii.Kernel.get(this, "alpnPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.certificates = software.amazon.jsii.Kernel.get(this, "certificates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sslPolicy = software.amazon.jsii.Kernel.get(this, "sslPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultActions = java.util.Objects.requireNonNull(builder.defaultActions, "defaultActions is required");
            this.loadBalancerArn = java.util.Objects.requireNonNull(builder.loadBalancerArn, "loadBalancerArn is required");
            this.alpnPolicy = builder.alpnPolicy;
            this.certificates = builder.certificates;
            this.port = builder.port;
            this.protocol = builder.protocol;
            this.sslPolicy = builder.sslPolicy;
        }

        @Override
        public final java.lang.Object getDefaultActions() {
            return this.defaultActions;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.util.List<java.lang.String> getAlpnPolicy() {
            return this.alpnPolicy;
        }

        @Override
        public final java.lang.Object getCertificates() {
            return this.certificates;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.String getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultActions", om.valueToTree(this.getDefaultActions()));
            data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            if (this.getAlpnPolicy() != null) {
                data.set("alpnPolicy", om.valueToTree(this.getAlpnPolicy()));
            }
            if (this.getCertificates() != null) {
                data.set("certificates", om.valueToTree(this.getCertificates()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSslPolicy() != null) {
                data.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListenerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnListenerProps.Jsii$Proxy that = (CfnListenerProps.Jsii$Proxy) o;

            if (!defaultActions.equals(that.defaultActions)) return false;
            if (!loadBalancerArn.equals(that.loadBalancerArn)) return false;
            if (this.alpnPolicy != null ? !this.alpnPolicy.equals(that.alpnPolicy) : that.alpnPolicy != null) return false;
            if (this.certificates != null ? !this.certificates.equals(that.certificates) : that.certificates != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.sslPolicy != null ? this.sslPolicy.equals(that.sslPolicy) : that.sslPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultActions.hashCode();
            result = 31 * result + (this.loadBalancerArn.hashCode());
            result = 31 * result + (this.alpnPolicy != null ? this.alpnPolicy.hashCode() : 0);
            result = 31 * result + (this.certificates != null ? this.certificates.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.sslPolicy != null ? this.sslPolicy.hashCode() : 0);
            return result;
        }
    }
}
