package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a `CfnTargetGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnTargetGroupProps cfnTargetGroupProps = CfnTargetGroupProps.builder()
 *         .healthCheckEnabled(false)
 *         .healthCheckIntervalSeconds(123)
 *         .healthCheckPath("healthCheckPath")
 *         .healthCheckPort("healthCheckPort")
 *         .healthCheckProtocol("healthCheckProtocol")
 *         .healthCheckTimeoutSeconds(123)
 *         .healthyThresholdCount(123)
 *         .ipAddressType("ipAddressType")
 *         .matcher(MatcherProperty.builder()
 *                 .grpcCode("grpcCode")
 *                 .httpCode("httpCode")
 *                 .build())
 *         .name("name")
 *         .port(123)
 *         .protocol("protocol")
 *         .protocolVersion("protocolVersion")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetGroupAttributes(List.of(TargetGroupAttributeProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targets(List.of(TargetDescriptionProperty.builder()
 *                 .id("id")
 *                 // the properties below are optional
 *                 .availabilityZone("availabilityZone")
 *                 .port(123)
 *                 .build()))
 *         .targetType("targetType")
 *         .unhealthyThresholdCount(123)
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-02T10:52:41.121Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnTargetGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTargetGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether health checks are enabled.
     * <p>
     * If the target type is <code>lambda</code> , health checks are disabled by default but can be enabled. If the target type is <code>instance</code> , <code>ip</code> , or <code>alb</code> , health checks are always enabled and cannot be disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckEnabled() {
        return null;
    }

    /**
     * The approximate amount of time, in seconds, between health checks of an individual target.
     * <p>
     * If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code> , the default is 35 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHealthCheckIntervalSeconds() {
        return null;
    }

    /**
     * [HTTP/HTTPS health checks] The destination for health checks on the targets.
     * <p>
     * [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
     * <p>
     * [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is / AWS .ALB/healthcheck.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckPath() {
        return null;
    }

    /**
     * The port the load balancer uses when performing health checks on targets.
     * <p>
     * If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code> , which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckPort() {
        return null;
    }

    /**
     * The protocol the load balancer uses when performing health checks on targets.
     * <p>
     * For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckProtocol() {
        return null;
    }

    /**
     * The amount of time, in seconds, during which no response from a target means a failed health check.
     * <p>
     * For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code> , the default is 30 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHealthCheckTimeoutSeconds() {
        return null;
    }

    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * <p>
     * For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHealthyThresholdCount() {
        return null;
    }

    /**
     * The type of IP address used for this target group.
     * <p>
     * The possible values are <code>ipv4</code> and <code>ipv6</code> . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return null;
    }

    /**
     * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMatcher() {
        return null;
    }

    /**
     * The name of the target group.
     * <p>
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The port on which the targets receive traffic.
     * <p>
     * This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The protocol to use for routing traffic to the targets.
     * <p>
     * For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return null;
    }

    /**
     * [HTTP/HTTPS protocol] The protocol version.
     * <p>
     * The possible values are <code>GRPC</code> , <code>HTTP1</code> , and <code>HTTP2</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocolVersion() {
        return null;
    }

    /**
     * The tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupAttributes() {
        return null;
    }

    /**
     * The targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return null;
    }

    /**
     * The type of target that you must specify when registering targets with this target group.
     * <p>
     * You can't specify targets for a target group using more than one target type.
     * <p>
     * <ul>
     * <li><code>instance</code> - Register targets by instance ID. This is the default value.</li>
     * <li><code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</li>
     * <li><code>lambda</code> - Register a single Lambda function as a target.</li>
     * <li><code>alb</code> - Register a single Application Load Balancer as a target.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetType() {
        return null;
    }

    /**
     * The number of consecutive health check failures required before considering a target unhealthy.
     * <p>
     * If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUnhealthyThresholdCount() {
        return null;
    }

    /**
     * The identifier of the virtual private cloud (VPC).
     * <p>
     * If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTargetGroupProps> {
        java.lang.Object healthCheckEnabled;
        java.lang.Number healthCheckIntervalSeconds;
        java.lang.String healthCheckPath;
        java.lang.String healthCheckPort;
        java.lang.String healthCheckProtocol;
        java.lang.Number healthCheckTimeoutSeconds;
        java.lang.Number healthyThresholdCount;
        java.lang.String ipAddressType;
        java.lang.Object matcher;
        java.lang.String name;
        java.lang.Number port;
        java.lang.String protocol;
        java.lang.String protocolVersion;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object targetGroupAttributes;
        java.lang.Object targets;
        java.lang.String targetType;
        java.lang.Number unhealthyThresholdCount;
        java.lang.String vpcId;

        /**
         * Sets the value of {@link CfnTargetGroupProps#getHealthCheckEnabled}
         * @param healthCheckEnabled Indicates whether health checks are enabled.
         *                           If the target type is <code>lambda</code> , health checks are disabled by default but can be enabled. If the target type is <code>instance</code> , <code>ip</code> , or <code>alb</code> , health checks are always enabled and cannot be disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckEnabled(java.lang.Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getHealthCheckEnabled}
         * @param healthCheckEnabled Indicates whether health checks are enabled.
         *                           If the target type is <code>lambda</code> , health checks are disabled by default but can be enabled. If the target type is <code>instance</code> , <code>ip</code> , or <code>alb</code> , health checks are always enabled and cannot be disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckEnabled(software.amazon.awscdk.core.IResolvable healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getHealthCheckIntervalSeconds}
         * @param healthCheckIntervalSeconds The approximate amount of time, in seconds, between health checks of an individual target.
         *                                   If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code> , the default is 35 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckIntervalSeconds(java.lang.Number healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getHealthCheckPath}
         * @param healthCheckPath [HTTP/HTTPS health checks] The destination for health checks on the targets.
         *                        [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
         *                        <p>
         *                        [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is / AWS .ALB/healthcheck.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckPath(java.lang.String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getHealthCheckPort}
         * @param healthCheckPort The port the load balancer uses when performing health checks on targets.
         *                        If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code> , which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckPort(java.lang.String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getHealthCheckProtocol}
         * @param healthCheckProtocol The protocol the load balancer uses when performing health checks on targets.
         *                            For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckProtocol(java.lang.String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getHealthCheckTimeoutSeconds}
         * @param healthCheckTimeoutSeconds The amount of time, in seconds, during which no response from a target means a failed health check.
         *                                  For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code> , the default is 30 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckTimeoutSeconds(java.lang.Number healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getHealthyThresholdCount}
         * @param healthyThresholdCount The number of consecutive health checks successes required before considering an unhealthy target healthy.
         *                              For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 5.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthyThresholdCount(java.lang.Number healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getIpAddressType}
         * @param ipAddressType The type of IP address used for this target group.
         *                      The possible values are <code>ipv4</code> and <code>ipv6</code> . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getMatcher}
         * @param matcher [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matcher(software.amazon.awscdk.core.IResolvable matcher) {
            this.matcher = matcher;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getMatcher}
         * @param matcher [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matcher(software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup.MatcherProperty matcher) {
            this.matcher = matcher;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getName}
         * @param name The name of the target group.
         *             This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getPort}
         * @param port The port on which the targets receive traffic.
         *             This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getProtocol}
         * @param protocol The protocol to use for routing traffic to the targets.
         *                 For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getProtocolVersion}
         * @param protocolVersion [HTTP/HTTPS protocol] The protocol version.
         *                        The possible values are <code>GRPC</code> , <code>HTTP1</code> , and <code>HTTP2</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolVersion(java.lang.String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getTags}
         * @param tags The tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getTargetGroupAttributes}
         * @param targetGroupAttributes The attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupAttributes(software.amazon.awscdk.core.IResolvable targetGroupAttributes) {
            this.targetGroupAttributes = targetGroupAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getTargetGroupAttributes}
         * @param targetGroupAttributes The attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupAttributes(java.util.List<? extends java.lang.Object> targetGroupAttributes) {
            this.targetGroupAttributes = targetGroupAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getTargets}
         * @param targets The targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.core.IResolvable targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getTargets}
         * @param targets The targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<? extends java.lang.Object> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getTargetType}
         * @param targetType The type of target that you must specify when registering targets with this target group.
         *                   You can't specify targets for a target group using more than one target type.
         *                   <p>
         *                   <ul>
         *                   <li><code>instance</code> - Register targets by instance ID. This is the default value.</li>
         *                   <li><code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</li>
         *                   <li><code>lambda</code> - Register a single Lambda function as a target.</li>
         *                   <li><code>alb</code> - Register a single Application Load Balancer as a target.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(java.lang.String targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getUnhealthyThresholdCount}
         * @param unhealthyThresholdCount The number of consecutive health check failures required before considering a target unhealthy.
         *                                If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 2.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unhealthyThresholdCount(java.lang.Number unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnTargetGroupProps#getVpcId}
         * @param vpcId The identifier of the virtual private cloud (VPC).
         *              If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTargetGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTargetGroupProps {
        private final java.lang.Object healthCheckEnabled;
        private final java.lang.Number healthCheckIntervalSeconds;
        private final java.lang.String healthCheckPath;
        private final java.lang.String healthCheckPort;
        private final java.lang.String healthCheckProtocol;
        private final java.lang.Number healthCheckTimeoutSeconds;
        private final java.lang.Number healthyThresholdCount;
        private final java.lang.String ipAddressType;
        private final java.lang.Object matcher;
        private final java.lang.String name;
        private final java.lang.Number port;
        private final java.lang.String protocol;
        private final java.lang.String protocolVersion;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object targetGroupAttributes;
        private final java.lang.Object targets;
        private final java.lang.String targetType;
        private final java.lang.Number unhealthyThresholdCount;
        private final java.lang.String vpcId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.healthCheckEnabled = software.amazon.jsii.Kernel.get(this, "healthCheckEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.healthCheckIntervalSeconds = software.amazon.jsii.Kernel.get(this, "healthCheckIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.healthCheckPath = software.amazon.jsii.Kernel.get(this, "healthCheckPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthCheckPort = software.amazon.jsii.Kernel.get(this, "healthCheckPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthCheckProtocol = software.amazon.jsii.Kernel.get(this, "healthCheckProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthCheckTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "healthCheckTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.healthyThresholdCount = software.amazon.jsii.Kernel.get(this, "healthyThresholdCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.matcher = software.amazon.jsii.Kernel.get(this, "matcher", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocolVersion = software.amazon.jsii.Kernel.get(this, "protocolVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.targetGroupAttributes = software.amazon.jsii.Kernel.get(this, "targetGroupAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetType = software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.unhealthyThresholdCount = software.amazon.jsii.Kernel.get(this, "unhealthyThresholdCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.healthCheckEnabled = builder.healthCheckEnabled;
            this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
            this.healthCheckPath = builder.healthCheckPath;
            this.healthCheckPort = builder.healthCheckPort;
            this.healthCheckProtocol = builder.healthCheckProtocol;
            this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
            this.healthyThresholdCount = builder.healthyThresholdCount;
            this.ipAddressType = builder.ipAddressType;
            this.matcher = builder.matcher;
            this.name = builder.name;
            this.port = builder.port;
            this.protocol = builder.protocol;
            this.protocolVersion = builder.protocolVersion;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.targetGroupAttributes = builder.targetGroupAttributes;
            this.targets = builder.targets;
            this.targetType = builder.targetType;
            this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
            this.vpcId = builder.vpcId;
        }

        @Override
        public final java.lang.Object getHealthCheckEnabled() {
            return this.healthCheckEnabled;
        }

        @Override
        public final java.lang.Number getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final java.lang.String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final java.lang.String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final java.lang.String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @Override
        public final java.lang.Number getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        @Override
        public final java.lang.Number getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.Object getMatcher() {
            return this.matcher;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTargetGroupAttributes() {
            return this.targetGroupAttributes;
        }

        @Override
        public final java.lang.Object getTargets() {
            return this.targets;
        }

        @Override
        public final java.lang.String getTargetType() {
            return this.targetType;
        }

        @Override
        public final java.lang.Number getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHealthCheckEnabled() != null) {
                data.set("healthCheckEnabled", om.valueToTree(this.getHealthCheckEnabled()));
            }
            if (this.getHealthCheckIntervalSeconds() != null) {
                data.set("healthCheckIntervalSeconds", om.valueToTree(this.getHealthCheckIntervalSeconds()));
            }
            if (this.getHealthCheckPath() != null) {
                data.set("healthCheckPath", om.valueToTree(this.getHealthCheckPath()));
            }
            if (this.getHealthCheckPort() != null) {
                data.set("healthCheckPort", om.valueToTree(this.getHealthCheckPort()));
            }
            if (this.getHealthCheckProtocol() != null) {
                data.set("healthCheckProtocol", om.valueToTree(this.getHealthCheckProtocol()));
            }
            if (this.getHealthCheckTimeoutSeconds() != null) {
                data.set("healthCheckTimeoutSeconds", om.valueToTree(this.getHealthCheckTimeoutSeconds()));
            }
            if (this.getHealthyThresholdCount() != null) {
                data.set("healthyThresholdCount", om.valueToTree(this.getHealthyThresholdCount()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getMatcher() != null) {
                data.set("matcher", om.valueToTree(this.getMatcher()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getProtocolVersion() != null) {
                data.set("protocolVersion", om.valueToTree(this.getProtocolVersion()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetGroupAttributes() != null) {
                data.set("targetGroupAttributes", om.valueToTree(this.getTargetGroupAttributes()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }
            if (this.getTargetType() != null) {
                data.set("targetType", om.valueToTree(this.getTargetType()));
            }
            if (this.getUnhealthyThresholdCount() != null) {
                data.set("unhealthyThresholdCount", om.valueToTree(this.getUnhealthyThresholdCount()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTargetGroupProps.Jsii$Proxy that = (CfnTargetGroupProps.Jsii$Proxy) o;

            if (this.healthCheckEnabled != null ? !this.healthCheckEnabled.equals(that.healthCheckEnabled) : that.healthCheckEnabled != null) return false;
            if (this.healthCheckIntervalSeconds != null ? !this.healthCheckIntervalSeconds.equals(that.healthCheckIntervalSeconds) : that.healthCheckIntervalSeconds != null) return false;
            if (this.healthCheckPath != null ? !this.healthCheckPath.equals(that.healthCheckPath) : that.healthCheckPath != null) return false;
            if (this.healthCheckPort != null ? !this.healthCheckPort.equals(that.healthCheckPort) : that.healthCheckPort != null) return false;
            if (this.healthCheckProtocol != null ? !this.healthCheckProtocol.equals(that.healthCheckProtocol) : that.healthCheckProtocol != null) return false;
            if (this.healthCheckTimeoutSeconds != null ? !this.healthCheckTimeoutSeconds.equals(that.healthCheckTimeoutSeconds) : that.healthCheckTimeoutSeconds != null) return false;
            if (this.healthyThresholdCount != null ? !this.healthyThresholdCount.equals(that.healthyThresholdCount) : that.healthyThresholdCount != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.matcher != null ? !this.matcher.equals(that.matcher) : that.matcher != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.protocolVersion != null ? !this.protocolVersion.equals(that.protocolVersion) : that.protocolVersion != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.targetGroupAttributes != null ? !this.targetGroupAttributes.equals(that.targetGroupAttributes) : that.targetGroupAttributes != null) return false;
            if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) return false;
            if (this.targetType != null ? !this.targetType.equals(that.targetType) : that.targetType != null) return false;
            if (this.unhealthyThresholdCount != null ? !this.unhealthyThresholdCount.equals(that.unhealthyThresholdCount) : that.unhealthyThresholdCount != null) return false;
            return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.healthCheckEnabled != null ? this.healthCheckEnabled.hashCode() : 0;
            result = 31 * result + (this.healthCheckIntervalSeconds != null ? this.healthCheckIntervalSeconds.hashCode() : 0);
            result = 31 * result + (this.healthCheckPath != null ? this.healthCheckPath.hashCode() : 0);
            result = 31 * result + (this.healthCheckPort != null ? this.healthCheckPort.hashCode() : 0);
            result = 31 * result + (this.healthCheckProtocol != null ? this.healthCheckProtocol.hashCode() : 0);
            result = 31 * result + (this.healthCheckTimeoutSeconds != null ? this.healthCheckTimeoutSeconds.hashCode() : 0);
            result = 31 * result + (this.healthyThresholdCount != null ? this.healthyThresholdCount.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.matcher != null ? this.matcher.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.protocolVersion != null ? this.protocolVersion.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetGroupAttributes != null ? this.targetGroupAttributes.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            result = 31 * result + (this.targetType != null ? this.targetType.hashCode() : 0);
            result = 31 * result + (this.unhealthyThresholdCount != null ? this.unhealthyThresholdCount.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            return result;
        }
    }
}
