package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for defining a rule on a listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * ApplicationTargetGroup applicationTargetGroup;
 * ListenerAction listenerAction;
 * ListenerCondition listenerCondition;
 * BaseApplicationListenerRuleProps baseApplicationListenerRuleProps = BaseApplicationListenerRuleProps.builder()
 *         .priority(123)
 *         // the properties below are optional
 *         .action(listenerAction)
 *         .conditions(List.of(listenerCondition))
 *         .fixedResponse(FixedResponse.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .contentType(ContentType.TEXT_PLAIN)
 *                 .messageBody("messageBody")
 *                 .build())
 *         .hostHeader("hostHeader")
 *         .pathPattern("pathPattern")
 *         .pathPatterns(List.of("pathPatterns"))
 *         .redirectResponse(RedirectResponse.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .host("host")
 *                 .path("path")
 *                 .port("port")
 *                 .protocol("protocol")
 *                 .query("query")
 *                 .build())
 *         .targetGroups(List.of(applicationTargetGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-08T19:43:55.182Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.BaseApplicationListenerRuleProps")
@software.amazon.jsii.Jsii.Proxy(BaseApplicationListenerRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Priority of the rule.
     * <p>
     * The rule with the lowest priority will be used for every request.
     * <p>
     * Priorities must be unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * Action to perform when requests are received.
     * <p>
     * Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
     * <p>
     * Default: - No action
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getAction() {
        return null;
    }

    /**
     * Rule applies if matches the conditions.
     * <p>
     * Default: - No conditions.
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> getConditions() {
        return null;
    }

    /**
     * (deprecated) Fixed response to return.
     * <p>
     * Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
     * <p>
     * Default: - No fixed response.
     * <p>
     * @deprecated Use `action` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
        return null;
    }

    /**
     * (deprecated) Rule applies if the requested host matches the indicated host.
     * <p>
     * May contain up to three '*' wildcards.
     * <p>
     * Default: - No host condition.
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     * @deprecated Use `conditions` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getHostHeader() {
        return null;
    }

    /**
     * (deprecated) Rule applies if the requested path matches the given path pattern.
     * <p>
     * Default: - No path condition.
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     * @deprecated Use `conditions` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getPathPattern() {
        return null;
    }

    /**
     * (deprecated) Rule applies if the requested path matches any of the given patterns.
     * <p>
     * Paths may contain up to three '*' wildcards.
     * <p>
     * Default: - No path conditions.
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     * @deprecated Use `conditions` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathPatterns() {
        return null;
    }

    /**
     * (deprecated) Redirect response to return.
     * <p>
     * Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
     * <p>
     * Default: - No redirect response.
     * <p>
     * @deprecated Use `action` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse getRedirectResponse() {
        return null;
    }

    /**
     * Target groups to forward requests to.
     * <p>
     * Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
     * <p>
     * Implies a <code>forward</code> action.
     * <p>
     * Default: - No target groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseApplicationListenerRuleProps> {
        java.lang.Number priority;
        software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        java.lang.String hostHeader;
        java.lang.String pathPattern;
        java.util.List<java.lang.String> pathPatterns;
        software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getPriority}
         * @param priority Priority of the rule. This parameter is required.
         *                 The rule with the lowest priority will be used for every request.
         *                 <p>
         *                 Priorities must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getAction}
         * @param action Action to perform when requests are received.
         *               Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getConditions}
         * @param conditions Rule applies if matches the conditions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions) {
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)conditions;
            return this;
        }

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getFixedResponse}
         * @param fixedResponse Fixed response to return.
         *                      Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * @return {@code this}
         * @deprecated Use `action` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder fixedResponse(software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse) {
            this.fixedResponse = fixedResponse;
            return this;
        }

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getHostHeader}
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         *                   May contain up to three '*' wildcards.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getPathPattern}
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getPathPatterns}
         * @param pathPatterns Rule applies if the requested path matches any of the given patterns.
         *                     Paths may contain up to three '*' wildcards.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPatterns(java.util.List<java.lang.String> pathPatterns) {
            this.pathPatterns = pathPatterns;
            return this;
        }

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getRedirectResponse}
         * @param redirectResponse Redirect response to return.
         *                         Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * @return {@code this}
         * @deprecated Use `action` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder redirectResponse(software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse) {
            this.redirectResponse = redirectResponse;
            return this;
        }

        /**
         * Sets the value of {@link BaseApplicationListenerRuleProps#getTargetGroups}
         * @param targetGroups Target groups to forward requests to.
         *                     Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         *                     <p>
         *                     Implies a <code>forward</code> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targetGroups(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup>)targetGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseApplicationListenerRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseApplicationListenerRuleProps {
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.util.List<java.lang.String> pathPatterns;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition.class)));
            this.fixedResponse = software.amazon.jsii.Kernel.get(this, "fixedResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse.class));
            this.hostHeader = software.amazon.jsii.Kernel.get(this, "hostHeader", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathPattern = software.amazon.jsii.Kernel.get(this, "pathPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathPatterns = software.amazon.jsii.Kernel.get(this, "pathPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.redirectResponse = software.amazon.jsii.Kernel.get(this, "redirectResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse.class));
            this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
            this.action = builder.action;
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)builder.conditions;
            this.fixedResponse = builder.fixedResponse;
            this.hostHeader = builder.hostHeader;
            this.pathPattern = builder.pathPattern;
            this.pathPatterns = builder.pathPatterns;
            this.redirectResponse = builder.redirectResponse;
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup>)builder.targetGroups;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getAction() {
            return this.action;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> getConditions() {
            return this.conditions;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
            return this.fixedResponse;
        }

        @Override
        public final java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public final java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public final java.util.List<java.lang.String> getPathPatterns() {
            return this.pathPatterns;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse getRedirectResponse() {
            return this.redirectResponse;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("priority", om.valueToTree(this.getPriority()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getFixedResponse() != null) {
                data.set("fixedResponse", om.valueToTree(this.getFixedResponse()));
            }
            if (this.getHostHeader() != null) {
                data.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getPathPatterns() != null) {
                data.set("pathPatterns", om.valueToTree(this.getPathPatterns()));
            }
            if (this.getRedirectResponse() != null) {
                data.set("redirectResponse", om.valueToTree(this.getRedirectResponse()));
            }
            if (this.getTargetGroups() != null) {
                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.BaseApplicationListenerRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseApplicationListenerRuleProps.Jsii$Proxy that = (BaseApplicationListenerRuleProps.Jsii$Proxy) o;

            if (!priority.equals(that.priority)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            if (this.fixedResponse != null ? !this.fixedResponse.equals(that.fixedResponse) : that.fixedResponse != null) return false;
            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            if (this.pathPatterns != null ? !this.pathPatterns.equals(that.pathPatterns) : that.pathPatterns != null) return false;
            if (this.redirectResponse != null ? !this.redirectResponse.equals(that.redirectResponse) : that.redirectResponse != null) return false;
            return this.targetGroups != null ? this.targetGroups.equals(that.targetGroups) : that.targetGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.priority.hashCode();
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            result = 31 * result + (this.fixedResponse != null ? this.fixedResponse.hashCode() : 0);
            result = 31 * result + (this.hostHeader != null ? this.hostHeader.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.pathPatterns != null ? this.pathPatterns.hashCode() : 0);
            result = 31 * result + (this.redirectResponse != null ? this.redirectResponse.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            return result;
        }
    }
}
