package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 * <p>
 * Specifies a target group for a load balancer.
 * <p>
 * Before you register a Lambda function as a target, you must create a <code>AWS::Lambda::Permission</code> resource that grants the Elastic Load Balancing service principal permission to invoke the Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnTargetGroup cfnTargetGroup = CfnTargetGroup.Builder.create(this, "MyCfnTargetGroup")
 *         .healthCheckEnabled(false)
 *         .healthCheckIntervalSeconds(123)
 *         .healthCheckPath("healthCheckPath")
 *         .healthCheckPort("healthCheckPort")
 *         .healthCheckProtocol("healthCheckProtocol")
 *         .healthCheckTimeoutSeconds(123)
 *         .healthyThresholdCount(123)
 *         .ipAddressType("ipAddressType")
 *         .matcher(MatcherProperty.builder()
 *                 .grpcCode("grpcCode")
 *                 .httpCode("httpCode")
 *                 .build())
 *         .name("name")
 *         .port(123)
 *         .protocol("protocol")
 *         .protocolVersion("protocolVersion")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetGroupAttributes(List.of(TargetGroupAttributeProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targets(List.of(TargetDescriptionProperty.builder()
 *                 .id("id")
 *                 // the properties below are optional
 *                 .availabilityZone("availabilityZone")
 *                 .port(123)
 *                 .build()))
 *         .targetType("targetType")
 *         .unhealthyThresholdCount(123)
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-01T02:29:04.853Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroup")
public class CfnTargetGroup extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnTargetGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ElasticLoadBalancingV2::TargetGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ElasticLoadBalancingV2::TargetGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Names (ARNs) of the load balancers that route traffic to this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrLoadBalancerArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrLoadBalancerArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The full name of the target group.
     * <p>
     * For example, <code>targetgroup/my-target-group/cbf133c568e0d028</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTargetGroupFullName() {
        return software.amazon.jsii.Kernel.get(this, "attrTargetGroupFullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the target group.
     * <p>
     * For example, <code>my-target-group</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTargetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "attrTargetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Indicates whether health checks are enabled.
     * <p>
     * If the target type is <code>lambda</code> , health checks are disabled by default but can be enabled. If the target type is <code>instance</code> , <code>ip</code> , or <code>alb</code> , health checks are always enabled and cannot be disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckEnabled() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether health checks are enabled.
     * <p>
     * If the target type is <code>lambda</code> , health checks are disabled by default but can be enabled. If the target type is <code>instance</code> , <code>ip</code> , or <code>alb</code> , health checks are always enabled and cannot be disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckEnabled", value);
    }

    /**
     * Indicates whether health checks are enabled.
     * <p>
     * If the target type is <code>lambda</code> , health checks are disabled by default but can be enabled. If the target type is <code>instance</code> , <code>ip</code> , or <code>alb</code> , health checks are always enabled and cannot be disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckEnabled", value);
    }

    /**
     * The approximate amount of time, in seconds, between health checks of an individual target.
     * <p>
     * If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds and the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code> , the default is 35 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getHealthCheckIntervalSeconds() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The approximate amount of time, in seconds, between health checks of an individual target.
     * <p>
     * If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds and the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code> , the default is 35 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckIntervalSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckIntervalSeconds", value);
    }

    /**
     * [HTTP/HTTPS health checks] The destination for health checks on the targets.
     * <p>
     * [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
     * <p>
     * [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is / AWS .ALB/healthcheck.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckPath() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * [HTTP/HTTPS health checks] The destination for health checks on the targets.
     * <p>
     * [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
     * <p>
     * [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is / AWS .ALB/healthcheck.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckPath(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckPath", value);
    }

    /**
     * The port the load balancer uses when performing health checks on targets.
     * <p>
     * If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code> , which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckPort() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port the load balancer uses when performing health checks on targets.
     * <p>
     * If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code> , which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckPort(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckPort", value);
    }

    /**
     * The protocol the load balancer uses when performing health checks on targets.
     * <p>
     * For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckProtocol() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The protocol the load balancer uses when performing health checks on targets.
     * <p>
     * For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckProtocol(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckProtocol", value);
    }

    /**
     * The amount of time, in seconds, during which no response from a target means a failed health check.
     * <p>
     * For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code> , the default is 30 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getHealthCheckTimeoutSeconds() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of time, in seconds, during which no response from a target means a failed health check.
     * <p>
     * For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code> , the default is 30 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckTimeoutSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckTimeoutSeconds", value);
    }

    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * <p>
     * For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getHealthyThresholdCount() {
        return software.amazon.jsii.Kernel.get(this, "healthyThresholdCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * <p>
     * For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthyThresholdCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "healthyThresholdCount", value);
    }

    /**
     * The type of IP address used for this target group.
     * <p>
     * The possible values are <code>ipv4</code> and <code>ipv6</code> . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of IP address used for this target group.
     * <p>
     * The possible values are <code>ipv4</code> and <code>ipv6</code> . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpAddressType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipAddressType", value);
    }

    /**
     * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMatcher() {
        return software.amazon.jsii.Kernel.get(this, "matcher", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMatcher(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "matcher", value);
    }

    /**
     * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMatcher(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup.MatcherProperty value) {
        software.amazon.jsii.Kernel.set(this, "matcher", value);
    }

    /**
     * The name of the target group.
     * <p>
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the target group.
     * <p>
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The port on which the targets receive traffic.
     * <p>
     * This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port on which the targets receive traffic.
     * <p>
     * This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The protocol to use for routing traffic to the targets.
     * <p>
     * For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The protocol to use for routing traffic to the targets.
     * <p>
     * For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocol(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protocol", value);
    }

    /**
     * [HTTP/HTTPS protocol] The protocol version.
     * <p>
     * The possible values are <code>GRPC</code> , <code>HTTP1</code> , and <code>HTTP2</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProtocolVersion() {
        return software.amazon.jsii.Kernel.get(this, "protocolVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * [HTTP/HTTPS protocol] The protocol version.
     * <p>
     * The possible values are <code>GRPC</code> , <code>HTTP1</code> , and <code>HTTP2</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocolVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protocolVersion", value);
    }

    /**
     * The attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupAttributes() {
        return software.amazon.jsii.Kernel.get(this, "targetGroupAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetGroupAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetGroupAttributes", value);
    }

    /**
     * The attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetGroupAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "targetGroupAttributes", value);
    }

    /**
     * The targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }

    /**
     * The targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }

    /**
     * The type of target that you must specify when registering targets with this target group.
     * <p>
     * You can't specify targets for a target group using more than one target type.
     * <p>
     * <ul>
     * <li><code>instance</code> - Register targets by instance ID. This is the default value.</li>
     * <li><code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</li>
     * <li><code>lambda</code> - Register a single Lambda function as a target.</li>
     * <li><code>alb</code> - Register a single Application Load Balancer as a target.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTargetType() {
        return software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of target that you must specify when registering targets with this target group.
     * <p>
     * You can't specify targets for a target group using more than one target type.
     * <p>
     * <ul>
     * <li><code>instance</code> - Register targets by instance ID. This is the default value.</li>
     * <li><code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</li>
     * <li><code>lambda</code> - Register a single Lambda function as a target.</li>
     * <li><code>alb</code> - Register a single Application Load Balancer as a target.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetType", value);
    }

    /**
     * The number of consecutive health check failures required before considering a target unhealthy.
     * <p>
     * If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getUnhealthyThresholdCount() {
        return software.amazon.jsii.Kernel.get(this, "unhealthyThresholdCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of consecutive health check failures required before considering a target unhealthy.
     * <p>
     * If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUnhealthyThresholdCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "unhealthyThresholdCount", value);
    }

    /**
     * The identifier of the virtual private cloud (VPC).
     * <p>
     * If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the virtual private cloud (VPC).
     * <p>
     * If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", value);
    }
    /**
     * Specifies the HTTP codes that healthy targets must use when responding to an HTTP health check.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * MatcherProperty matcherProperty = MatcherProperty.builder()
     *         .grpcCode("grpcCode")
     *         .httpCode("httpCode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroup.MatcherProperty")
    @software.amazon.jsii.Jsii.Proxy(MatcherProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MatcherProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * You can specify values between 0 and 99.
         * <p>
         * You can specify multiple values (for example, "0,1") or a range of values (for example, "0-5"). The default value is 12.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGrpcCode() {
            return null;
        }

        /**
         * For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200.
         * <p>
         * You can specify multiple values (for example, "200,202") or a range of values (for example, "200-299").
         * <p>
         * For Network Load Balancers and Gateway Load Balancers, this must be "200–399".
         * <p>
         * Note that when using shorthand syntax, some values such as commas need to be escaped.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MatcherProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MatcherProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MatcherProperty> {
            java.lang.String grpcCode;
            java.lang.String httpCode;

            /**
             * Sets the value of {@link MatcherProperty#getGrpcCode}
             * @param grpcCode You can specify values between 0 and 99.
             *                 You can specify multiple values (for example, "0,1") or a range of values (for example, "0-5"). The default value is 12.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpcCode(java.lang.String grpcCode) {
                this.grpcCode = grpcCode;
                return this;
            }

            /**
             * Sets the value of {@link MatcherProperty#getHttpCode}
             * @param httpCode For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200.
             *                 You can specify multiple values (for example, "200,202") or a range of values (for example, "200-299").
             *                 <p>
             *                 For Network Load Balancers and Gateway Load Balancers, this must be "200–399".
             *                 <p>
             *                 Note that when using shorthand syntax, some values such as commas need to be escaped.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpCode(java.lang.String httpCode) {
                this.httpCode = httpCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MatcherProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MatcherProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MatcherProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatcherProperty {
            private final java.lang.String grpcCode;
            private final java.lang.String httpCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.grpcCode = software.amazon.jsii.Kernel.get(this, "grpcCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpCode = software.amazon.jsii.Kernel.get(this, "httpCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.grpcCode = builder.grpcCode;
                this.httpCode = builder.httpCode;
            }

            @Override
            public final java.lang.String getGrpcCode() {
                return this.grpcCode;
            }

            @Override
            public final java.lang.String getHttpCode() {
                return this.httpCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGrpcCode() != null) {
                    data.set("grpcCode", om.valueToTree(this.getGrpcCode()));
                }
                if (this.getHttpCode() != null) {
                    data.set("httpCode", om.valueToTree(this.getHttpCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroup.MatcherProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MatcherProperty.Jsii$Proxy that = (MatcherProperty.Jsii$Proxy) o;

                if (this.grpcCode != null ? !this.grpcCode.equals(that.grpcCode) : that.grpcCode != null) return false;
                return this.httpCode != null ? this.httpCode.equals(that.httpCode) : that.httpCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.grpcCode != null ? this.grpcCode.hashCode() : 0;
                result = 31 * result + (this.httpCode != null ? this.httpCode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a target to add to a target group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * TargetDescriptionProperty targetDescriptionProperty = TargetDescriptionProperty.builder()
     *         .id("id")
     *         // the properties below are optional
     *         .availabilityZone("availabilityZone")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroup.TargetDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the target.
         * <p>
         * If the target type of the target group is <code>instance</code> , specify an instance ID. If the target type is <code>ip</code> , specify an IP address. If the target type is <code>lambda</code> , specify the ARN of the Lambda function. If the target type is <code>alb</code> , specify the ARN of the Application Load Balancer target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * An Availability Zone or `all` .
         * <p>
         * This determines whether the target receives traffic from the load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.
         * <p>
         * This parameter is not supported if the target type of the target group is <code>instance</code> or <code>alb</code> .
         * <p>
         * If the target type is <code>ip</code> and the IP address is in a subnet of the VPC for the target group, the Availability Zone is automatically detected and this parameter is optional. If the IP address is outside the VPC, this parameter is required.
         * <p>
         * With an Application Load Balancer, if the target type is <code>ip</code> and the IP address is outside the VPC for the target group, the only supported value is <code>all</code> .
         * <p>
         * If the target type is <code>lambda</code> , this parameter is optional and the only supported value is <code>all</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The port on which the target is listening.
         * <p>
         * If the target group protocol is GENEVE, the supported port is 6081. If the target type is <code>alb</code> , the targeted Application Load Balancer must have at least one listener whose port matches the target group port. Not used if the target is a Lambda function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetDescriptionProperty> {
            java.lang.String id;
            java.lang.String availabilityZone;
            java.lang.Number port;

            /**
             * Sets the value of {@link TargetDescriptionProperty#getId}
             * @param id The ID of the target. This parameter is required.
             *           If the target type of the target group is <code>instance</code> , specify an instance ID. If the target type is <code>ip</code> , specify an IP address. If the target type is <code>lambda</code> , specify the ARN of the Lambda function. If the target type is <code>alb</code> , specify the ARN of the Application Load Balancer target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link TargetDescriptionProperty#getAvailabilityZone}
             * @param availabilityZone An Availability Zone or `all` .
             *                         This determines whether the target receives traffic from the load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.
             *                         <p>
             *                         This parameter is not supported if the target type of the target group is <code>instance</code> or <code>alb</code> .
             *                         <p>
             *                         If the target type is <code>ip</code> and the IP address is in a subnet of the VPC for the target group, the Availability Zone is automatically detected and this parameter is optional. If the IP address is outside the VPC, this parameter is required.
             *                         <p>
             *                         With an Application Load Balancer, if the target type is <code>ip</code> and the IP address is outside the VPC for the target group, the only supported value is <code>all</code> .
             *                         <p>
             *                         If the target type is <code>lambda</code> , this parameter is optional and the only supported value is <code>all</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link TargetDescriptionProperty#getPort}
             * @param port The port on which the target is listening.
             *             If the target group protocol is GENEVE, the supported port is 6081. If the target type is <code>alb</code> , the targeted Application Load Balancer must have at least one listener whose port matches the target group port. Not used if the target is a Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetDescriptionProperty {
            private final java.lang.String id;
            private final java.lang.String availabilityZone;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.availabilityZone = builder.availabilityZone;
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroup.TargetDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetDescriptionProperty.Jsii$Proxy that = (TargetDescriptionProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a target group attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * TargetGroupAttributeProperty targetGroupAttributeProperty = TargetGroupAttributeProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroup.TargetGroupAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the attribute.
         * <p>
         * The following attribute is supported by all load balancers:
         * <p>
         * <ul>
         * <li><code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code> . The range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is not supported.</li>
         * </ul>
         * <p>
         * The following attributes are supported by both Application Load Balancers and Network Load Balancers:
         * <p>
         * <ul>
         * <li><code>stickiness.enabled</code> - Indicates whether sticky sessions are enabled. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
         * <li><code>stickiness.type</code> - The type of sticky sessions. The possible values are <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers or <code>source_ip</code> for Network Load Balancers.</li>
         * </ul>
         * <p>
         * The following attributes are supported only if the load balancer is an Application Load Balancer and the target is an instance or an IP address:
         * <p>
         * <ul>
         * <li><code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer selects targets when routing requests. The value is <code>round_robin</code> or <code>least_outstanding_requests</code> . The default is <code>round_robin</code> .</li>
         * <li><code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target receives an increasing share of the traffic to the target group. After this time period ends, the target receives its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds (disabled).</li>
         * <li><code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names that start with the following prefixes are not allowed: <code>AWSALB</code> , <code>AWSALBAPP</code> , and <code>AWSALBTG</code> ; they're reserved for use by the load balancer.</li>
         * <li><code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the application-based cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).</li>
         * <li><code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).</li>
         * </ul>
         * <p>
         * The following attribute is supported only if the load balancer is an Application Load Balancer and the target is a Lambda function:
         * <p>
         * <ul>
         * <li><code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> . If the value is <code>false</code> and the request contains a duplicate header field name or query parameter key, the load balancer uses the last value sent by the client.</li>
         * </ul>
         * <p>
         * The following attributes are supported only by Network Load Balancers:
         * <p>
         * <ul>
         * <li><code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer terminates connections at the end of the deregistration timeout. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
         * <li><code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is <code>true</code> or <code>false</code> . The default is disabled if the target group type is IP address and the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be disabled for UDP and TCP_UDP target groups.</li>
         * <li><code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The value of the attribute.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupAttributeProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TargetGroupAttributeProperty#getKey}
             * @param key The name of the attribute.
             *            The following attribute is supported by all load balancers:
             *            <p>
             *            <ul>
             *            <li><code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code> . The range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is not supported.</li>
             *            </ul>
             *            <p>
             *            The following attributes are supported by both Application Load Balancers and Network Load Balancers:
             *            <p>
             *            <ul>
             *            <li><code>stickiness.enabled</code> - Indicates whether sticky sessions are enabled. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
             *            <li><code>stickiness.type</code> - The type of sticky sessions. The possible values are <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers or <code>source_ip</code> for Network Load Balancers.</li>
             *            </ul>
             *            <p>
             *            The following attributes are supported only if the load balancer is an Application Load Balancer and the target is an instance or an IP address:
             *            <p>
             *            <ul>
             *            <li><code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer selects targets when routing requests. The value is <code>round_robin</code> or <code>least_outstanding_requests</code> . The default is <code>round_robin</code> .</li>
             *            <li><code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target receives an increasing share of the traffic to the target group. After this time period ends, the target receives its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds (disabled).</li>
             *            <li><code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names that start with the following prefixes are not allowed: <code>AWSALB</code> , <code>AWSALBAPP</code> , and <code>AWSALBTG</code> ; they're reserved for use by the load balancer.</li>
             *            <li><code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the application-based cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).</li>
             *            <li><code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).</li>
             *            </ul>
             *            <p>
             *            The following attribute is supported only if the load balancer is an Application Load Balancer and the target is a Lambda function:
             *            <p>
             *            <ul>
             *            <li><code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> . If the value is <code>false</code> and the request contains a duplicate header field name or query parameter key, the load balancer uses the last value sent by the client.</li>
             *            </ul>
             *            <p>
             *            The following attributes are supported only by Network Load Balancers:
             *            <p>
             *            <ul>
             *            <li><code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer terminates connections at the end of the deregistration timeout. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
             *            <li><code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is <code>true</code> or <code>false</code> . The default is disabled if the target group type is IP address and the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be disabled for UDP and TCP_UDP target groups.</li>
             *            <li><code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
             *            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupAttributeProperty#getValue}
             * @param value The value of the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupAttributeProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnTargetGroup.TargetGroupAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupAttributeProperty.Jsii$Proxy that = (TargetGroupAttributeProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Indicates whether health checks are enabled.
         * <p>
         * If the target type is <code>lambda</code> , health checks are disabled by default but can be enabled. If the target type is <code>instance</code> , <code>ip</code> , or <code>alb</code> , health checks are always enabled and cannot be disabled.
         * <p>
         * @return {@code this}
         * @param healthCheckEnabled Indicates whether health checks are enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckEnabled(final java.lang.Boolean healthCheckEnabled) {
            this.props().healthCheckEnabled(healthCheckEnabled);
            return this;
        }
        /**
         * Indicates whether health checks are enabled.
         * <p>
         * If the target type is <code>lambda</code> , health checks are disabled by default but can be enabled. If the target type is <code>instance</code> , <code>ip</code> , or <code>alb</code> , health checks are always enabled and cannot be disabled.
         * <p>
         * @return {@code this}
         * @param healthCheckEnabled Indicates whether health checks are enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckEnabled(final software.amazon.awscdk.core.IResolvable healthCheckEnabled) {
            this.props().healthCheckEnabled(healthCheckEnabled);
            return this;
        }

        /**
         * The approximate amount of time, in seconds, between health checks of an individual target.
         * <p>
         * If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds and the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code> , the default is 35 seconds.
         * <p>
         * @return {@code this}
         * @param healthCheckIntervalSeconds The approximate amount of time, in seconds, between health checks of an individual target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckIntervalSeconds(final java.lang.Number healthCheckIntervalSeconds) {
            this.props().healthCheckIntervalSeconds(healthCheckIntervalSeconds);
            return this;
        }

        /**
         * [HTTP/HTTPS health checks] The destination for health checks on the targets.
         * <p>
         * [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
         * <p>
         * [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is / AWS .ALB/healthcheck.
         * <p>
         * @return {@code this}
         * @param healthCheckPath [HTTP/HTTPS health checks] The destination for health checks on the targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckPath(final java.lang.String healthCheckPath) {
            this.props().healthCheckPath(healthCheckPath);
            return this;
        }

        /**
         * The port the load balancer uses when performing health checks on targets.
         * <p>
         * If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code> , which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
         * <p>
         * @return {@code this}
         * @param healthCheckPort The port the load balancer uses when performing health checks on targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckPort(final java.lang.String healthCheckPort) {
            this.props().healthCheckPort(healthCheckPort);
            return this;
        }

        /**
         * The protocol the load balancer uses when performing health checks on targets.
         * <p>
         * For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         * <p>
         * @return {@code this}
         * @param healthCheckProtocol The protocol the load balancer uses when performing health checks on targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckProtocol(final java.lang.String healthCheckProtocol) {
            this.props().healthCheckProtocol(healthCheckProtocol);
            return this;
        }

        /**
         * The amount of time, in seconds, during which no response from a target means a failed health check.
         * <p>
         * For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code> , the default is 30 seconds.
         * <p>
         * @return {@code this}
         * @param healthCheckTimeoutSeconds The amount of time, in seconds, during which no response from a target means a failed health check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckTimeoutSeconds(final java.lang.Number healthCheckTimeoutSeconds) {
            this.props().healthCheckTimeoutSeconds(healthCheckTimeoutSeconds);
            return this;
        }

        /**
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         * <p>
         * For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 5.
         * <p>
         * @return {@code this}
         * @param healthyThresholdCount The number of consecutive health checks successes required before considering an unhealthy target healthy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthyThresholdCount(final java.lang.Number healthyThresholdCount) {
            this.props().healthyThresholdCount(healthyThresholdCount);
            return this;
        }

        /**
         * The type of IP address used for this target group.
         * <p>
         * The possible values are <code>ipv4</code> and <code>ipv6</code> . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code> .
         * <p>
         * @return {@code this}
         * @param ipAddressType The type of IP address used for this target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final java.lang.String ipAddressType) {
            this.props().ipAddressType(ipAddressType);
            return this;
        }

        /**
         * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
         * <p>
         * @return {@code this}
         * @param matcher [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matcher(final software.amazon.awscdk.core.IResolvable matcher) {
            this.props().matcher(matcher);
            return this;
        }
        /**
         * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
         * <p>
         * @return {@code this}
         * @param matcher [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matcher(final software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup.MatcherProperty matcher) {
            this.props().matcher(matcher);
            return this;
        }

        /**
         * The name of the target group.
         * <p>
         * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
         * <p>
         * @return {@code this}
         * @param name The name of the target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The port on which the targets receive traffic.
         * <p>
         * This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.
         * <p>
         * @return {@code this}
         * @param port The port on which the targets receive traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props().port(port);
            return this;
        }

        /**
         * The protocol to use for routing traffic to the targets.
         * <p>
         * For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
         * <p>
         * @return {@code this}
         * @param protocol The protocol to use for routing traffic to the targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final java.lang.String protocol) {
            this.props().protocol(protocol);
            return this;
        }

        /**
         * [HTTP/HTTPS protocol] The protocol version.
         * <p>
         * The possible values are <code>GRPC</code> , <code>HTTP1</code> , and <code>HTTP2</code> .
         * <p>
         * @return {@code this}
         * @param protocolVersion [HTTP/HTTPS protocol] The protocol version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolVersion(final java.lang.String protocolVersion) {
            this.props().protocolVersion(protocolVersion);
            return this;
        }

        /**
         * The tags.
         * <p>
         * @return {@code this}
         * @param tags The tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The attributes.
         * <p>
         * @return {@code this}
         * @param targetGroupAttributes The attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupAttributes(final software.amazon.awscdk.core.IResolvable targetGroupAttributes) {
            this.props().targetGroupAttributes(targetGroupAttributes);
            return this;
        }
        /**
         * The attributes.
         * <p>
         * @return {@code this}
         * @param targetGroupAttributes The attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupAttributes(final java.util.List<? extends java.lang.Object> targetGroupAttributes) {
            this.props().targetGroupAttributes(targetGroupAttributes);
            return this;
        }

        /**
         * The targets.
         * <p>
         * @return {@code this}
         * @param targets The targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.core.IResolvable targets) {
            this.props().targets(targets);
            return this;
        }
        /**
         * The targets.
         * <p>
         * @return {@code this}
         * @param targets The targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends java.lang.Object> targets) {
            this.props().targets(targets);
            return this;
        }

        /**
         * The type of target that you must specify when registering targets with this target group.
         * <p>
         * You can't specify targets for a target group using more than one target type.
         * <p>
         * <ul>
         * <li><code>instance</code> - Register targets by instance ID. This is the default value.</li>
         * <li><code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</li>
         * <li><code>lambda</code> - Register a single Lambda function as a target.</li>
         * <li><code>alb</code> - Register a single Application Load Balancer as a target.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param targetType The type of target that you must specify when registering targets with this target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(final java.lang.String targetType) {
            this.props().targetType(targetType);
            return this;
        }

        /**
         * The number of consecutive health check failures required before considering a target unhealthy.
         * <p>
         * If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code> , the default is 2.
         * <p>
         * @return {@code this}
         * @param unhealthyThresholdCount The number of consecutive health check failures required before considering a target unhealthy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unhealthyThresholdCount(final java.lang.Number unhealthyThresholdCount) {
            this.props().unhealthyThresholdCount(unhealthyThresholdCount);
            return this;
        }

        /**
         * The identifier of the virtual private cloud (VPC).
         * <p>
         * If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.
         * <p>
         * @return {@code this}
         * @param vpcId The identifier of the virtual private cloud (VPC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props().vpcId(vpcId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroupProps.Builder();
            }
            return this.props;
        }
    }
}
