package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define a Network Listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegration;
 * Vpc vpc = new Vpc(this, "VPC");
 * NetworkLoadBalancer lb = NetworkLoadBalancer.Builder.create(this, "lb").vpc(vpc).build();
 * NetworkListener listener = lb.addListener("listener", BaseNetworkListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddNetworkTargetsProps.builder()
 *         .port(80)
 *         .build());
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(new HttpNlbIntegration("DefaultIntegration", listener))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T12:21:45.766Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkListener")
public class NetworkListener extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseListener implements software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener {

    protected NetworkListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkListener(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Looks up a network listener.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Import an existing listener.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param networkListenerArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener fromNetworkListenerArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String networkListenerArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener.class, "fromNetworkListenerArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(networkListenerArn, "networkListenerArn is required") });
    }

    /**
     * Perform the given Action on incoming requests.
     * <p>
     * This allows full control of the default Action of the load balancer,
     * including weighted forwarding. See the <code>NetworkListenerAction</code> class for
     * all options.
     * <p>
     * @param _id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAction(final @org.jetbrains.annotations.NotNull java.lang.String _id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkActionProps props) {
        software.amazon.jsii.Kernel.call(this, "addAction", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_id, "_id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Load balance incoming requests to the given target groups.
     * <p>
     * All target groups will be load balanced to with equal weight and without
     * stickiness. For a more complex configuration than that, use <code>addAction()</code>.
     * <p>
     * @param _id This parameter is required.
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTargetGroups(final @org.jetbrains.annotations.NotNull java.lang.String _id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup... targetGroups) {
        software.amazon.jsii.Kernel.call(this, "addTargetGroups", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(_id, "_id is required") }), java.util.Arrays.<Object>stream(targetGroups)).toArray(Object[]::new));
    }

    /**
     * Load balance incoming requests to the given load balancing targets.
     * <p>
     * This method implicitly creates a NetworkTargetGroup for the targets
     * involved, and a 'forward' action to route traffic to the given TargetGroup.
     * <p>
     * If you want more control over the precise setup, create the TargetGroup
     * and use <code>addAction</code> yourself.
     * <p>
     * It's possible to add conditions to the targets added in this way. At least
     * one set of targets must be added without conditions.
     * <p>
     * @return The newly created target group
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup addTargets(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkTargetsProps props) {
        return software.amazon.jsii.Kernel.call(this, "addTargets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The load balancer this listener is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps.Builder();
        }

        /**
         * The port on which the listener listens for requests.
         * <p>
         * @return {@code this}
         * @param port The port on which the listener listens for requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * Application-Layer Protocol Negotiation (ALPN) is a TLS extension that is sent on the initial TLS handshake hello messages.
         * <p>
         * ALPN enables the application layer to negotiate which protocols should be used over a secure connection, such as HTTP/1 and HTTP/2.
         * <p>
         * Can only be specified together with Protocol TLS.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param alpnPolicy Application-Layer Protocol Negotiation (ALPN) is a TLS extension that is sent on the initial TLS handshake hello messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alpnPolicy(final software.amazon.awscdk.services.elasticloadbalancingv2.AlpnPolicy alpnPolicy) {
            this.props.alpnPolicy(alpnPolicy);
            return this;
        }

        /**
         * Certificate list of ACM cert ARNs.
         * <p>
         * You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         * <p>
         * Default: - No certificates.
         * <p>
         * @return {@code this}
         * @param certificates Certificate list of ACM cert ARNs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        /**
         * Default action to take for requests to this listener.
         * <p>
         * This allows full control of the default Action of the load balancer,
         * including weighted forwarding. See the <code>NetworkListenerAction</code> class for
         * all options.
         * <p>
         * Cannot be specified together with <code>defaultTargetGroups</code>.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param defaultAction Default action to take for requests to this listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction defaultAction) {
            this.props.defaultAction(defaultAction);
            return this;
        }

        /**
         * Default target groups to load balance to.
         * <p>
         * All target groups will be load balanced to with equal weight and without
         * stickiness. For a more complex configuration than that, use
         * either <code>defaultAction</code> or <code>addAction()</code>.
         * <p>
         * Cannot be specified together with <code>defaultAction</code>.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param defaultTargetGroups Default target groups to load balance to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTargetGroups(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups) {
            this.props.defaultTargetGroups(defaultTargetGroups);
            return this;
        }

        /**
         * Protocol for listener, expects TCP, TLS, UDP, or TCP_UDP.
         * <p>
         * Default: - TLS if certificates are provided. TCP otherwise.
         * <p>
         * @return {@code this}
         * @param protocol Protocol for listener, expects TCP, TLS, UDP, or TCP_UDP. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * SSL Policy.
         * <p>
         * Default: - Current predefined security policy.
         * <p>
         * @return {@code this}
         * @param sslPolicy SSL Policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        /**
         * The load balancer to attach this listener to.
         * <p>
         * @return {@code this}
         * @param loadBalancer The load balancer to attach this listener to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
