package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:26:31.882Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getListenerArn();

    /**
     * The default port on which this listener is listening.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getDefaultPort();

    /**
     * Security group of the load balancer this listener is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup();

    /**
     * Whether the imported security group allows all outbound traffic or not when imported using `securityGroupId`.
     * 
     * Unless set to `false`, no egress rules will be added to the security group.
     * 
     * Default: true
     * 
     * @deprecated use `securityGroup` instead
     */
    @Deprecated
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    java.lang.Boolean getSecurityGroupAllowsAllOutbound();

    /**
     * Security group ID of the load balancer this listener is associated with.
     * 
     * @deprecated use `securityGroup` instead
     */
    @Deprecated
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    java.lang.String getSecurityGroupId();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String listenerArn;
        private java.lang.Number defaultPort;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private java.lang.Boolean securityGroupAllowsAllOutbound;
        private java.lang.String securityGroupId;

        /**
         * Sets the value of ListenerArn
         * @param listenerArn ARN of the listener. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of DefaultPort
         * @param defaultPort The default port on which this listener is listening.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(java.lang.Number defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Sets the value of SecurityGroup
         * @param securityGroup Security group of the load balancer this listener is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of SecurityGroupAllowsAllOutbound
         * @param securityGroupAllowsAllOutbound Whether the imported security group allows all outbound traffic or not when imported using `securityGroupId`.
         * @return {@code this}
         * @deprecated use `securityGroup` instead
         */
        @Deprecated
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        public Builder securityGroupAllowsAllOutbound(java.lang.Boolean securityGroupAllowsAllOutbound) {
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
            return this;
        }

        /**
         * Sets the value of SecurityGroupId
         * @param securityGroupId Security group ID of the load balancer this listener is associated with.
         * @return {@code this}
         * @deprecated use `securityGroup` instead
         */
        @Deprecated
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        public Builder securityGroupId(java.lang.String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationListenerAttributes build() {
            return new Jsii$Proxy(listenerArn, defaultPort, securityGroup, securityGroupAllowsAllOutbound, securityGroupId);
        }
    }

    /**
     * An implementation for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerAttributes {
        private final java.lang.String listenerArn;
        private final java.lang.Number defaultPort;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.Boolean securityGroupAllowsAllOutbound;
        private final java.lang.String securityGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.listenerArn = this.jsiiGet("listenerArn", java.lang.String.class);
            this.defaultPort = this.jsiiGet("defaultPort", java.lang.Number.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.securityGroupAllowsAllOutbound = this.jsiiGet("securityGroupAllowsAllOutbound", java.lang.Boolean.class);
            this.securityGroupId = this.jsiiGet("securityGroupId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String listenerArn, java.lang.Number defaultPort, software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, java.lang.Boolean securityGroupAllowsAllOutbound, java.lang.String securityGroupId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listenerArn = java.util.Objects.requireNonNull(listenerArn, "listenerArn is required");
            this.defaultPort = defaultPort;
            this.securityGroup = securityGroup;
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
            this.securityGroupId = securityGroupId;
        }

        @Override
        public java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public java.lang.Number getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public java.lang.Boolean getSecurityGroupAllowsAllOutbound() {
            return this.securityGroupAllowsAllOutbound;
        }

        @Override
        public java.lang.String getSecurityGroupId() {
            return this.securityGroupId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("listenerArn", om.valueToTree(this.getListenerArn()));
            if (this.getDefaultPort() != null) {
                obj.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }
            if (this.getSecurityGroup() != null) {
                obj.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSecurityGroupAllowsAllOutbound() != null) {
                obj.set("securityGroupAllowsAllOutbound", om.valueToTree(this.getSecurityGroupAllowsAllOutbound()));
            }
            if (this.getSecurityGroupId() != null) {
                obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerAttributes.Jsii$Proxy that = (ApplicationListenerAttributes.Jsii$Proxy) o;

            if (!listenerArn.equals(that.listenerArn)) return false;
            if (this.defaultPort != null ? !this.defaultPort.equals(that.defaultPort) : that.defaultPort != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.securityGroupAllowsAllOutbound != null ? !this.securityGroupAllowsAllOutbound.equals(that.securityGroupAllowsAllOutbound) : that.securityGroupAllowsAllOutbound != null) return false;
            return this.securityGroupId != null ? this.securityGroupId.equals(that.securityGroupId) : that.securityGroupId == null;
        }

        @Override
        public int hashCode() {
            int result = this.listenerArn.hashCode();
            result = 31 * result + (this.defaultPort != null ? this.defaultPort.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.securityGroupAllowsAllOutbound != null ? this.securityGroupAllowsAllOutbound.hashCode() : 0);
            result = 31 * result + (this.securityGroupId != null ? this.securityGroupId.hashCode() : 0);
            return result;
        }
    }
}
