package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A Target Group for Application Load Balancers.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:26:31.916Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IApplicationTargetGroup extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup {

    /**
     * Add a load balancing target to this target group.
     * 
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget... targets);

    /**
     * Register a connectable as a member of this target group.
     * 
     * Don't call this directly. It will be called by load balancing targets.
     * 
     * @param connectable This parameter is required.
     * @param portRange
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable, final software.amazon.awscdk.services.ec2.Port portRange);

    /**
     * Register a connectable as a member of this target group.
     * 
     * Don't call this directly. It will be called by load balancing targets.
     * 
     * @param connectable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable);

    /**
     * Register a listener that is load balancing to this target group.
     * 
     * Don't call this directly. It will be called by listeners.
     * 
     * @param listener This parameter is required.
     * @param associatingConstruct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final software.amazon.awscdk.core.IConstruct associatingConstruct);

    /**
     * Register a listener that is load balancing to this target group.
     * 
     * Don't call this directly. It will be called by listeners.
     * 
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
        }

        /**
         * A token representing a list of ARNs of the load balancers that route traffic to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getLoadBalancerArns() {
            return this.jsiiGet("loadBalancerArns", java.lang.String.class);
        }

        /**
         * Return an object to depend on the listeners added to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.IDependable getLoadBalancerAttached() {
            return this.jsiiGet("loadBalancerAttached", software.amazon.awscdk.core.IDependable.class);
        }

        /**
         * ARN of the target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getTargetGroupArn() {
            return this.jsiiGet("targetGroupArn", java.lang.String.class);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Add a load balancing target to this target group.
         * 
         * @param targets This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget... targets) {
            this.jsiiCall("addTarget", Void.class, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
        }

        /**
         * Register a connectable as a member of this target group.
         * 
         * Don't call this directly. It will be called by load balancing targets.
         * 
         * @param connectable This parameter is required.
         * @param portRange
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable, final software.amazon.awscdk.services.ec2.Port portRange) {
            this.jsiiCall("registerConnectable", Void.class, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required"), portRange });
        }

        /**
         * Register a connectable as a member of this target group.
         * 
         * Don't call this directly. It will be called by load balancing targets.
         * 
         * @param connectable This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable) {
            this.jsiiCall("registerConnectable", Void.class, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required") });
        }

        /**
         * Register a listener that is load balancing to this target group.
         * 
         * Don't call this directly. It will be called by listeners.
         * 
         * @param listener This parameter is required.
         * @param associatingConstruct
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final software.amazon.awscdk.core.IConstruct associatingConstruct) {
            this.jsiiCall("registerListener", Void.class, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required"), associatingConstruct });
        }

        /**
         * Register a listener that is load balancing to this target group.
         * 
         * Don't call this directly. It will be called by listeners.
         * 
         * @param listener This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            this.jsiiCall("registerListener", Void.class, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
        }
    }
}
