/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.elasticloadbalancingv2.;
import software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticloadbalancingv2.CfnListener")
public class CfnListener
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnListener.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnListener(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnListener(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnListener(Construct scope, String id, CfnListenerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public Object getDefaultActions() {
        return this.jsiiGet("defaultActions", Object.class);
    }

    public void setDefaultActions(IResolvable value) {
        this.jsiiSet("defaultActions", Objects.requireNonNull(value, "defaultActions is required"));
    }

    public void setDefaultActions(List<Object> value) {
        this.jsiiSet("defaultActions", Objects.requireNonNull(value, "defaultActions is required"));
    }

    public String getLoadBalancerArn() {
        return (String)this.jsiiGet("loadBalancerArn", String.class);
    }

    public void setLoadBalancerArn(String value) {
        this.jsiiSet("loadBalancerArn", Objects.requireNonNull(value, "loadBalancerArn is required"));
    }

    public Number getPort() {
        return (Number)this.jsiiGet("port", Number.class);
    }

    public void setPort(Number value) {
        this.jsiiSet("port", Objects.requireNonNull(value, "port is required"));
    }

    public String getProtocol() {
        return (String)this.jsiiGet("protocol", String.class);
    }

    public void setProtocol(String value) {
        this.jsiiSet("protocol", Objects.requireNonNull(value, "protocol is required"));
    }

    public Object getCertificates() {
        return this.jsiiGet("certificates", Object.class);
    }

    public void setCertificates(IResolvable value) {
        this.jsiiSet("certificates", value);
    }

    public void setCertificates(List<Object> value) {
        this.jsiiSet("certificates", value);
    }

    public String getSslPolicy() {
        return (String)this.jsiiGet("sslPolicy", String.class);
    }

    public void setSslPolicy(String value) {
        this.jsiiSet("sslPolicy", value);
    }

    public static interface RedirectConfigProperty
    extends JsiiSerializable {
        public String getStatusCode();

        public String getHost();

        public String getPath();

        public String getPort();

        public String getProtocol();

        public String getQuery();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String statusCode;
            private String host;
            private String path;
            private String port;
            private String protocol;
            private String query;

            public Builder statusCode(String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder query(String query) {
                this.query = query;
                return this;
            }

            public RedirectConfigProperty build() {
                return new Jsii.Proxy(this.statusCode, this.host, this.path, this.port, this.protocol, this.query, null);
            }
        }
    }

    public static interface FixedResponseConfigProperty
    extends JsiiSerializable {
        public String getStatusCode();

        public String getContentType();

        public String getMessageBody();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String statusCode;
            private String contentType;
            private String messageBody;

            public Builder statusCode(String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Builder messageBody(String messageBody) {
                this.messageBody = messageBody;
                return this;
            }

            public FixedResponseConfigProperty build() {
                return new Jsii.Proxy(this.statusCode, this.contentType, this.messageBody, null);
            }
        }
    }

    public static interface CertificateProperty
    extends JsiiSerializable {
        public String getCertificateArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String certificateArn;

            public Builder certificateArn(String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            public CertificateProperty build() {
                return new Jsii.Proxy(this.certificateArn, null);
            }
        }
    }

    public static interface AuthenticateOidcConfigProperty
    extends JsiiSerializable {
        public String getAuthorizationEndpoint();

        public String getClientId();

        public String getClientSecret();

        public String getIssuer();

        public String getTokenEndpoint();

        public String getUserInfoEndpoint();

        public Object getAuthenticationRequestExtraParams();

        public String getOnUnauthenticatedRequest();

        public String getScope();

        public String getSessionCookieName();

        public Number getSessionTimeout();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String authorizationEndpoint;
            private String clientId;
            private String clientSecret;
            private String issuer;
            private String tokenEndpoint;
            private String userInfoEndpoint;
            private Object authenticationRequestExtraParams;
            private String onUnauthenticatedRequest;
            private String scope;
            private String sessionCookieName;
            private Number sessionTimeout;

            public Builder authorizationEndpoint(String authorizationEndpoint) {
                this.authorizationEndpoint = authorizationEndpoint;
                return this;
            }

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder clientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            public Builder issuer(String issuer) {
                this.issuer = issuer;
                return this;
            }

            public Builder tokenEndpoint(String tokenEndpoint) {
                this.tokenEndpoint = tokenEndpoint;
                return this;
            }

            public Builder userInfoEndpoint(String userInfoEndpoint) {
                this.userInfoEndpoint = userInfoEndpoint;
                return this;
            }

            public Builder authenticationRequestExtraParams(IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            public Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            public Builder onUnauthenticatedRequest(String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public Builder sessionCookieName(String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            public Builder sessionTimeout(Number sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            public AuthenticateOidcConfigProperty build() {
                return new Jsii.Proxy(this.authorizationEndpoint, this.clientId, this.clientSecret, this.issuer, this.tokenEndpoint, this.userInfoEndpoint, this.authenticationRequestExtraParams, this.onUnauthenticatedRequest, this.scope, this.sessionCookieName, this.sessionTimeout, null);
            }
        }
    }

    public static interface AuthenticateCognitoConfigProperty
    extends JsiiSerializable {
        public String getUserPoolArn();

        public String getUserPoolClientId();

        public String getUserPoolDomain();

        public Object getAuthenticationRequestExtraParams();

        public String getOnUnauthenticatedRequest();

        public String getScope();

        public String getSessionCookieName();

        public Number getSessionTimeout();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String userPoolArn;
            private String userPoolClientId;
            private String userPoolDomain;
            private Object authenticationRequestExtraParams;
            private String onUnauthenticatedRequest;
            private String scope;
            private String sessionCookieName;
            private Number sessionTimeout;

            public Builder userPoolArn(String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            public Builder userPoolClientId(String userPoolClientId) {
                this.userPoolClientId = userPoolClientId;
                return this;
            }

            public Builder userPoolDomain(String userPoolDomain) {
                this.userPoolDomain = userPoolDomain;
                return this;
            }

            public Builder authenticationRequestExtraParams(IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            public Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            public Builder onUnauthenticatedRequest(String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public Builder sessionCookieName(String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            public Builder sessionTimeout(Number sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            public AuthenticateCognitoConfigProperty build() {
                return new Jsii.Proxy(this.userPoolArn, this.userPoolClientId, this.userPoolDomain, this.authenticationRequestExtraParams, this.onUnauthenticatedRequest, this.scope, this.sessionCookieName, this.sessionTimeout, null);
            }
        }
    }

    public static interface ActionProperty
    extends JsiiSerializable {
        public String getType();

        public Object getAuthenticateCognitoConfig();

        public Object getAuthenticateOidcConfig();

        public Object getFixedResponseConfig();

        public Number getOrder();

        public Object getRedirectConfig();

        public String getTargetGroupArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String type;
            private Object authenticateCognitoConfig;
            private Object authenticateOidcConfig;
            private Object fixedResponseConfig;
            private Number order;
            private Object redirectConfig;
            private String targetGroupArn;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder authenticateCognitoConfig(IResolvable authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            public Builder authenticateCognitoConfig(AuthenticateCognitoConfigProperty authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            public Builder authenticateOidcConfig(IResolvable authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            public Builder authenticateOidcConfig(AuthenticateOidcConfigProperty authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            public Builder fixedResponseConfig(IResolvable fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            public Builder fixedResponseConfig(FixedResponseConfigProperty fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            public Builder order(Number order) {
                this.order = order;
                return this;
            }

            public Builder redirectConfig(IResolvable redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            public Builder redirectConfig(RedirectConfigProperty redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            public Builder targetGroupArn(String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            public ActionProperty build() {
                return new Jsii.Proxy(this.type, this.authenticateCognitoConfig, this.authenticateOidcConfig, this.fixedResponseConfig, this.order, this.redirectConfig, this.targetGroupArn, null);
            }
        }
    }
}

