package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define a new listener rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * ApplicationListener applicationListener;
 * ApplicationTargetGroup applicationTargetGroup;
 * ListenerAction listenerAction;
 * ListenerCondition listenerCondition;
 * ApplicationListenerRule applicationListenerRule = ApplicationListenerRule.Builder.create(this, "MyApplicationListenerRule")
 *         .listener(applicationListener)
 *         .priority(123)
 *         // the properties below are optional
 *         .action(listenerAction)
 *         .conditions(List.of(listenerCondition))
 *         .fixedResponse(FixedResponse.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .contentType(ContentType.TEXT_PLAIN)
 *                 .messageBody("messageBody")
 *                 .build())
 *         .hostHeader("hostHeader")
 *         .pathPattern("pathPattern")
 *         .pathPatterns(List.of("pathPatterns"))
 *         .redirectResponse(RedirectResponse.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .host("host")
 *                 .path("path")
 *                 .port("port")
 *                 .protocol("protocol")
 *                 .query("query")
 *                 .build())
 *         .targetGroups(List.of(applicationTargetGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-03-26T16:25:29.908Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerRule")
public class ApplicationListenerRule extends software.amazon.awscdk.core.Construct {

    protected ApplicationListenerRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationListenerRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationListenerRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a non-standard condition to this rule.
     * <p>
     * @param condition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCondition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition condition) {
        software.amazon.jsii.Kernel.call(this, "addCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(condition, "condition is required") });
    }

    /**
     * (deprecated) Add a fixed response.
     * <p>
     * @deprecated Use configureAction instead
     * @param fixedResponse This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void addFixedResponse(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse) {
        software.amazon.jsii.Kernel.call(this, "addFixedResponse", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(fixedResponse, "fixedResponse is required") });
    }

    /**
     * (deprecated) Add a redirect response.
     * <p>
     * @deprecated Use configureAction instead
     * @param redirectResponse This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void addRedirectResponse(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse) {
        software.amazon.jsii.Kernel.call(this, "addRedirectResponse", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(redirectResponse, "redirectResponse is required") });
    }

    /**
     * (deprecated) Add a TargetGroup to load balance to.
     * <p>
     * @deprecated Use configureAction instead
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void addTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
        software.amazon.jsii.Kernel.call(this, "addTargetGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Configure the action to perform for this rule.
     * <p>
     * @param action This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void configureAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action) {
        software.amazon.jsii.Kernel.call(this, "configureAction", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(action, "action is required") });
    }

    /**
     * (deprecated) Add a non-standard condition to this rule.
     * <p>
     * If the condition conflicts with an already set condition, it will be overwritten by the one you specified.
     * <p>
     * @deprecated use `addCondition` instead.
     * @param field This parameter is required.
     * @param values
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setCondition(final @org.jetbrains.annotations.NotNull java.lang.String field, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> values) {
        software.amazon.jsii.Kernel.call(this, "setCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(field, "field is required"), values });
    }

    /**
     * (deprecated) Add a non-standard condition to this rule.
     * <p>
     * If the condition conflicts with an already set condition, it will be overwritten by the one you specified.
     * <p>
     * @deprecated use `addCondition` instead.
     * @param field This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setCondition(final @org.jetbrains.annotations.NotNull java.lang.String field) {
        software.amazon.jsii.Kernel.call(this, "setCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(field, "field is required") });
    }

    /**
     * Validate the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The ARN of this rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getListenerRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "listenerRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRuleProps.Builder();
        }

        /**
         * Priority of the rule.
         * <p>
         * The rule with the lowest priority will be used for every request.
         * <p>
         * Priorities must be unique.
         * <p>
         * @return {@code this}
         * @param priority Priority of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props.priority(priority);
            return this;
        }

        /**
         * Action to perform when requests are received.
         * <p>
         * Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * <p>
         * Default: - No action
         * <p>
         * @return {@code this}
         * @param action Action to perform when requests are received. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action) {
            this.props.action(action);
            return this;
        }

        /**
         * Rule applies if matches the conditions.
         * <p>
         * Default: - No conditions.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html
         * @param conditions Rule applies if matches the conditions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions) {
            this.props.conditions(conditions);
            return this;
        }

        /**
         * (deprecated) Fixed response to return.
         * <p>
         * Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * <p>
         * Default: - No fixed response.
         * <p>
         * @return {@code this}
         * @deprecated Use `action` instead.
         * @param fixedResponse Fixed response to return. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder fixedResponse(final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse) {
            this.props.fixedResponse(fixedResponse);
            return this;
        }

        /**
         * (deprecated) Rule applies if the requested host matches the indicated host.
         * <p>
         * May contain up to three '*' wildcards.
         * <p>
         * Default: - No host condition.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         * @deprecated Use `conditions` instead.
         * @param hostHeader Rule applies if the requested host matches the indicated host. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder hostHeader(final java.lang.String hostHeader) {
            this.props.hostHeader(hostHeader);
            return this;
        }

        /**
         * (deprecated) Rule applies if the requested path matches the given path pattern.
         * <p>
         * Default: - No path condition.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         * @deprecated Use `conditions` instead.
         * @param pathPattern Rule applies if the requested path matches the given path pattern. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPattern(final java.lang.String pathPattern) {
            this.props.pathPattern(pathPattern);
            return this;
        }

        /**
         * (deprecated) Rule applies if the requested path matches any of the given patterns.
         * <p>
         * Paths may contain up to three '*' wildcards.
         * <p>
         * Default: - No path conditions.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         * @deprecated Use `conditions` instead.
         * @param pathPatterns Rule applies if the requested path matches any of the given patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPatterns(final java.util.List<java.lang.String> pathPatterns) {
            this.props.pathPatterns(pathPatterns);
            return this;
        }

        /**
         * (deprecated) Redirect response to return.
         * <p>
         * Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * <p>
         * Default: - No redirect response.
         * <p>
         * @return {@code this}
         * @deprecated Use `action` instead.
         * @param redirectResponse Redirect response to return. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder redirectResponse(final software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse) {
            this.props.redirectResponse(redirectResponse);
            return this;
        }

        /**
         * Target groups to forward requests to.
         * <p>
         * Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * <p>
         * Implies a <code>forward</code> action.
         * <p>
         * Default: - No target groups.
         * <p>
         * @return {@code this}
         * @param targetGroups Target groups to forward requests to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            this.props.targetGroups(targetGroups);
            return this;
        }

        /**
         * The listener to attach the rule to.
         * <p>
         * @return {@code this}
         * @param listener The listener to attach the rule to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            this.props.listener(listener);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRule build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
