package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for a new Network Target Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.core.*;
 * INetworkLoadBalancerTarget networkLoadBalancerTarget;
 * Vpc vpc;
 * NetworkTargetGroupProps networkTargetGroupProps = NetworkTargetGroupProps.builder()
 *         .port(123)
 *         // the properties below are optional
 *         .deregistrationDelay(Duration.minutes(30))
 *         .healthCheck(HealthCheck.builder()
 *                 .enabled(false)
 *                 .healthyGrpcCodes("healthyGrpcCodes")
 *                 .healthyHttpCodes("healthyHttpCodes")
 *                 .healthyThresholdCount(123)
 *                 .interval(Duration.minutes(30))
 *                 .path("path")
 *                 .port("port")
 *                 .protocol(Protocol.HTTP)
 *                 .timeout(Duration.minutes(30))
 *                 .unhealthyThresholdCount(123)
 *                 .build())
 *         .preserveClientIp(false)
 *         .protocol(Protocol.HTTP)
 *         .proxyProtocolV2(false)
 *         .targetGroupName("targetGroupName")
 *         .targets(List.of(networkLoadBalancerTarget))
 *         .targetType(TargetType.INSTANCE)
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-04T20:14:13.727Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkTargetGroupProps")
@software.amazon.jsii.Jsii.Proxy(NetworkTargetGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkTargetGroupProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps {

    /**
     * The port on which the listener listens for requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPort();

    /**
     * Indicates whether client IP preservation is enabled.
     * <p>
     * Default: false if the target group type is IP address and the
     * target group protocol is TCP or TLS. Otherwise, true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreserveClientIp() {
        return null;
    }

    /**
     * Protocol for target group, expects TCP, TLS, UDP, or TCP_UDP.
     * <p>
     * Default: - TCP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
        return null;
    }

    /**
     * Indicates whether Proxy Protocol version 2 is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getProxyProtocolV2() {
        return null;
    }

    /**
     * The targets to add to this target group.
     * <p>
     * Can be <code>Instance</code>, <code>IPAddress</code>, or any self-registering load balancing
     * target. If you use either <code>Instance</code> or <code>IPAddress</code> as targets, all
     * target must be of the same type.
     * <p>
     * Default: - No targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkTargetGroupProps> {
        java.lang.Number port;
        java.lang.Boolean preserveClientIp;
        software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol;
        java.lang.Boolean proxyProtocolV2;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets;
        software.amazon.awscdk.core.Duration deregistrationDelay;
        software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        java.lang.String targetGroupName;
        software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getPort}
         * @param port The port on which the listener listens for requests. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getPreserveClientIp}
         * @param preserveClientIp Indicates whether client IP preservation is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveClientIp(java.lang.Boolean preserveClientIp) {
            this.preserveClientIp = preserveClientIp;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getProtocol}
         * @param protocol Protocol for target group, expects TCP, TLS, UDP, or TCP_UDP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getProxyProtocolV2}
         * @param proxyProtocolV2 Indicates whether Proxy Protocol version 2 is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyProtocolV2(java.lang.Boolean proxyProtocolV2) {
            this.proxyProtocolV2 = proxyProtocolV2;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getTargets}
         * @param targets The targets to add to this target group.
         *                Can be <code>Instance</code>, <code>IPAddress</code>, or any self-registering load balancing
         *                target. If you use either <code>Instance</code> or <code>IPAddress</code> as targets, all
         *                target must be of the same type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targets(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets) {
            this.targets = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget>)targets;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getDeregistrationDelay}
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target.
         *                            The range is 0-3600 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(software.amazon.awscdk.core.Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getHealthCheck}
         * @param healthCheck Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getTargetGroupName}
         * @param targetGroupName The name of the target group.
         *                        This name must be unique per region per account, can have a maximum of
         *                        32 characters, must contain only alphanumeric characters or hyphens, and
         *                        must not begin or end with a hyphen.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(java.lang.String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getTargetType}
         * @param targetType The type of targets registered to this TargetGroup, either IP or Instance.
         *                   All targets registered into the group must be of this type. If you
         *                   register targets to the TargetGroup in the CDK app, the TargetType is
         *                   determined automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetGroupProps#getVpc}
         * @param vpc The virtual private cloud (VPC).
         *            only if <code>TargetType</code> is <code>Ip</code> or <code>InstanceId</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkTargetGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkTargetGroupProps {
        private final java.lang.Number port;
        private final java.lang.Boolean preserveClientIp;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol;
        private final java.lang.Boolean proxyProtocolV2;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets;
        private final software.amazon.awscdk.core.Duration deregistrationDelay;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private final java.lang.String targetGroupName;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preserveClientIp = software.amazon.jsii.Kernel.get(this, "preserveClientIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol.class));
            this.proxyProtocolV2 = software.amazon.jsii.Kernel.get(this, "proxyProtocolV2", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget.class)));
            this.deregistrationDelay = software.amazon.jsii.Kernel.get(this, "deregistrationDelay", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class));
            this.targetGroupName = software.amazon.jsii.Kernel.get(this, "targetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetType = software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            this.preserveClientIp = builder.preserveClientIp;
            this.protocol = builder.protocol;
            this.proxyProtocolV2 = builder.proxyProtocolV2;
            this.targets = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget>)builder.targets;
            this.deregistrationDelay = builder.deregistrationDelay;
            this.healthCheck = builder.healthCheck;
            this.targetGroupName = builder.targetGroupName;
            this.targetType = builder.targetType;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.Boolean getPreserveClientIp() {
            return this.preserveClientIp;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.Boolean getProxyProtocolV2() {
            return this.proxyProtocolV2;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
            return this.targets;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.deregistrationDelay;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.targetType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("port", om.valueToTree(this.getPort()));
            if (this.getPreserveClientIp() != null) {
                data.set("preserveClientIp", om.valueToTree(this.getPreserveClientIp()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getProxyProtocolV2() != null) {
                data.set("proxyProtocolV2", om.valueToTree(this.getProxyProtocolV2()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }
            if (this.getDeregistrationDelay() != null) {
                data.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getTargetGroupName() != null) {
                data.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
            }
            if (this.getTargetType() != null) {
                data.set("targetType", om.valueToTree(this.getTargetType()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.NetworkTargetGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkTargetGroupProps.Jsii$Proxy that = (NetworkTargetGroupProps.Jsii$Proxy) o;

            if (!port.equals(that.port)) return false;
            if (this.preserveClientIp != null ? !this.preserveClientIp.equals(that.preserveClientIp) : that.preserveClientIp != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.proxyProtocolV2 != null ? !this.proxyProtocolV2.equals(that.proxyProtocolV2) : that.proxyProtocolV2 != null) return false;
            if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) return false;
            if (this.deregistrationDelay != null ? !this.deregistrationDelay.equals(that.deregistrationDelay) : that.deregistrationDelay != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.targetGroupName != null ? !this.targetGroupName.equals(that.targetGroupName) : that.targetGroupName != null) return false;
            if (this.targetType != null ? !this.targetType.equals(that.targetType) : that.targetType != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.port.hashCode();
            result = 31 * result + (this.preserveClientIp != null ? this.preserveClientIp.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.proxyProtocolV2 != null ? this.proxyProtocolV2.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            result = 31 * result + (this.deregistrationDelay != null ? this.deregistrationDelay.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.targetGroupName != null ? this.targetGroupName.hashCode() : 0);
            result = 31 * result + (this.targetType != null ? this.targetType.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
