package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define an ApplicationListener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.3 (build 26aa77c)", date = "2019-11-12T00:10:05.401Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationListener")
public class ApplicationListener extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseListener implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener {

    protected ApplicationListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationListener(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing listener.
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener fromApplicationListenerAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class, "fromApplicationListenerAttributes", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add one or more certificates to this listener.
     * 
     * After the first certificate, this creates ApplicationListenerCertificates
     * resources since cloudformation requires the certificates array on the
     * listener resource to have a length of 1.
     * 
     * @param id This parameter is required.
     * @param arns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addCertificateArns(final java.lang.String id, final java.util.List<java.lang.String> arns) {
        this.jsiiCall("addCertificateArns", Void.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arns, "arns is required") });
    }

    /**
     * Add a fixed response.
     * 
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFixedResponse(final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.AddFixedResponseProps props) {
        this.jsiiCall("addFixedResponse", Void.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a redirect response.
     * 
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addRedirectResponse(final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.AddRedirectResponseProps props) {
        this.jsiiCall("addRedirectResponse", Void.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Load balance incoming requests to the given target groups.
     * 
     * It's possible to add conditions to the TargetGroups added in this way.
     * At least one TargetGroup must be added without conditions.
     * 
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addTargetGroups(final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps props) {
        this.jsiiCall("addTargetGroups", Void.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Load balance incoming requests to the given load balancing targets.
     * 
     * This method implicitly creates an ApplicationTargetGroup for the targets
     * involved.
     * 
     * It's possible to add conditions to the targets added in this way. At least
     * one set of targets must be added without conditions.
     * 
     * @return The newly created target group
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup addTargets(final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps props) {
        return this.jsiiCall("addTargets", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Register that a connectable that has been added to this load balancer.
     * 
     * Don't call this directly. It is called by ApplicationTargetGroup.
     * 
     * @param connectable This parameter is required.
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable, final software.amazon.awscdk.services.ec2.Port portRange) {
        this.jsiiCall("registerConnectable", Void.class, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Validate this listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * Manage connections to this ApplicationListener.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * Load balancer this listener is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer getLoadBalancer() {
        return this.jsiiGet("loadBalancer", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerProps.Builder();
        }

        /**
         * @return {@code this}
         * @param certificateArns The certificates to use on this listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateArns(final java.util.List<java.lang.String> certificateArns) {
            this.props.certificateArns(certificateArns);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultTargetGroups Default target groups to load balance to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups) {
            this.props.defaultTargetGroups(defaultTargetGroups);
            return this;
        }

        /**
         * @return {@code this}
         * @param open Allow anyone to connect to this listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(final java.lang.Boolean open) {
            this.props.open(open);
            return this;
        }

        /**
         * @return {@code this}
         * @param port The port on which the listener listens for requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * @return {@code this}
         * @param protocol The protocol to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * @return {@code this}
         * @param sslPolicy The security policy that defines which ciphers and protocols are supported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        /**
         * @return {@code this}
         * @param loadBalancer The load balancer to attach this listener to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
