package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define an Application Load Balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:31.946Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationLoadBalancer")
public class ApplicationLoadBalancer extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer {

    protected ApplicationLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationLoadBalancer(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing Application Load Balancer.
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer fromApplicationLoadBalancerAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer.class, "fromApplicationLoadBalancerAttributes", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a new listener to this load balancer.
     * 
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener addListener(final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps props) {
        return this.jsiiCall("addListener", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable access logging for this load balancer.
     * 
     * @param bucket This parameter is required.
     * @param prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void logAccessLogs(final software.amazon.awscdk.services.s3.IBucket bucket, final java.lang.String prefix) {
        this.jsiiCall("logAccessLogs", Void.class, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), prefix });
    }

    /**
     * Enable access logging for this load balancer.
     * 
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void logAccessLogs(final software.amazon.awscdk.services.s3.IBucket bucket) {
        this.jsiiCall("logAccessLogs", Void.class, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Return the given named metric for this Application Load Balancer.
     * 
     * Default: Average over 5 minutes
     * 
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName, final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Application Load Balancer.
     * 
     * Default: Average over 5 minutes
     * 
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricActiveConnectionCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricActiveConnectionCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricActiveConnectionCount() {
        return this.jsiiCall("metricActiveConnectionCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     * 
     * Possible causes include a
     * mismatch of ciphers or protocols.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricClientTlsNegotiationErrorCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricClientTlsNegotiationErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     * 
     * Possible causes include a
     * mismatch of ciphers or protocols.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricClientTlsNegotiationErrorCount() {
        return this.jsiiCall("metricClientTlsNegotiationErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of load balancer capacity units (LCU) used by your load balancer.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricConsumedLCUs", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of load balancer capacity units (LCU) used by your load balancer.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs() {
        return this.jsiiCall("metricConsumedLCUs", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of user authentications that could not be completed.
     * 
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthError(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricElbAuthError", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of user authentications that could not be completed.
     * 
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthError() {
        return this.jsiiCall("metricElbAuthError", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthFailure(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricElbAuthFailure", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthFailure() {
        return this.jsiiCall("metricElbAuthFailure", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     * 
     * If one or more of these operations fail, this is the time to failure.
     * 
     * Default: Average over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthLatency(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricElbAuthLatency", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     * 
     * If one or more of these operations fail, this is the time to failure.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthLatency() {
        return this.jsiiCall("metricElbAuthLatency", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of authenticate actions that were successful.
     * 
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthSuccess(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricElbAuthSuccess", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of authenticate actions that were successful.
     * 
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthSuccess() {
        return this.jsiiCall("metricElbAuthSuccess", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     * 
     * This does not include any response codes generated by the targets.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeElb(final software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code, final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHttpCodeElb", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
    }

    /**
     * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     * 
     * This does not include any response codes generated by the targets.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeElb(final software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code) {
        return this.jsiiCall("metricHttpCodeElb", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     * 
     * This does not include any response codes generated by the load balancer.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHttpCodeTarget", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
    }

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     * 
     * This does not include any response codes generated by the load balancer.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code) {
        return this.jsiiCall("metricHttpCodeTarget", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * The number of fixed-response actions that were successful.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpFixedResponseCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHttpFixedResponseCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of fixed-response actions that were successful.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpFixedResponseCount() {
        return this.jsiiCall("metricHttpFixedResponseCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of redirect actions that were successful.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHttpRedirectCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of redirect actions that were successful.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectCount() {
        return this.jsiiCall("metricHttpRedirectCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectUrlLimitExceededCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHttpRedirectUrlLimitExceededCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectUrlLimitExceededCount() {
        return this.jsiiCall("metricHttpRedirectUrlLimitExceededCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The total number of bytes processed by the load balancer over IPv6.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricIpv6ProcessedBytes(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricIpv6ProcessedBytes", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of bytes processed by the load balancer over IPv6.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricIpv6ProcessedBytes() {
        return this.jsiiCall("metricIpv6ProcessedBytes", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of IPv6 requests received by the load balancer.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricIpv6RequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of IPv6 requests received by the load balancer.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount() {
        return this.jsiiCall("metricIpv6RequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricNewConnectionCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricNewConnectionCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricNewConnectionCount() {
        return this.jsiiCall("metricNewConnectionCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The total number of bytes processed by the load balancer over IPv4 and IPv6.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricProcessedBytes", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of bytes processed by the load balancer over IPv4 and IPv6.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes() {
        return this.jsiiCall("metricProcessedBytes", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRejectedConnectionCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricRejectedConnectionCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRejectedConnectionCount() {
        return this.jsiiCall("metricRejectedConnectionCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of requests processed over IPv4 and IPv6.
     * 
     * This count includes only the requests with a response generated by a target of the load balancer.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricRequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of requests processed over IPv4 and IPv6.
     * 
     * This count includes only the requests with a response generated by a target of the load balancer.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount() {
        return this.jsiiCall("metricRequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of rules processed by the load balancer given a request rate averaged over an hour.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRuleEvaluations(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricRuleEvaluations", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of rules processed by the load balancer given a request rate averaged over an hour.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRuleEvaluations() {
        return this.jsiiCall("metricRuleEvaluations", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTargetConnectionErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount() {
        return this.jsiiCall("metricTargetConnectionErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * 
     * Default: Average over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTargetResponseTime", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * 
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime() {
        return this.jsiiCall("metricTargetResponseTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * 
     * Possible causes include a mismatch of ciphers or protocols.
     * 
     * Default: Sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTargetTLSNegotiationErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * 
     * Possible causes include a mismatch of ciphers or protocols.
     * 
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount() {
        return this.jsiiCall("metricTargetTLSNegotiationErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps.Builder();
        }

        /**
         * @return {@code this}
         * @param vpc The VPC network to place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @return {@code this}
         * @param deletionProtection Indicates whether deletion protection is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * @return {@code this}
         * @param internetFacing Whether the load balancer has an internet-routable address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(final java.lang.Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        /**
         * @return {@code this}
         * @param loadBalancerName Name of the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(final java.lang.String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpcSubnets Where in the VPC to place the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @return {@code this}
         * @param http2Enabled Indicates whether HTTP/2 is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder http2Enabled(final java.lang.Boolean http2Enabled) {
            this.props.http2Enabled(http2Enabled);
            return this;
        }

        /**
         * @return {@code this}
         * @param idleTimeout The load balancer idle timeout, in seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleTimeout(final software.amazon.awscdk.core.Duration idleTimeout) {
            this.props.idleTimeout(idleTimeout);
            return this;
        }

        /**
         * @return {@code this}
         * @param ipAddressType The type of IP addresses to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        /**
         * @return {@code this}
         * @param securityGroup Security group to associate with this load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
