package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties of both Application and Network Target Groups.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:31.955Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.BaseTargetGroupProps")
@software.amazon.jsii.Jsii.Proxy(BaseTargetGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseTargetGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0-3600 seconds.
     * 
     * Default: 300
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.Duration getDeregistrationDelay() {
        return null;
    }

    /**
     * Health check configuration.
     * 
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * 
     * Default: - Automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getTargetGroupName() {
        return null;
    }

    /**
     * The type of targets registered to this TargetGroup, either IP or Instance.
     * 
     * All targets registered into the group must be of this type. If you
     * register targets to the TargetGroup in the CDK app, the TargetType is
     * determined automatically.
     * 
     * Default: - Determined automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
        return null;
    }

    /**
     * The virtual private cloud (VPC).
     * 
     * only if `TargetType` is `Ip` or `InstanceId`
     * 
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.core.Duration deregistrationDelay;
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private java.lang.String targetGroupName;
        private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of DeregistrationDelay
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(software.amazon.awscdk.core.Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        /**
         * Sets the value of HealthCheck
         * @param healthCheck Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of TargetGroupName
         * @param targetGroupName The name of the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(java.lang.String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        /**
         * Sets the value of TargetType
         * @param targetType The type of targets registered to this TargetGroup, either IP or Instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of Vpc
         * @param vpc The virtual private cloud (VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BaseTargetGroupProps build() {
            return new Jsii$Proxy(deregistrationDelay, healthCheck, targetGroupName, targetType, vpc);
        }
    }

    /**
     * An implementation for {@link BaseTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseTargetGroupProps {
        private final software.amazon.awscdk.core.Duration deregistrationDelay;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private final java.lang.String targetGroupName;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deregistrationDelay = this.jsiiGet("deregistrationDelay", software.amazon.awscdk.core.Duration.class);
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
            this.targetGroupName = this.jsiiGet("targetGroupName", java.lang.String.class);
            this.targetType = this.jsiiGet("targetType", software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.core.Duration deregistrationDelay, final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck, final java.lang.String targetGroupName, final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deregistrationDelay = deregistrationDelay;
            this.healthCheck = healthCheck;
            this.targetGroupName = targetGroupName;
            this.targetType = targetType;
            this.vpc = vpc;
        }

        @Override
        public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.deregistrationDelay;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.targetType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeregistrationDelay() != null) {
                data.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getTargetGroupName() != null) {
                data.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
            }
            if (this.getTargetType() != null) {
                data.set("targetType", om.valueToTree(this.getTargetType()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.BaseTargetGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseTargetGroupProps.Jsii$Proxy that = (BaseTargetGroupProps.Jsii$Proxy) o;

            if (this.deregistrationDelay != null ? !this.deregistrationDelay.equals(that.deregistrationDelay) : that.deregistrationDelay != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.targetGroupName != null ? !this.targetGroupName.equals(that.targetGroupName) : that.targetGroupName != null) return false;
            if (this.targetType != null ? !this.targetType.equals(that.targetType) : that.targetType != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.deregistrationDelay != null ? this.deregistrationDelay.hashCode() : 0;
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.targetGroupName != null ? this.targetGroupName.hashCode() : 0);
            result = 31 * result + (this.targetType != null ? this.targetType.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
